/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.hdf5export;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.WriteSequenceToHdf5;
import bdv.ij.export.imgloader.ImagePlusImgLoader;
import bdv.ij.util.PluginHelper;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.hdf5.Hdf5ImageLoader;
import bdv.img.hdf5.Partition;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.ChannelSplitter;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;
import spimdata.util.Displaysettings;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Export Current Image as XML/HDF5 (Devils)")
public class ExportDevilsHdf5
implements Command {
    static boolean lastSetMipmapManual = false;
    static String lastSubsampling = "{1,1,1}, {2,2,1}, {4,4,2}";
    static String lastChunkSizes = "{32,32,4}, {16,16,8}, {8,8,8}";
    static int lastMinMaxChoice = 2;
    static double lastMin = 0.0;
    static double lastMax = 65535.0;
    static boolean lastSplit = false;
    static int lastTimepointsPerPartition = 0;
    static int lastSetupsPerPartition = 0;
    static boolean lastDeflate = true;
    static String lastExportPath = "./export.xml";

    public static void main(String[] args) {
        new ImageJ();
        IJ.run((String)"Confocal Series (2.2MB)");
        new ExportDevilsHdf5().run();
    }

    public void run() {
        ArrayList partitions;
        ImagePlusImgLoader imgLoader;
        ImagePlus imp;
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if ((imp = WindowManager.getCurrentImage()) == null) {
            IJ.showMessage((String)"Please open an image first.");
            return;
        }
        switch (imp.getType()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                IJ.showMessage((String)"Only 8, 16, 32-bit images are supported currently!");
                return;
            }
        }
        double pw = imp.getCalibration().pixelWidth;
        double ph = imp.getCalibration().pixelHeight;
        double pd = imp.getCalibration().pixelDepth;
        double xOffset = imp.getCalibration().xOrigin * pw;
        double yOffset = imp.getCalibration().yOrigin * ph;
        double zOffset = imp.getCalibration().zOrigin * pd;
        String punit = imp.getCalibration().getUnit();
        if (punit == null || punit.isEmpty()) {
            punit = "px";
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getNSlices();
        FinalDimensions size = new FinalDimensions(new int[]{w, h, d});
        ExportMipmapInfo autoMipmapSettings = ProposeMipmaps.proposeMipmaps((BasicViewSetup)new BasicViewSetup(0, "", (Dimensions)size, (VoxelDimensions)voxelSize));
        Parameters params = this.getParameters(imp.getDisplayRangeMin(), imp.getDisplayRangeMax(), autoMipmapSettings);
        if (params == null) {
            return;
        }
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        progressWriter.out().println("starting export...");
        switch (imp.getType()) {
            case 0: {
                imgLoader = ImagePlusImgLoader.createGray8((ImagePlus)imp, (ImagePlusImgLoader.MinMaxOption)params.minMaxOption, (double)params.rangeMin, (double)params.rangeMax);
                break;
            }
            case 1: {
                imgLoader = ImagePlusImgLoader.createGray16((ImagePlus)imp, (ImagePlusImgLoader.MinMaxOption)params.minMaxOption, (double)params.rangeMin, (double)params.rangeMax);
                break;
            }
            default: {
                imgLoader = ImagePlusImgLoader.createGray32((ImagePlus)imp, (ImagePlusImgLoader.MinMaxOption)params.minMaxOption, (double)params.rangeMin, (double)params.rangeMax);
            }
        }
        int numTimepoints = imp.getNFrames();
        int numSetups = imp.getNChannels();
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(pw, 0.0, 0.0, xOffset, 0.0, ph, 0.0, yOffset, 0.0, 0.0, pd, zOffset);
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        ImagePlus[] impSingleChannel = ChannelSplitter.split((ImagePlus)imp);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(s, String.format("channel %d", s + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(s + 1));
            Displaysettings ds = new Displaysettings(s + 1);
            ds.min = impSingleChannel[s].getDisplayRangeMin();
            ds.max = impSingleChannel[s].getDisplayRangeMax();
            if (imp.getType() == 4) {
                ds.isSet = false;
            } else {
                ds.isSet = true;
                LUT lut = impSingleChannel[s].getProcessor().getLut();
                ds.color = new int[]{lut.getRed(255), lut.getGreen(255), lut.getBlue(255), lut.getAlpha(255)};
            }
            setups.put(s, setup);
        }
        impSingleChannel = null;
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, (BasicImgLoader)imgLoader, null);
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        final boolean isVirtual = imp.getStack().isVirtual();
        final long planeSizeInBytes = imp.getWidth() * imp.getHeight() * imp.getBytesPerPixel();
        final long ijMaxMemory = IJ.maxMemory();
        int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
        ExportScalePyramid.LoopbackHeuristic loopbackHeuristic = new ExportScalePyramid.LoopbackHeuristic(){

            public boolean decide(RandomAccessibleInterval<?> originalImg, int[] factorsToOriginalImg, int previousLevel, int[] factorsToPreviousLevel, int[] chunkSize) {
                long requiredCacheSize;
                if (previousLevel < 0) {
                    return false;
                }
                if (Intervals.numElements((int[])factorsToOriginalImg) / Intervals.numElements((int[])factorsToPreviousLevel) >= 8L) {
                    return true;
                }
                return isVirtual && (requiredCacheSize = planeSizeInBytes * (long)factorsToOriginalImg[2] * (long)chunkSize[2]) > ijMaxMemory / 4L;
            }
        };
        ExportScalePyramid.AfterEachPlane afterEachPlane = new ExportScalePyramid.AfterEachPlane(){

            public void afterEachPlane(boolean usedLoopBack) {
                if (!usedLoopBack && isVirtual) {
                    long free = Runtime.getRuntime().freeMemory();
                    long total = Runtime.getRuntime().totalMemory();
                    long max = Runtime.getRuntime().maxMemory();
                    long actuallyFree = max - total + free;
                    if (actuallyFree < max / 2L) {
                        imgLoader.clearCache();
                    }
                }
            }
        };
        if (params.split) {
            String xmlFilename = params.seqFile.getAbsolutePath();
            String basename = xmlFilename.endsWith(".xml") ? xmlFilename.substring(0, xmlFilename.length() - 4) : xmlFilename;
            partitions = Partition.split(timepoints, (List)seq.getViewSetupsOrdered(), (int)params.timepointsPerPartition, (int)params.setupsPerPartition, (String)basename);
            for (int i = 0; i < partitions.size(); ++i) {
                Partition partition = (Partition)partitions.get(i);
                SubTaskProgressWriter p = new SubTaskProgressWriter((ProgressWriter)progressWriter, 0.0, 0.95 * (double)i / (double)partitions.size());
                WriteSequenceToHdf5.writeHdf5PartitionFile((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (boolean)params.deflate, (Partition)partition, (ExportScalePyramid.LoopbackHeuristic)loopbackHeuristic, (ExportScalePyramid.AfterEachPlane)afterEachPlane, (int)numCellCreatorThreads, (ProgressWriter)p);
            }
            WriteSequenceToHdf5.writeHdf5PartitionLinkFile((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (ArrayList)partitions, (File)params.hdf5File);
        } else {
            partitions = null;
            WriteSequenceToHdf5.writeHdf5File((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (boolean)params.deflate, (File)params.hdf5File, (ExportScalePyramid.LoopbackHeuristic)loopbackHeuristic, (ExportScalePyramid.AfterEachPlane)afterEachPlane, (int)numCellCreatorThreads, (ProgressWriter)new SubTaskProgressWriter((ProgressWriter)progressWriter, 0.0, 0.95));
        }
        Hdf5ImageLoader hdf5Loader = new Hdf5ImageLoader(params.hdf5File, partitions, null, false);
        SequenceDescriptionMinimal seqh5 = new SequenceDescriptionMinimal(seq, (BasicImgLoader)hdf5Loader);
        ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
        for (int t = 0; t < numTimepoints; ++t) {
            for (int s = 0; s < numSetups; ++s) {
                registrations.add(new ViewRegistration(t, s, sourceTransform));
            }
        }
        File basePath = params.seqFile.getParentFile();
        SpimDataMinimal spimData = new SpimDataMinimal(basePath, seqh5, new ViewRegistrations(registrations));
        try {
            new XmlIoSpimDataMinimal().save((AbstractSpimData)spimData, params.seqFile.getAbsolutePath());
            progressWriter.setProgress(1.0);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        progressWriter.out().println("done");
    }

    protected Parameters getParameters(double impMin, double impMax, ExportMipmapInfo autoMipmapSettings) {
        File seqFile;
        String seqFilename;
        ImagePlusImgLoader.MinMaxOption minMaxOption;
        int[][] subdivisions;
        int[][] resolutions;
        if (lastMinMaxChoice == 0) {
            lastMin = impMin;
            lastMax = impMax;
        }
        while (true) {
            File parent;
            final GenericDialogPlus gd = new GenericDialogPlus("Export for BigDataViewer");
            gd.addCheckbox("manual_mipmap_setup", lastSetMipmapManual);
            final Checkbox cManualMipmap = (Checkbox)gd.getCheckboxes().lastElement();
            gd.addStringField("Subsampling_factors", lastSubsampling, 25);
            final TextField tfSubsampling = (TextField)gd.getStringFields().lastElement();
            gd.addStringField("Hdf5_chunk_sizes", lastChunkSizes, 25);
            final TextField tfChunkSizes = (TextField)gd.getStringFields().lastElement();
            gd.addMessage("");
            String[] minMaxChoices = new String[]{"Use ImageJ's current min/max setting", "Compute min/max of the (hyper-)stack", "Use values specified below"};
            gd.addChoice("Value_range", minMaxChoices, minMaxChoices[lastMinMaxChoice]);
            final Choice cMinMaxChoices = (Choice)gd.getChoices().lastElement();
            gd.addNumericField("Min", lastMin, 0);
            final TextField tfMin = (TextField)gd.getNumericFields().lastElement();
            gd.addNumericField("Max", lastMax, 0);
            final TextField tfMax = (TextField)gd.getNumericFields().lastElement();
            gd.addMessage("");
            gd.addCheckbox("split_hdf5", lastSplit);
            final Checkbox cSplit = (Checkbox)gd.getCheckboxes().lastElement();
            gd.addNumericField("timepoints_per_partition", (double)lastTimepointsPerPartition, 0, 25, "");
            final TextField tfSplitTimepoints = (TextField)gd.getNumericFields().lastElement();
            gd.addNumericField("setups_per_partition", (double)lastSetupsPerPartition, 0, 25, "");
            final TextField tfSplitSetups = (TextField)gd.getNumericFields().lastElement();
            gd.addMessage("");
            gd.addCheckbox("use_deflate_compression", lastDeflate);
            gd.addMessage("");
            PluginHelper.addSaveAsFileField((GenericDialogPlus)gd, (String)"Export_path", (String)lastExportPath, (int)25);
            final String autoSubsampling = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getExportResolutions());
            final String autoChunkSizes = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getSubdivisions());
            gd.addDialogListener(new DialogListener(){

                public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                    gd.getNextBoolean();
                    gd.getNextString();
                    gd.getNextString();
                    gd.getNextChoiceIndex();
                    gd.getNextNumber();
                    gd.getNextNumber();
                    gd.getNextBoolean();
                    gd.getNextNumber();
                    gd.getNextNumber();
                    gd.getNextBoolean();
                    gd.getNextString();
                    if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cMinMaxChoices) {
                        boolean enable = cMinMaxChoices.getSelectedIndex() == 2;
                        tfMin.setEnabled(enable);
                        tfMax.setEnabled(enable);
                    } else if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cManualMipmap) {
                        boolean useManual = cManualMipmap.getState();
                        tfSubsampling.setEnabled(useManual);
                        tfChunkSizes.setEnabled(useManual);
                        if (!useManual) {
                            tfSubsampling.setText(autoSubsampling);
                            tfChunkSizes.setText(autoChunkSizes);
                        }
                    } else if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cSplit) {
                        boolean split = cSplit.getState();
                        tfSplitTimepoints.setEnabled(split);
                        tfSplitSetups.setEnabled(split);
                    }
                    return true;
                }
            });
            boolean enable = lastMinMaxChoice == 2;
            tfMin.setEnabled(enable);
            tfMax.setEnabled(enable);
            tfSubsampling.setEnabled(lastSetMipmapManual);
            tfChunkSizes.setEnabled(lastSetMipmapManual);
            if (!lastSetMipmapManual) {
                tfSubsampling.setText(autoSubsampling);
                tfChunkSizes.setText(autoChunkSizes);
            }
            tfSplitTimepoints.setEnabled(lastSplit);
            tfSplitSetups.setEnabled(lastSplit);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastSetMipmapManual = gd.getNextBoolean();
            lastSubsampling = gd.getNextString();
            lastChunkSizes = gd.getNextString();
            lastMinMaxChoice = gd.getNextChoiceIndex();
            lastMin = gd.getNextNumber();
            lastMax = gd.getNextNumber();
            lastSplit = gd.getNextBoolean();
            lastTimepointsPerPartition = (int)gd.getNextNumber();
            lastSetupsPerPartition = (int)gd.getNextNumber();
            lastDeflate = gd.getNextBoolean();
            lastExportPath = gd.getNextString();
            resolutions = PluginHelper.parseResolutionsString((String)lastSubsampling);
            subdivisions = PluginHelper.parseResolutionsString((String)lastChunkSizes);
            if (resolutions.length == 0) {
                IJ.showMessage((String)("Cannot parse subsampling factors " + lastSubsampling));
                continue;
            }
            if (subdivisions.length == 0) {
                IJ.showMessage((String)("Cannot parse hdf5 chunk sizes " + lastChunkSizes));
                continue;
            }
            if (resolutions.length != subdivisions.length) {
                IJ.showMessage((String)"subsampling factors and hdf5 chunk sizes must have the same number of elements");
                continue;
            }
            minMaxOption = lastMinMaxChoice == 0 ? ImagePlusImgLoader.MinMaxOption.TAKE_FROM_IMAGEPROCESSOR : (lastMinMaxChoice == 1 ? ImagePlusImgLoader.MinMaxOption.COMPUTE : ImagePlusImgLoader.MinMaxOption.SET);
            seqFilename = lastExportPath;
            if (!seqFilename.endsWith(".xml")) {
                seqFilename = seqFilename + ".xml";
            }
            if ((parent = (seqFile = new File(seqFilename)).getParentFile()) != null && parent.exists() && parent.isDirectory()) break;
            IJ.showMessage((String)("Invalid export filename " + seqFilename));
        }
        String hdf5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".h5";
        File hdf5File = new File(hdf5Filename);
        return new Parameters(lastSetMipmapManual, resolutions, subdivisions, seqFile, hdf5File, minMaxOption, lastMin, lastMax, lastDeflate, lastSplit, lastTimepointsPerPartition, lastSetupsPerPartition);
    }

    protected static class Parameters {
        final boolean setMipmapManual;
        final int[][] resolutions;
        final int[][] subdivisions;
        final File seqFile;
        final File hdf5File;
        final ImagePlusImgLoader.MinMaxOption minMaxOption;
        final double rangeMin;
        final double rangeMax;
        final boolean deflate;
        final boolean split;
        final int timepointsPerPartition;
        final int setupsPerPartition;

        public Parameters(boolean setMipmapManual, int[][] resolutions, int[][] subdivisions, File seqFile, File hdf5File, ImagePlusImgLoader.MinMaxOption minMaxOption, double rangeMin, double rangeMax, boolean deflate, boolean split, int timepointsPerPartition, int setupsPerPartition) {
            this.setMipmapManual = setMipmapManual;
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.seqFile = seqFile;
            this.hdf5File = hdf5File;
            this.minMaxOption = minMaxOption;
            this.rangeMin = rangeMin;
            this.rangeMax = rangeMax;
            this.deflate = deflate;
            this.split = split;
            this.timepointsPerPartition = timepointsPerPartition;
            this.setupsPerPartition = setupsPerPartition;
        }
    }
}

