/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ij.IJ;
import ij.ImagePlus;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import loci.common.services.ServiceFactory;
import loci.formats.ChannelSeparator;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.plugins.util.BFVirtualStack;
import ome.units.UNITS;
import ome.units.quantity.Length;

public class DevilParam {
    public final float default_maxBlur = 65535.0f;
    public final float default_min_final = -100.0f;
    public final float default_max_final = 10000.0f;
    String defaultPath;
    int objectSize = 25;
    boolean advancedParam;
    String minFinal_string;
    String maxFinal_string;
    String objectSize_string;
    String outputBitDepth_string;
    float[] minFinal;
    float[] maxFinal;
    float[] objectSize_array;
    File file;
    public String imageName;
    String fileDir_str;
    File output_dir;
    String output_dir_str;
    Map<String, Double> devilsMeasureLog;
    transient ChannelSeparator ch_separator;
    transient BFVirtualStack vStack;
    transient boolean littleEndian;
    int nSeries;
    public int nChannel;
    public int nSlice;
    public int nFrame;
    int perSeriesPlanesNbr;
    int totalPlanesNbr;
    public double[] voxelSize = new double[]{1.0, 1.0, 1.0};
    public List<Double[]> origins = new ArrayList<Double[]>();

    public DevilParam(String defaultPath, String outputDir, int objectSize, boolean advancedParam, String min_final_string, String max_final_string, String objectSize_string, String outputBitDepth_string) {
        this.defaultPath = defaultPath;
        this.output_dir_str = outputDir;
        this.objectSize = objectSize;
        this.advancedParam = advancedParam;
        this.minFinal_string = min_final_string;
        this.maxFinal_string = max_final_string;
        this.objectSize_string = objectSize_string;
        this.outputBitDepth_string = outputBitDepth_string;
        this.initFilesAndFolder();
        this.initImage();
    }

    public DevilParam(ImagePlus imp, int objectSize, boolean advancedParam, String min_final_string, String max_final_string, String objectSize_string, String outputBitDepth_string) {
        this.defaultPath = "";
        this.output_dir_str = "";
        this.objectSize = objectSize;
        this.advancedParam = advancedParam;
        this.minFinal_string = min_final_string;
        this.maxFinal_string = max_final_string;
        this.objectSize_string = objectSize_string;
        this.outputBitDepth_string = outputBitDepth_string;
        this.littleEndian = true;
        this.nSeries = 1;
        this.nChannel = imp.getNChannels();
        this.nSlice = imp.getNSlices();
        this.nFrame = imp.getNFrames();
        this.perSeriesPlanesNbr = this.nChannel * this.nSlice * this.nFrame;
        this.totalPlanesNbr = this.nSeries * this.nChannel * this.nSlice * this.nFrame;
        IJ.log((String)("nSeries " + String.valueOf(this.nSeries)));
        IJ.log((String)("nChannel " + String.valueOf(this.nChannel)));
        IJ.log((String)("nSlice " + String.valueOf(this.nSlice)));
        IJ.log((String)("nFrame " + String.valueOf(this.nFrame)));
        IJ.log((String)("totalPlanesNbr " + String.valueOf(this.totalPlanesNbr)));
        this.checkParamMinFinal();
        this.checkParamMaxFinal();
        this.checkParamObjectSize();
        this.voxelSize[0] = imp.getCalibration().pixelWidth;
        this.voxelSize[1] = imp.getCalibration().pixelHeight;
        this.voxelSize[2] = imp.getCalibration().pixelDepth;
    }

    public void initFilesAndFolder() {
        this.file = new File(this.defaultPath);
        this.imageName = this.file.getName();
        this.fileDir_str = this.file.getParent() + File.separator;
        if (this.output_dir_str.equals("")) {
            this.output_dir = new File(this.fileDir_str + "DEVILS");
            this.output_dir.mkdir();
        } else {
            this.output_dir = new File(this.output_dir_str + File.separator);
            this.output_dir.mkdir();
        }
        this.output_dir_str = this.output_dir.getAbsolutePath() + File.separator;
        IJ.log((String)this.output_dir_str);
    }

    public void initImage() {
        try {
            this.ch_separator = new ChannelSeparator();
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            OMEXMLMetadata meta = service.createOMEXMLMetadata();
            this.ch_separator.setMetadataStore((MetadataStore)meta);
            this.ch_separator.setFlattenedResolutions(false);
            this.ch_separator.setId(this.defaultPath);
            this.littleEndian = this.ch_separator.isLittleEndian();
            this.nSeries = this.ch_separator.getSeriesCount();
            this.nChannel = this.ch_separator.getSizeC();
            this.nSlice = this.ch_separator.getSizeZ();
            this.nFrame = this.ch_separator.getSizeT();
            this.perSeriesPlanesNbr = this.nChannel * this.nSlice * this.nFrame;
            this.totalPlanesNbr = this.nSeries * this.nChannel * this.nSlice * this.nFrame;
            IJ.log((String)("nSeries " + String.valueOf(this.nSeries)));
            IJ.log((String)("nChannel " + String.valueOf(this.nChannel)));
            IJ.log((String)("nSlice " + String.valueOf(this.nSlice)));
            IJ.log((String)("nFrame " + String.valueOf(this.nFrame)));
            IJ.log((String)("totalPlanesNbr " + String.valueOf(this.totalPlanesNbr)));
            this.checkParamMinFinal();
            this.checkParamMaxFinal();
            this.checkParamObjectSize();
            MetadataRetrieve retrieve = service.asRetrieve(this.ch_separator.getMetadataStore());
            String dimOrder = this.ch_separator.getDimensionOrder().toUpperCase();
            int posX = dimOrder.indexOf(88);
            Length calX = retrieve.getPixelsPhysicalSizeX(0);
            if (posX >= 0 && calX != null && calX.value().doubleValue() != 0.0) {
                this.voxelSize[0] = calX.value(UNITS.MICROMETER).doubleValue();
            }
            int posY = dimOrder.indexOf(89);
            Length calY = retrieve.getPixelsPhysicalSizeY(0);
            if (posY >= 0 && calY != null && calY.value().doubleValue() != 0.0) {
                this.voxelSize[1] = calY.value(UNITS.MICROMETER).doubleValue();
            }
            int posZ = dimOrder.indexOf(90);
            Length calZ = retrieve.getPixelsPhysicalSizeZ(0);
            if (posZ >= 0 && calZ != null && calZ.value().doubleValue() != 0.0) {
                this.voxelSize[2] = calZ.value(UNITS.MICROMETER).doubleValue();
            }
            this.origins = new ArrayList<Double[]>();
            for (int iSerie = 0; iSerie < this.nSeries; ++iSerie) {
                Length[] pos = DevilParam.getSeriesPositionAsLengths((IMetadata)this.ch_separator.getMetadataStore(), iSerie);
                Double[] originSerie = new Double[]{pos[0].value(UNITS.MICROMETER) != null ? Double.valueOf(pos[0].value(UNITS.MICROMETER).doubleValue()) : new Double(0.0), pos[1].value(UNITS.MICROMETER) != null ? Double.valueOf(pos[1].value(UNITS.MICROMETER).doubleValue()) : new Double(0.0), pos[2].value(UNITS.MICROMETER) != null ? Double.valueOf(pos[2].value(UNITS.MICROMETER).doubleValue()) : new Double(0.0)};
                this.origins.add(originSerie);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Length[] getSeriesPositionAsLengths(IMetadata omeMeta, int iSerie) {
        Length[] pos = new Length[3];
        try {
            pos[0] = omeMeta.getPlanePositionX(iSerie, 0) != null ? omeMeta.getPlanePositionX(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = omeMeta.getPlanePositionY(iSerie, 0) != null ? omeMeta.getPlanePositionY(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = omeMeta.getPlanePositionZ(iSerie, 0) != null ? omeMeta.getPlanePositionZ(iSerie, 0) : new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        catch (Exception e) {
            System.out.println("Could not access omeMeta.getPlanePosition");
            pos[0] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[1] = new Length((Number)0, UNITS.REFERENCEFRAME);
            pos[2] = new Length((Number)0, UNITS.REFERENCEFRAME);
        }
        System.out.println("Ch Name=" + omeMeta.getChannelName(iSerie, 0));
        System.out.println("pos[0]=" + pos[0].value() + " " + pos[0].unit().getSymbol());
        System.out.println("pos[1]=" + pos[1].value() + " " + pos[1].unit().getSymbol());
        System.out.println("pos[2]=" + pos[2].value() + " " + pos[2].unit().getSymbol());
        return pos;
    }

    public void setCurrentSeries(int iSeries) {
        this.ch_separator.setSeries(iSeries);
        IJ.log((String)("serieIndex " + iSeries));
        try {
            this.vStack = new BFVirtualStack(this.defaultPath, (IFormatReader)this.ch_separator, false, false, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOutputPath() {
        return this.output_dir_str + this.imageName;
    }

    public String getOutputDir() {
        return this.output_dir_str;
    }

    public String getOutputBitDepth() {
        return this.outputBitDepth_string;
    }

    public int getnSeries() {
        return this.nSeries;
    }

    public int getnChannel() {
        return this.nChannel;
    }

    public int getnSlice() {
        return this.nSlice;
    }

    public int getnFrame() {
        return this.nFrame;
    }

    public int getTotalPlanesNbr() {
        return this.totalPlanesNbr;
    }

    public void checkParamMinFinal() {
        this.minFinal = this.checkParam(this.minFinal_string, -100.0f);
    }

    private void checkParamObjectSize() {
        this.objectSize_array = this.checkParam(this.objectSize_string, this.objectSize);
    }

    public float getChannelObjectSize(int i) {
        return this.objectSize_array[i];
    }

    public float getChannelMinFinal(int i) {
        return this.minFinal[i];
    }

    public void checkParamMaxFinal() {
        this.maxFinal = this.checkParam(this.maxFinal_string, 10000.0f);
    }

    public float getChannelMaxFinal(int i) {
        return this.maxFinal[i];
    }

    public float[] checkParam(String param_to_check, float defaultValue) {
        boolean advancedMode = this.advancedParam;
        float[] param_checked = new float[this.nChannel];
        if (advancedMode) {
            float[] param_to_check_array = DevilParam.stringToArrayFloat(param_to_check, defaultValue);
            if (param_to_check_array.length == this.nChannel) {
                param_checked = param_to_check_array;
            } else if (param_to_check_array.length == 1) {
                IJ.log((String)("The value " + param_to_check_array[0] + " will be used for all channels "));
                Arrays.fill(param_checked, param_to_check_array[0]);
            } else {
                IJ.log((String)("Using default value " + defaultValue + " since the string parameter " + param_to_check + " do not matches the number of channels (" + this.nChannel + "). "));
                Arrays.fill(param_checked, defaultValue);
            }
        } else {
            Arrays.fill(param_checked, defaultValue);
            IJ.log((String)"DEVIL default mode");
        }
        return param_checked;
    }

    public static float[] stringToArrayFloat(String str, float defaultValue) {
        String[] str_array = str.split(",");
        float[] a_flot_array = new float[str_array.length];
        for (int ii = 0; ii < str_array.length; ++ii) {
            try {
                a_flot_array[ii] = Float.valueOf(str_array[ii].trim()).floatValue();
                continue;
            }
            catch (NumberFormatException nfe) {
                a_flot_array[ii] = defaultValue;
                IJ.log((String)("Ch" + (ii + 1) + " : not an appropriate number : " + str_array[ii] + "replaced by " + defaultValue));
            }
        }
        return a_flot_array;
    }

    public void logParam() {
        IJ.log((String)("Advanced parameters, defined by user :" + this.defaultPath));
        IJ.log((String)("Defined ObjectSize (pixel) :" + this.objectSize_string));
        IJ.log((String)"Advanced parameters, defined by user");
        IJ.log((String)("Channels, minimum value of final :" + this.minFinal_string));
        IJ.log((String)("Channels, maximum value of final :" + this.maxFinal_string));
        IJ.log((String)("Output bit_depth :" + this.outputBitDepth_string));
    }
}

