/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ch.epfl.biop.DevilParam;
import ij.IJ;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class DevilMeasure {
    int nSeries;
    int nChannel;
    int nSlice;
    int nFrame;
    int totalPlane;
    double[][][][] minFinal_da;
    double[][][][] maxFinal_da;

    public DevilMeasure(DevilParam dp) {
        this.nSeries = dp.getnSeries();
        this.nChannel = dp.getnChannel();
        this.nSlice = dp.getnSlice();
        this.nFrame = dp.getnFrame();
        this.totalPlane = this.nSeries * this.nChannel * this.nSlice * this.nFrame;
        this.minFinal_da = new double[this.nSlice][this.nChannel][this.nFrame][this.nSeries];
        this.maxFinal_da = new double[this.nSlice][this.nChannel][this.nFrame][this.nSeries];
    }

    public void setMinFinal(int[] position_ZCTS, double value) {
        this.minFinal_da[position_ZCTS[0]][position_ZCTS[1]][position_ZCTS[2]][position_ZCTS[3]] = value;
    }

    public double getMinFinalOfChannel(int channel) {
        double minValue = 18.0;
        for (int zi = 0; zi < this.nSlice; ++zi) {
            for (int ti = 0; ti < this.nFrame; ++ti) {
                for (int si = 0; si < this.nSeries; ++si) {
                    if (!(this.minFinal_da[zi][channel][ti][si] < minValue)) continue;
                    minValue = this.minFinal_da[zi][channel][ti][si];
                }
            }
        }
        return minValue;
    }

    public void setMaxFinal(int[] position_ZCTS, double value) {
        this.maxFinal_da[position_ZCTS[0]][position_ZCTS[1]][position_ZCTS[2]][position_ZCTS[3]] = value;
    }

    public double getMaxFinalOfChannel(int channel) {
        double maxValue = 0.0;
        for (int zi = 0; zi < this.nSlice; ++zi) {
            for (int ti = 0; ti < this.nFrame; ++ti) {
                for (int si = 0; si < this.nSeries; ++si) {
                    if (!(this.maxFinal_da[zi][channel][ti][si] > maxValue)) continue;
                    maxValue = this.maxFinal_da[zi][channel][ti][si];
                }
            }
        }
        return maxValue;
    }

    public void logMeasure() {
        String measureMessage = "--------------------------------------------------------\n";
        for (int i = 0; i < this.nChannel; ++i) {
            double minFinal_d = this.getMinFinalOfChannel(i);
            String minFinal_str = new Double(minFinal_d).toString();
            measureMessage = measureMessage + "Channel" + (i + 1) + " : minimum value of final :" + minFinal_str + "\n";
            double maxFinal_d = this.getMaxFinalOfChannel(i);
            String maxFinal_str = new Double(maxFinal_d).toString();
            measureMessage = measureMessage + "Channel" + (i + 1) + " : maximum value of final:" + maxFinal_str + "\n";
            measureMessage = measureMessage + "--------------------------------------------------------\n";
        }
        IJ.log((String)measureMessage);
    }

    public Map<String, Double> getLogMeasureAsMap() {
        HashMap<String, Double> minMaxRes = new HashMap<String, Double>();
        for (int i = 0; i < this.nChannel; ++i) {
            minMaxRes.put("channel_" + (i + 1) + "_min", this.getMinFinalOfChannel(i));
            minMaxRes.put("channel_" + (i + 1) + "_max", this.getMaxFinalOfChannel(i));
        }
        return minMaxRes;
    }

    public double[] reduceArray(double[] an_array, int start, int increment) {
        int sub_array_size = an_array.length / increment;
        double[] sub_array = new double[sub_array_size];
        for (int i = start; i < sub_array_size; ++i) {
            sub_array[i] = an_array[i + increment];
        }
        return sub_array;
    }

    public double[] sliceArray(double[] an_array, int start, int end) {
        int sliced_array_size = start - end + 1;
        double[] sliced_array = new double[sliced_array_size];
        for (int i = start; i < end; ++i) {
            sliced_array[i] = an_array[i];
        }
        return sliced_array;
    }

    public double getMinOf(double[] an_array) {
        double min = Arrays.stream(an_array).min().getAsDouble();
        return min;
    }

    public double getMaxOf(double[] an_array) {
        double max = Arrays.stream(an_array).max().getAsDouble();
        return max;
    }
}

