/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import ch.epfl.biop.DevilMeasure;
import ch.epfl.biop.DevilParam;
import com.google.gson.Gson;
import ij.ImagePlus;
import ij.io.FileSaver;
import ij.measure.Calibration;
import ij.plugin.filter.BackgroundSubtracter;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import loci.formats.FormatException;

public class DEVILS {
    public static int n_cpus = Runtime.getRuntime().availableProcessors();
    public static final String Devils_Parameter_Filename = "DevilsParameters.json";

    public static ImageProcessor DEVIL_ipr(DevilParam dp, DevilMeasure dm, int[] ZCTS_indexes, ImageProcessor ipr) {
        float maxBlur = dp.default_maxBlur;
        float min_final = dp.getChannelMinFinal(ZCTS_indexes[1]);
        float max_final = dp.getChannelMaxFinal(ZCTS_indexes[1]);
        float particle_size = dp.getChannelObjectSize(ZCTS_indexes[1]);
        float blur_size = 2.0f * particle_size;
        FloatProcessor ipr_ori_32 = ipr.convertToFloatProcessor();
        ImageProcessor ipr_blur_32 = ipr_ori_32.duplicate();
        ipr_blur_32.blurGaussian((double)blur_size);
        ipr_blur_32.multiply(1.0 / (double)maxBlur);
        ipr_ori_32.copyBits(ipr_blur_32, 0, 0, 6);
        ipr_ori_32.sqrt();
        BackgroundSubtracter bkgdSub = new BackgroundSubtracter();
        bkgdSub.rollingBallBackground((ImageProcessor)ipr_ori_32, (double)particle_size, false, false, false, true, false);
        double minFinal_measured = ipr_ori_32.getStats().min;
        dm.setMinFinal(ZCTS_indexes, minFinal_measured);
        double maxFinal_measured = ipr_ori_32.getStats().max;
        dm.setMaxFinal(ZCTS_indexes, maxFinal_measured);
        if (dp.getOutputBitDepth().equals("16-bit")) {
            ipr_ori_32.setMinAndMax((double)min_final, (double)max_final);
            ImageProcessor ipr_corr_16 = ipr_ori_32.convertToShort(true);
            return ipr_corr_16;
        }
        if (dp.getOutputBitDepth().equals("8-bit")) {
            ipr_ori_32.setMinAndMax((double)min_final, (double)max_final);
            ImageProcessor ipr_corr_8 = ipr_ori_32.convertToByte(true);
            return ipr_corr_8;
        }
        return ipr_ori_32;
    }

    public static void run(final DevilParam dp) throws IOException, FormatException {
        final DevilMeasure dm = new DevilMeasure(dp);
        for (int iSeries = 0; iSeries < dp.nSeries; ++iSeries) {
            dp.setCurrentSeries(iSeries);
            Thread[] threads = new Thread[n_cpus];
            final AtomicInteger ai = new AtomicInteger(0);
            for (int ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread] = new Thread(){
                    {
                        this.setPriority(5);
                    }

                    @Override
                    public void run() {
                        int i = ai.getAndIncrement();
                        while (i < dp.perSeriesPlanesNbr) {
                            if (i < dp.perSeriesPlanesNbr) {
                                int[] ZCT_indexes = dp.ch_separator.getZCTCoords(i);
                                int currentSerie = dp.ch_separator.getSeries();
                                int[] ZCTS_indexes = new int[]{ZCT_indexes[0], ZCT_indexes[1], ZCT_indexes[2], currentSerie};
                                int totalPlanesNbr = dp.getTotalPlanesNbr();
                                ImageProcessor currentPlane_ipr = dp.vStack.getProcessor(i + 1);
                                String currentPlaneIndexes_str = "-t" + ZCTS_indexes[2] + "-z" + ZCTS_indexes[0] + "-c" + ZCTS_indexes[1] + "-i" + i;
                                if (dp.getnSeries() > 1) {
                                    currentPlaneIndexes_str = "s" + ZCTS_indexes[3] + "-" + currentPlaneIndexes_str;
                                }
                                ImageProcessor processed_currentPlane_ipr = dp.advancedParam ? DEVILS.DEVIL_ipr(dp, dm, ZCTS_indexes, currentPlane_ipr) : DEVILS.DEVIL_ipr(dp, dm, ZCTS_indexes, currentPlane_ipr);
                                ImagePlus currentPlane_ipl_output = new ImagePlus(currentPlaneIndexes_str + "--processed", processed_currentPlane_ipr);
                                Calibration cal = new Calibration(currentPlane_ipl_output);
                                cal.setUnit("micron");
                                cal.pixelWidth = dp.voxelSize[0];
                                cal.pixelHeight = dp.voxelSize[1];
                                cal.pixelDepth = dp.voxelSize[2];
                                currentPlane_ipl_output.setCalibration(cal);
                                String ouput_filePath = dp.getOutputPath();
                                if (totalPlanesNbr > 1) {
                                    ouput_filePath = ouput_filePath + "_" + currentPlaneIndexes_str + ".tif";
                                }
                                FileSaver ipl_fileSaver = new FileSaver(currentPlane_ipl_output);
                                ipl_fileSaver.saveAsTiff(ouput_filePath);
                            }
                            i = ai.getAndIncrement();
                        }
                    }
                };
            }
            DEVILS.startAndJoin(threads);
        }
        dm.logMeasure();
        dp.devilsMeasureLog = dm.getLogMeasureAsMap();
        Gson gson = new Gson();
        String outputString = gson.toJson((Object)dp);
        BufferedWriter writer = new BufferedWriter(new FileWriter(dp.getOutputDir() + File.separator + Devils_Parameter_Filename));
        writer.write(outputString);
        writer.close();
    }

    public static void startAndJoin(Thread[] threads) {
        int ithread;
        for (ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread].setPriority(5);
            threads[ithread].start();
        }
        try {
            for (ithread = 0; ithread < threads.length; ++ithread) {
                threads[ithread].join();
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }
}

