/*
 * Decompiled with CFR 0.152.
 */
import ch.epfl.biop.DEVILS;
import ch.epfl.biop.DevilParam;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.plugin.FolderOpener;
import ij.plugin.HyperStackConverter;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import loci.formats.FormatException;
import loci.plugins.LociImporter;
import net.imagej.ImageJ;
import org.joda.time.DateTime;

public class DEVILS_
implements PlugIn {
    public void run(String arg0) {
        String defaultPath = Prefs.get((String)"ch.epfl.biop.devil.defaultPath", (String)Prefs.getImageJDir());
        int objectSize = Prefs.getInt((String)"ch.epfl.biop.devil.particle_size", (int)25);
        boolean advancedParam = Prefs.getBoolean((String)"ch.epfl.biop.devil.advancedParam", (boolean)false);
        boolean exportAsXmlHdf5 = Prefs.getBoolean((String)"ch.epfl.biop.devil.exportXmlHdf5", (boolean)false);
        GenericDialogPlus gd = new GenericDialogPlus("DEVILS parameters");
        gd.addFileField("Select_File", defaultPath);
        gd.addNumericField("Largest_object_size (in pixel)", (double)objectSize, 0);
        gd.addCheckbox("Export_XmlHdf5", exportAsXmlHdf5);
        gd.addCheckbox("Advanced_parameters", advancedParam);
        gd.showDialog();
        if (gd.wasCanceled()) {
            IJ.error((String)"canceled by user");
            return;
        }
        defaultPath = gd.getNextString();
        objectSize = (int)gd.getNextNumber();
        exportAsXmlHdf5 = gd.getNextBoolean();
        advancedParam = gd.getNextBoolean();
        Prefs.set((String)"ch.epfl.biop.devil.defaultPath", (String)defaultPath);
        Prefs.set((String)"ch.epfl.biop.devil.particle_size", (int)objectSize);
        Prefs.set((String)"ch.epfl.biop.devil.exportXmlHdf5", (boolean)advancedParam);
        Prefs.set((String)"ch.epfl.biop.devil.advancedParam", (boolean)advancedParam);
        String minFinal_string = "Default";
        String maxFinal_string = "Default";
        String objectSize_string = String.valueOf(objectSize);
        if (!advancedParam) {
            Prefs.set((String)"ch.epfl.biop.devil.objectSize", (String)objectSize_string);
        }
        String outputBitDepth_string = "16-bit";
        String outputDir_string = "";
        if (advancedParam) {
            minFinal_string = Prefs.get((String)"ch.epfl.biop.devil.min_final", (String)"-10, -10, ...");
            maxFinal_string = Prefs.get((String)"ch.epfl.biop.devil.max_final", (String)"1000, 1000, ...");
            objectSize_string = Prefs.get((String)"ch.epfl.biop.devil.objectSize", (String)"10, 10, ...");
            outputBitDepth_string = Prefs.get((String)"ch.epfl.biop.devil.outputBitDepth", (String)"16-bit");
            outputDir_string = Prefs.get((String)"ch.epfl.biop.devil.outputDir", (String)"");
            String[] outputBitDepthChoice = new String[]{"8-bit", "16-bit", "32-bit"};
            GenericDialogPlus gd_adParam = new GenericDialogPlus("DEVILS advanced parameters");
            gd_adParam.addMessage("You can specify an ouput directory.\n(Leave the field empty to create a DEVILS subfolder)");
            gd_adParam.addDirectoryField("Output_directory", outputDir_string);
            gd_adParam.addMessage("You can specify values for each channel, separated by ',' .\n (*) non numerical values will be replaced by default");
            gd_adParam.addStringField("Minimum (for final conversion step)", minFinal_string, 15);
            gd_adParam.addStringField("Maximum (for final conversion step)", maxFinal_string, 15);
            gd_adParam.addStringField("Object Size (in pixel)", objectSize_string, 15);
            gd_adParam.addMessage("----------------------------------------------------------------------------------------");
            gd_adParam.addChoice("Output_bit_depth", outputBitDepthChoice, outputBitDepth_string);
            gd_adParam.addMessage("*16-bit and 8-bit images will be lighter, but requires conversion\nand thus to specify Min. and Max. values for final conversion ");
            gd_adParam.addMessage("**32-bit images will be heavier, but not need for conversion\nneither to know Min. and Max. values for final conversion");
            gd_adParam.showDialog();
            if (gd_adParam.wasCanceled()) {
                IJ.error((String)"canceled by user");
                return;
            }
            outputDir_string = gd_adParam.getNextString();
            minFinal_string = gd_adParam.getNextString();
            maxFinal_string = gd_adParam.getNextString();
            objectSize_string = gd_adParam.getNextString();
            outputBitDepth_string = gd_adParam.getNextChoice();
            Prefs.set((String)"ch.epfl.biop.devil.outputDir", (String)outputDir_string);
            Prefs.set((String)"ch.epfl.biop.devil.min_final", (String)minFinal_string);
            Prefs.set((String)"ch.epfl.biop.devil.max_final", (String)maxFinal_string);
            Prefs.set((String)"ch.epfl.biop.devil.objectSize", (String)objectSize_string);
            Prefs.set((String)"ch.epfl.biop.devil.outputBitDepth", (String)outputBitDepth_string);
        }
        DevilParam dp = new DevilParam(defaultPath, outputDir_string, objectSize, advancedParam, minFinal_string, maxFinal_string, objectSize_string, outputBitDepth_string);
        dp.logParam();
        DateTime starter = DateTime.now();
        IJ.log((String)("Starts at : " + starter));
        long starter_ms = System.currentTimeMillis();
        try {
            DEVILS.run(dp);
        }
        catch (IOException | FormatException e) {
            e.printStackTrace();
        }
        DateTime ender = DateTime.now();
        IJ.log((String)("Ends at : " + ender));
        long ender_ms = System.currentTimeMillis();
        IJ.log((String)("DEVILS consumed : " + (ender_ms - starter_ms) / 1000L + "sec of your life"));
        if (exportAsXmlHdf5) {
            starter_ms = System.currentTimeMillis();
            IJ.log((String)"---------------------");
            IJ.log((String)"Exporting as Xml/Hdf5");
            for (int it = 0; it < dp.getnSeries(); ++it) {
                String file_name_filter = dp.imageName;
                if (dp.getnSeries() > 1) {
                    file_name_filter = file_name_filter + "_s" + it + "-";
                }
                ImagePlus impV = FolderOpener.open((String)dp.getOutputDir(), (String)("virtual file=[" + file_name_filter + "]"));
                ImagePlus reordered_impV = HyperStackConverter.toHyperStack((ImagePlus)impV, (int)dp.nChannel, (int)dp.nSlice, (int)dp.nFrame, (String)"Composite");
                reordered_impV.getCalibration().pixelWidth = dp.voxelSize[0];
                reordered_impV.getCalibration().pixelHeight = dp.voxelSize[1];
                reordered_impV.getCalibration().pixelDepth = dp.voxelSize[2];
                if (dp.origins != null && dp.origins.size() > it) {
                    reordered_impV.getCalibration().xOrigin = (int)(dp.origins.get(it)[0] / dp.voxelSize[0]);
                    reordered_impV.getCalibration().yOrigin = (int)(dp.origins.get(it)[1] / dp.voxelSize[1]);
                    reordered_impV.getCalibration().zOrigin = (int)(dp.origins.get(it)[2] / dp.voxelSize[2]);
                }
                reordered_impV.setTitle(file_name_filter);
                reordered_impV.show();
                boolean folderExists = new File(dp.getOutputDir() + File.separator + "XmlHdf5").exists();
                if (!folderExists) {
                    folderExists = new File(dp.getOutputDir() + File.separator + "XmlHdf5").mkdir();
                }
                if (folderExists) {
                    IJ.run((String)"Export Current Image as XML/HDF5 (Devils)", (String)(" value_range=[Use values specified below] min=0 max=65535 timepoints_per_partition=0 setups_per_partition=0 use_deflate_compression export_path=[" + dp.getOutputDir() + File.separator + "XmlHdf5" + File.separator + file_name_filter + ".xml]"));
                    reordered_impV.close();
                    continue;
                }
                System.err.println("Err : Could not create folder " + dp.getOutputDir() + File.separator + "XmlHdf5");
            }
            ender_ms = System.currentTimeMillis();
            IJ.log((String)"---------------------");
            IJ.log((String)("XmlHdf5 export took : " + (ender_ms - starter_ms) / 1000L + " sec of your life"));
        }
    }

    public static void main(String[] args) {
        Class<DEVILS_> clazz = DEVILS_.class;
        String url = clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class").toString();
        String pluginsDir = url.substring("file:".length(), url.length() - clazz.getName().length() - ".class".length());
        System.setProperty("plugins.dir", pluginsDir);
        ImageJ ij = new ImageJ();
        ij.ui().showUI();
        new LociImporter().run("");
    }
}

