/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.patcher;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtNewConstructor;
import net.imagej.patcher.LegacyInjector;
import net.imagej.patcher.Utils;

public class JavaAgent
implements ClassFileTransformer {
    private static Instrumentation instrumentation;
    private static JavaAgent agent;
    private static Transformer transformer;
    private static List<RuntimeException> exceptions;
    private static final ClassLoader bootstrapClassLoader;

    public static void stop() {
        if (instrumentation != null && agent != null) {
            instrumentation.removeTransformer(agent);
            agent = null;
        }
        transformer = null;
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        JavaAgent.instrumentation = instrumentation;
        if ("help".equals(agentArgs)) {
            JavaAgent.usage();
            return;
        }
        if ("init".equals(agentArgs) || "preinit".equals(agentArgs) || "pre-init".equals(agentArgs)) {
            JavaAgent.preinit();
            return;
        }
        if ("noop".equals(agentArgs)) {
            return;
        }
        if ("debug".equals(agentArgs)) {
            transformer = new Transformer();
        } else if (agentArgs != null && !"report".equals(agentArgs)) {
            System.err.println("Unhandled agent option: " + agentArgs);
            JavaAgent.usage();
            return;
        }
        agent = new JavaAgent();
        instrumentation.addTransformer(agent);
        System.err.println("Legacy Java agent initialized");
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        if (className.startsWith("ij.") || className.startsWith("ij/") || className.matches("net.imagej.patcher.EssentialLegacyHooks")) {
            return JavaAgent.reportCaller("Loading " + className + " into " + loader + "!", classfileBuffer);
        }
        return null;
    }

    private static void usage() {
        System.err.println("ImageJ Legacy Agent Usage:\n\nThe ij1-patcher agent's purpose is to help with issues arising from ImageJ 1.x\nclasses being used before the ImageJ2 legacy service's pre-initialization stage\nhad a chance to run.\n\nPre-initialization of the ImageJ2 legacy service is necessary in order to add\nthe extension points to ImageJ 1.x' classes that are required for the ImageJ2\nlegacy service to synchronize between the internal states of the legacy and\nmodern mode, respectively.\n\nUse the agent via the JVM option -javaagent=/path/to/ij1-patcher.jar[=<OPTION>].\nThe following optional options are available:\n\nhelp\n\tshow this description\ninit\n\tforce pre-initialization of the ImageJ legacy service\ndebug (this is the default)\n\tthrow exceptions where ImageJ 1.x classes are used prematurely\nreport\n\treport whenever ImageJ 1.x classes are used prematurely\n");
    }

    private static void preinit() {
        LegacyInjector.preinit();
    }

    public static void dontCall(int i) {
        throw exceptions.get(i);
    }

    private static byte[] reportCaller(String message, byte[] classfileBuffer) throws IllegalClassFormatException {
        ImageJ1ClassLoadedPrematurely exception = new ImageJ1ClassLoadedPrematurely(message);
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        if (trace != null) {
            int i;
            for (i = 0; i < trace.length && JavaAgent.isCoreClass(trace[i].getClassName()); ++i) {
            }
            StackTraceElement[] stackTrace = new StackTraceElement[trace.length - i];
            int j = 0;
            while (i < trace.length) {
                stackTrace[j] = trace[i];
                ++j;
                ++i;
            }
            exception.setStackTrace(stackTrace);
        }
        if (transformer != null) {
            return transformer.transform(classfileBuffer, exception);
        }
        exception.printStackTrace();
        return null;
    }

    private static boolean isCoreClass(String className) {
        if (JavaAgent.class.getName().equals(className)) {
            return true;
        }
        try {
            bootstrapClassLoader.loadClass(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static void main(String ... args) throws IOException {
        File file;
        boolean overwrite = false;
        int i = 0;
        if ("-f".equals(args[i]) || "--force".equals(args[i])) {
            overwrite = true;
            ++i;
        }
        if (args == null || args.length <= i) {
            file = File.createTempFile("ij1-patcher-javaagent-", ".jar");
        } else {
            file = new File(args[i]);
            if (!overwrite && file.exists()) {
                System.err.println("File exists: " + file);
                System.exit(1);
            }
        }
        String classUrl = Utils.getLocation(JavaAgent.class).toExternalForm();
        int slash = classUrl.lastIndexOf(47);
        URL directory = new URL(classUrl.substring(0, slash + 1));
        Collection<URL> urls = Utils.listContents(directory);
        String infix = JavaAgent.class.getName().replace('.', '/');
        byte[] buffer = new byte[65536];
        Manifest manifest = new Manifest();
        Attributes mainAttrs = manifest.getMainAttributes();
        mainAttrs.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttrs.putValue("Premain-Class", JavaAgent.class.getName());
        JarOutputStream jar = new JarOutputStream((OutputStream)new FileOutputStream(file), manifest);
        for (URL url2 : urls) {
            int count;
            String path = url2.getPath();
            int offset = path.indexOf(infix);
            if (offset < 0) continue;
            jar.putNextEntry(new JarEntry(path.substring(offset)));
            InputStream in = url2.openStream();
            while ((count = in.read(buffer)) >= 0) {
                jar.write(buffer, 0, count);
            }
            in.close();
            jar.closeEntry();
        }
        jar.close();
        System.err.println("Wrote " + file);
    }

    static {
        exceptions = new ArrayList<RuntimeException>();
        bootstrapClassLoader = ClassLoader.getSystemClassLoader().getParent();
    }

    private static class Transformer {
        private final ClassPool pool = ClassPool.getDefault();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] transform(byte[] classfileBuffer, RuntimeException exception) {
            int number;
            List list = exceptions;
            synchronized (list) {
                number = exceptions.size();
                exceptions.add(exception);
            }
            String src = JavaAgent.class.getName() + ".dontCall(" + number + ");";
            try {
                CtClass clazz = this.pool.makeClass(new ByteArrayInputStream(classfileBuffer), false);
                CtConstructor method = clazz.getClassInitializer();
                if (method != null) {
                    method.insertBefore(src);
                } else {
                    method = CtNewConstructor.make(new CtClass[0], new CtClass[0], src, clazz);
                    method.getMethodInfo().setName("<clinit>");
                    method.setModifiers(8);
                    clazz.addConstructor(method);
                }
                return clazz.toBytecode();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
            catch (CannotCompileException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class ImageJ1ClassLoadedPrematurely
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public ImageJ1ClassLoadedPrematurely(String message) {
            super(message);
        }
    }
}

