/*
 * Decompiled with CFR 0.152.
 */
package fsalign;

import fsalign.ImageListener;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.utils.Filter;
import java.io.File;
import java.util.ArrayList;
import mpicbg.trakem2.align.AlignLayersTask;

public class FSAlignListener
extends ImageListener {
    public static final String SMTP_KEY = "fsalign.FSAlignListener.smtp";
    public static final String EMAIL_KEY = "fsalign.FSAlignListener.email";
    public static final String PASS_KEY = "fsalign.FSAlignListener.password";
    public static final String PORT_KEY = "fsalign.FSAlignListener.port";
    public static final String TOMAIL_KEY = "fsalign.FSAlignListener.notifymail";
    private final Project trakemProject;
    private final ArrayList<String> existingImageFiles;
    protected final Filter<Patch> patchFilter;
    private final double thickness;
    private double nextZ;
    private String path;
    private String notifyEmail;

    public FSAlignListener() {
        this(Display.getFront().getProject(), 1.0, true);
    }

    public FSAlignListener(Project project, double t, boolean append) {
        this(project, t, append ? project.getRootLayerSet().getDepth() + t : 0.0);
    }

    public FSAlignListener(Project project, double t, double z0) {
        this.trakemProject = project;
        this.thickness = t;
        this.patchFilter = new PatchSieve();
        this.notifyEmail = "";
        this.existingImageFiles = new ArrayList();
        this.nextZ = z0;
        this.initImageFileList();
        this.setEnabled(true);
    }

    @Override
    protected void processImage(File imageFile) {
        if (this.isEnabled() && this.trakemProject != null && this.okToAdd(imageFile)) {
            Patch patch = new Patch(this.trakemProject, imageFile.getName(), 0.0, 0.0, this.getImageFromPath(imageFile.getAbsolutePath()));
            LayerSet layerSet = this.trakemProject.getRootLayerSet();
            Layer layer = layerSet.getLayer(this.nextZ, this.thickness, true);
            this.trakemProject.getLoader().addedPatchFrom(imageFile.getAbsolutePath(), patch);
            layer.add(patch);
            this.dropImage(imageFile);
            try {
                patch.updateMipMaps().get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (layerSet.size() > 1) {
                AlignLayersTask.alignLayersLinearlyJob(layerSet, layerSet.size() - 2, layerSet.size() - 1, false, null, this.patchFilter);
                this.imageDigest(patch);
                this.imageCheck(patch);
            } else {
                this.imageDigest(patch);
            }
            this.trakemProject.save();
            this.nextZ += this.thickness;
        }
    }

    private void initImageFileList() {
        for (Layer l : this.trakemProject.getRootLayerSet().getLayers()) {
            for (Displayable d : l.getDisplayables()) {
                try {
                    Patch p = (Patch)d;
                    this.existingImageFiles.add(new File(p.getImageFilePath()).getName());
                }
                catch (ClassCastException classCastException) {}
            }
        }
    }

    protected boolean okToAdd(File imageFile) {
        if (this.existingImageFiles.contains(imageFile.getName())) {
            return false;
        }
        this.existingImageFiles.add(imageFile.getName());
        return true;
    }

    public void setNotifyEmail(String notify) {
        this.notifyEmail = notify;
    }

    protected void imageDigest(Patch p) {
    }

    protected void imageCheck(Patch p) {
    }

    protected void digest(String message) {
    }

    protected void immediate(String message) {
    }

    private static class PatchSieve
    implements Filter<Patch> {
        private PatchSieve() {
        }

        @Override
        public boolean accept(Patch patch) {
            return true;
        }
    }
}

