/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.cache.SharedQueue;
import bdv.util.AbstractSource;
import bdv.util.volatiles.VolatileViews;
import bdv.viewer.Source;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.volatiles.CacheHints;
import net.imglib2.cache.volatiles.LoadingStrategy;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;

public class VolatileSource<T extends NumericType<T>, V extends Volatile<T>>
extends AbstractSource<V> {
    private final Source<T> source;
    private SharedQueue queue;

    public VolatileSource(Source<T> source, V type, SharedQueue queue) {
        super((NumericType)type, source.getName());
        this.source = source;
        this.queue = queue;
    }

    public VolatileSource(Source<T> source, Supplier<V> typeSupplier, SharedQueue queue) {
        this(source, (Volatile)typeSupplier.get(), queue);
    }

    public RandomAccessibleInterval<V> getSource(int t, int level) {
        return VolatileViews.wrapAsVolatile(this.source.getSource(t, level), this.queue, new CacheHints(LoadingStrategy.VOLATILE, level, true));
    }

    public synchronized void getSourceTransform(int t, int level, AffineTransform3D transform) {
        this.source.getSourceTransform(t, level, transform);
    }

    @Override
    public VoxelDimensions getVoxelDimensions() {
        return this.source.getVoxelDimensions();
    }

    @Override
    public int getNumMipmapLevels() {
        return this.source.getNumMipmapLevels();
    }
}

