/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.tools.brightness.ConverterSetup;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.TimePointListener;
import bdv.viewer.TransformListener;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import org.scijava.listeners.Listeners;

public final class PlaceHolderOverlayInfo
implements TransformListener<AffineTransform3D>,
TimePointListener,
ViewerStateChangeListener {
    private final ViewerPanel viewer;
    private final SourceAndConverter<?> source;
    private final ConverterSetup converterSetup;
    private final AffineTransform3D viewerTransform;
    private int timePointIndex;
    private boolean wasVisible;
    private final Listeners.List<VisibilityChangeListener> listeners;

    public PlaceHolderOverlayInfo(ViewerPanel viewer, SourceAndConverter<?> source, ConverterSetup converterSetup) {
        this.viewer = viewer;
        this.source = source;
        this.converterSetup = converterSetup;
        this.viewerTransform = new AffineTransform3D();
        this.listeners = new Listeners.SynchronizedList();
        viewer.addRenderTransformListener((TransformListener)this);
        viewer.addTimePointListener((TimePointListener)this);
        viewer.state().changeListeners().add((Object)this);
    }

    SourceAndConverter<?> getSource() {
        return this.source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformChanged(AffineTransform3D t) {
        AffineTransform3D affineTransform3D = this.viewerTransform;
        synchronized (affineTransform3D) {
            this.viewerTransform.set(t);
        }
    }

    public boolean isVisible() {
        return this.viewer.state().isSourceVisible(this.source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getViewerTransform(AffineTransform3D t) {
        AffineTransform3D affineTransform3D = this.viewerTransform;
        synchronized (affineTransform3D) {
            t.set(this.viewerTransform);
        }
    }

    public int getTimePointIndex() {
        return this.timePointIndex;
    }

    public double getDisplayRangeMin() {
        return this.converterSetup.getDisplayRangeMin();
    }

    public double getDisplayRangeMax() {
        return this.converterSetup.getDisplayRangeMax();
    }

    public ARGBType getColor() {
        return this.converterSetup.getColor();
    }

    public void timePointChanged(int timePointIndex) {
        this.timePointIndex = timePointIndex;
    }

    public void viewerStateChanged(ViewerStateChange change) {
        boolean isVisible;
        if (change == ViewerStateChange.VISIBILITY_CHANGED && this.wasVisible != (isVisible = this.isVisible())) {
            this.wasVisible = isVisible;
            this.listeners.list.forEach(VisibilityChangeListener::visibilityChanged);
        }
    }

    public Listeners<VisibilityChangeListener> visibilityChangeListeners() {
        return this.listeners;
    }

    @Deprecated
    public boolean addVisibilityChangeListener(VisibilityChangeListener listener) {
        return this.listeners.add((Object)listener);
    }

    @Deprecated
    public boolean removeVisibilityChangeListener(VisibilityChangeListener listener) {
        return this.listeners.remove((Object)listener);
    }

    public static interface VisibilityChangeListener {
        public void visibilityChanged();
    }
}

