/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.PlaceHolderOverlayInfo;
import bdv.viewer.OverlayRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.realtransform.AffineTransform3D;

public abstract class BdvOverlay
implements OverlayRenderer {
    protected final AffineTransform3D sourceTransform = new AffineTransform3D();
    private final AffineTransform3D tmp = new AffineTransform3D();
    protected PlaceHolderOverlayInfo info = null;

    public void setOverlayInfo(PlaceHolderOverlayInfo info) {
        this.info = info;
    }

    public void setSourceTransform(AffineTransform3D t) {
        this.sourceTransform.set(t);
    }

    public void drawOverlays(Graphics g) {
        if (this.info == null || !this.info.isVisible()) {
            return;
        }
        this.draw((Graphics2D)g);
    }

    protected void getCurrentTransform2D(AffineTransform2D transform) {
        this.info.getViewerTransform(this.tmp);
        this.tmp.concatenate(this.sourceTransform);
        transform.set(new double[]{this.tmp.get(0, 0), this.tmp.get(0, 1), this.tmp.get(0, 3), this.tmp.get(1, 0), this.tmp.get(1, 1), this.tmp.get(1, 3)});
    }

    protected void getCurrentTransform3D(AffineTransform3D transform) {
        this.info.getViewerTransform(transform);
        transform.concatenate(this.sourceTransform);
    }

    protected abstract void draw(Graphics2D var1);

    public void setCanvasSize(int width, int height) {
    }
}

