/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.BigDataViewer;
import bdv.BigDataViewerActions;
import bdv.TransformEventHandler;
import bdv.cache.CacheControl;
import bdv.tools.VisibilityAndGroupingDialog;
import bdv.tools.bookmarks.Bookmarks;
import bdv.tools.bookmarks.BookmarksEditor;
import bdv.tools.brightness.BrightnessDialog;
import bdv.tools.brightness.ConverterSetup;
import bdv.tools.brightness.SetupAssignments;
import bdv.tools.transformation.ManualTransformationEditor;
import bdv.ui.BdvDefaultCards;
import bdv.ui.CardPanel;
import bdv.ui.UIUtils;
import bdv.ui.appearance.AppearanceManager;
import bdv.ui.keymap.KeymapManager;
import bdv.ui.splitpanel.SplitPanel;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.DisplayMode;
import bdv.viewer.NavigationActions;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.scijava.ui.behaviour.InputTriggerAdder;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.MouseAndKeyHandler;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.Behaviours;
import org.scijava.ui.behaviour.util.InputActionBindings;
import org.scijava.ui.behaviour.util.TriggerBehaviourBindings;

public class BdvHandlePanel
extends BdvHandle {
    private final BrightnessDialog brightnessDialog;
    private final VisibilityAndGroupingDialog activeSourcesDialog;
    private final ManualTransformationEditor manualTransformationEditor;
    private final Bookmarks bookmarks;
    private final BookmarksEditor bookmarksEditor;
    private final InputActionBindings keybindings;
    private final TriggerBehaviourBindings triggerbindings;
    private final KeymapManager keymapManager;
    private final AppearanceManager appearanceManager;

    public BdvHandlePanel(Frame dialogOwner, BdvOptions options) {
        super(options);
        UIUtils.installFlatLafInfos();
        KeymapManager optionsKeymapManager = options.values.getKeymapManager();
        AppearanceManager optionsAppearanceManager = options.values.getAppearanceManager();
        this.keymapManager = optionsKeymapManager != null ? optionsKeymapManager : new KeymapManager(BigDataViewer.configDir);
        this.appearanceManager = optionsAppearanceManager != null ? optionsAppearanceManager : new AppearanceManager(BigDataViewer.configDir);
        this.cacheControls = new CacheControl.CacheControls();
        this.viewer = new ViewerPanel(new ArrayList(), 1, (CacheControl)this.cacheControls, options.values.getViewerOptions());
        if (!options.values.hasPreferredSize()) {
            this.viewer.getDisplay().setPreferredSize(null);
        }
        this.viewer.getDisplay().addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BdvHandlePanel.this.tryInitTransform();
            }
        });
        this.setupAssignments = new SetupAssignments(new ArrayList(), 0.0, 65535.0);
        this.setups = new ConverterSetups((ViewerState)this.viewer.state());
        this.setups.listeners().add(s -> this.viewer.requestRepaint());
        this.cards = new CardPanel();
        BdvDefaultCards.setup((CardPanel)this.cards, (AbstractViewerPanel)this.viewer, (ConverterSetups)this.setups);
        this.splitPanel = new SplitPanel((AbstractViewerPanel)this.viewer, this.cards);
        this.keybindings = new InputActionBindings();
        SwingUtilities.replaceUIActionMap((JComponent)this.viewer, this.keybindings.getConcatenatedActionMap());
        SwingUtilities.replaceUIInputMap((JComponent)this.viewer, 1, this.keybindings.getConcatenatedInputMap());
        this.triggerbindings = new TriggerBehaviourBindings();
        MouseAndKeyHandler mouseAndKeyHandler = new MouseAndKeyHandler();
        mouseAndKeyHandler.setInputMap(this.triggerbindings.getConcatenatedInputTriggerMap());
        mouseAndKeyHandler.setBehaviourMap(this.triggerbindings.getConcatenatedBehaviourMap());
        this.viewer.getDisplay().addHandler((Object)mouseAndKeyHandler);
        InputTriggerConfig inputTriggerConfig = this.viewer.getInputTriggerConfig();
        Behaviours transformBehaviours = new Behaviours((InputTriggerAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        transformBehaviours.install(this.triggerbindings, "transform");
        TransformEventHandler tfHandler = this.viewer.getTransformEventHandler();
        tfHandler.install(transformBehaviours);
        this.manualTransformationEditor = new ManualTransformationEditor((AbstractViewerPanel)this.viewer, this.keybindings);
        this.bookmarks = new Bookmarks();
        this.bookmarksEditor = new BookmarksEditor((AbstractViewerPanel)this.viewer, this.keybindings, this.bookmarks);
        this.brightnessDialog = new BrightnessDialog(dialogOwner, this.setupAssignments);
        this.activeSourcesDialog = new VisibilityAndGroupingDialog(dialogOwner, (ViewerState)this.viewer.state());
        this.appearanceManager.appearance().updateListeners().add(() -> SwingUtilities.getWindowAncestor((Component)this.viewer).repaint());
        SwingUtilities.invokeLater(() -> this.appearanceManager.updateLookAndFeel());
        Actions navigationActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv", "navigation"});
        navigationActions.install(this.keybindings, "navigation");
        NavigationActions.install((Actions)navigationActions, (AbstractViewerPanel)this.viewer, (boolean)options.values.is2D());
        Actions bdvActions = new Actions((KeyStrokeAdder.Factory)inputTriggerConfig, new String[]{"bdv"});
        bdvActions.install(this.keybindings, "bdv");
        BigDataViewerActions.dialog((Actions)bdvActions, (BrightnessDialog)this.brightnessDialog);
        BigDataViewerActions.dialog((Actions)bdvActions, (VisibilityAndGroupingDialog)this.activeSourcesDialog);
        BigDataViewerActions.bookmarks((Actions)bdvActions, (BookmarksEditor)this.bookmarksEditor);
        BigDataViewerActions.manualTransform((Actions)bdvActions, (ManualTransformationEditor)this.manualTransformationEditor);
        bdvActions.runnableAction(this::expandAndFocusCardPanel, "expand and focus cards panel", BigDataViewerActions.EXPAND_CARDS_KEYS);
        bdvActions.runnableAction(this::collapseCardPanel, "collapse cards panel", BigDataViewerActions.COLLAPSE_CARDS_KEYS);
        this.viewer.setDisplayMode(DisplayMode.FUSED);
    }

    @Override
    public ManualTransformationEditor getManualTransformEditor() {
        return this.manualTransformationEditor;
    }

    @Override
    public KeymapManager getKeymapManager() {
        return this.keymapManager;
    }

    @Override
    public AppearanceManager getAppearanceManager() {
        return this.appearanceManager;
    }

    @Override
    public InputActionBindings getKeybindings() {
        return this.keybindings;
    }

    @Override
    public TriggerBehaviourBindings getTriggerbindings() {
        return this.triggerbindings;
    }

    @Override
    boolean createViewer(List<? extends ConverterSetup> converterSetups, List<? extends SourceAndConverter<?>> sources, int numTimepoints) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        this.brightnessDialog.dispose();
        this.activeSourcesDialog.dispose();
        super.close();
    }

    public void expandAndFocusCardPanel() {
        this.splitPanel.setCollapsed(false);
        this.splitPanel.getRightComponent().requestFocusInWindow();
    }

    public void collapseCardPanel() {
        this.splitPanel.setCollapsed(true);
        this.viewer.requestFocusInWindow();
    }
}

