/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.DefaultInterpolators;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.DefaultVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.view.Views;

public abstract class AbstractSource<T extends NumericType<T>>
implements Source<T> {
    protected final T type;
    protected final String name;
    protected final VoxelDimensions voxelDimensions;
    protected final DefaultInterpolators<T> interpolators;
    private final boolean doBoundingBoxCulling;

    public AbstractSource(T type, String name, VoxelDimensions voxelDimensions, boolean doBoundingBoxCulling) {
        this.type = (NumericType)AbstractSource.tryCreateVariable(type);
        this.name = name;
        this.voxelDimensions = voxelDimensions;
        this.interpolators = new DefaultInterpolators();
        this.doBoundingBoxCulling = doBoundingBoxCulling;
    }

    public AbstractSource(T type, String name, VoxelDimensions voxelDimensions) {
        this(type, name, voxelDimensions, true);
    }

    public AbstractSource(T type, String name) {
        this(type, name, (VoxelDimensions)new DefaultVoxelDimensions(-1), true);
    }

    public AbstractSource(T type, String name, boolean doBoundingBoxCulling) {
        this(type, name, (VoxelDimensions)new DefaultVoxelDimensions(-1), doBoundingBoxCulling);
    }

    public AbstractSource(Supplier<T> typeSupplier, String name) {
        this((NumericType)typeSupplier.get(), name);
    }

    public boolean isPresent(int t) {
        return true;
    }

    public T getType() {
        return this.type;
    }

    public RealRandomAccessible<T> getInterpolatedSource(int t, int level, Interpolation method) {
        return Views.interpolate((EuclideanSpace)Views.extendZero((RandomAccessibleInterval)this.getSource(t, level)), this.interpolators.get(method));
    }

    public String getName() {
        return this.name;
    }

    public VoxelDimensions getVoxelDimensions() {
        return this.voxelDimensions;
    }

    public int getNumMipmapLevels() {
        return 1;
    }

    public boolean doBoundingBoxCulling() {
        return this.doBoundingBoxCulling;
    }

    static <T> T tryCreateVariable(T t) {
        if (t instanceof Type) {
            Type type = (Type)t;
            Type copy = type.createVariable();
            return (T)copy;
        }
        return t;
    }
}

