/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.launcher;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class RemoteUpdater {
    public static final String BOOTSTRAP_REMOTE_URL = "http://update.imagej.net/bootstrap.js";
    public static final String JS_REMOTE_URL = "http://update.imagej.net/js-1.7R2.jar";

    public static boolean runRemote(Throwable cause) {
        RemoteUpdater updater = new RemoteUpdater();
        try {
            if (!updater.runAsJavascript(cause)) {
                RemoteUpdater.runViaRemoteJavascript(cause);
            }
            return true;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    private boolean runAsJavascript(Throwable cause) throws IOException, ScriptException {
        System.err.println("Falling back to remote updater at http://update.imagej.net/bootstrap.js");
        URL url = new URL(BOOTSTRAP_REMOTE_URL);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        ScriptEngine engine = scriptEngineManager.getEngineByName("ECMAScript");
        if (engine == null) {
            return false;
        }
        if (cause != null) {
            engine.put("cause", cause);
        }
        engine.eval("importPackage(Packages.java.lang);");
        engine.eval(reader);
        return true;
    }

    private static void runViaRemoteJavascript(Throwable cause) throws ClassNotFoundException, IOException, SecurityException, IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        System.err.println("Falling back to remote updater at http://update.imagej.net/bootstrap.js via http://update.imagej.net/js-1.7R2.jar");
        URL jsURL = new URL(JS_REMOTE_URL);
        URLClassLoader loader = new URLClassLoader(new URL[]{jsURL});
        Object context = RemoteUpdater.invokeStatic(loader, "org.mozilla.javascript.Context", "enter", new Object[0]);
        Object scope = RemoteUpdater.construct(loader, "org.mozilla.javascript.ImporterTopLevel", context);
        if (cause != null) {
            Object causeObject = RemoteUpdater.invokeStatic(loader, "org.mozilla.javascript.Context", "toObject", cause, scope);
            RemoteUpdater.invoke(scope, "put", "cause", scope, causeObject);
        }
        URL url = new URL(BOOTSTRAP_REMOTE_URL);
        InputStreamReader reader = new InputStreamReader(url.openStream());
        RemoteUpdater.invoke(context, "evaluateReader", scope, reader, "bootstrap.js", 1, null);
    }

    private static <T> T construct(ClassLoader loader, String className, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Class<?> clazz = loader.loadClass(className);
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!RemoteUpdater.doParametersMatch(constructor.getParameterTypes(), parameters)) continue;
            return (T)constructor.newInstance(parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    private static <T> T invokeStatic(ClassLoader loader, String className, String methodName, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = loader.loadClass(className);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !RemoteUpdater.doParametersMatch(method.getParameterTypes(), parameters)) continue;
            return (T)method.invoke(null, parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    private static <T> T invoke(Object object, String methodName, Object ... parameters) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = object.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !RemoteUpdater.doParametersMatch(method.getParameterTypes(), parameters)) continue;
            return (T)method.invoke(object, parameters);
        }
        throw new NoSuchMethodException("No matching method found");
    }

    private static boolean doParametersMatch(Class<?>[] types, Object[] parameters) {
        if (types.length != parameters.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (parameters[i] == null) continue;
            Class<?> clazz = parameters[i].getClass();
            if (types[i].isPrimitive()) {
                if (types[i] != Long.TYPE && types[i] != Integer.TYPE && types[i] != Boolean.TYPE) {
                    throw new RuntimeException("unsupported primitive type " + clazz);
                }
                if (types[i] == Long.TYPE && clazz != Long.class) {
                    return false;
                }
                if (types[i] == Integer.TYPE && clazz != Integer.class) {
                    return false;
                }
                if (types[i] != Boolean.TYPE || clazz == Boolean.class) continue;
                return false;
            }
            if (types[i].isAssignableFrom(clazz)) continue;
            return false;
        }
        return true;
    }
}

