/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier.alpha;

import java.util.Arrays;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.alpha.AlphaBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.alpha.AlphaSerializableBdvOptions;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>BDV>BDV - Set BDV window (alpha)", description="Set preferences of Bdv Window (Alpha)")
public class BdvSetAlphaViewerSettingsCommand
implements BdvPlaygroundActionCommand {
    @Parameter(label="Click this checkbox to ignore all parameters and reset the default alpha viewer", persist=false)
    boolean resetToDefault = false;
    @Parameter
    int width = 640;
    @Parameter
    int height = 480;
    @Parameter
    String screenscales = "1, 0.5, 0.25, 0.125";
    @Parameter
    long targetrenderms = 30L;
    @Parameter
    int numrenderingthreads = 3;
    @Parameter
    int numsourcegroups = 10;
    @Parameter
    String frametitle = "BigDataViewer";
    @Parameter
    boolean is2d = false;
    @Parameter
    boolean interpolate = false;
    @Parameter
    boolean white_background = false;
    @Parameter
    int numtimepoints = 1;
    @Parameter
    boolean usealphalayer = true;
    @Parameter
    Context ctx;
    @Parameter
    SourceAndConverterBdvDisplayService sacDisplayService;

    public void run() {
        if (this.resetToDefault) {
            AlphaBdvSupplier bdvSupplier = new AlphaBdvSupplier(new AlphaSerializableBdvOptions());
            this.sacDisplayService.setDefaultBdvSupplier((IBdvSupplier)bdvSupplier);
        } else {
            AlphaSerializableBdvOptions options = new AlphaSerializableBdvOptions();
            options.frameTitle = this.frametitle;
            options.is2D = this.is2d;
            options.numRenderingThreads = this.numrenderingthreads;
            options.screenScales = Arrays.stream(this.screenscales.split(",")).mapToDouble(Double::parseDouble).toArray();
            options.height = this.height;
            options.width = this.width;
            options.numSourceGroups = this.numsourcegroups;
            options.numTimePoints = this.numtimepoints;
            options.interpolate = this.interpolate;
            options.useAlphaCompositing = this.usealphalayer;
            options.white_bg = this.white_background;
            AlphaBdvSupplier bdvSupplier = new AlphaBdvSupplier(options);
            this.sacDisplayService.setDefaultBdvSupplier((IBdvSupplier)bdvSupplier);
        }
    }
}

