/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.bdvpg.bdv.supplier.alpha;

import bdv.ui.CardPanel;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.util.BdvOptions;
import bdv.util.BdvStackSource;
import bdv.util.PlaceHolderSource;
import bdv.util.projector.alpha.ILayerAlphaProjectorFactory;
import bdv.util.projector.alpha.Layer;
import bdv.util.projector.alpha.LayerAlphaIProjectorFactory;
import bdv.util.projector.alpha.LayerAlphaProjectorFactory;
import bdv.util.projector.alpha.LayerMetadata;
import bdv.util.projector.alpha.SourcesMetadata;
import bdv.util.source.alpha.AlphaSourceHelper;
import bdv.util.source.alpha.IAlphaSource;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import bdv.viewer.SynchronizedViewerState;
import bdv.viewer.ViewerPanel;
import bdv.viewer.ViewerState;
import bdv.viewer.ViewerStateChange;
import bdv.viewer.ViewerStateChangeListener;
import bdv.viewer.render.AccumulateProjectorARGB;
import bdv.viewer.render.AccumulateProjectorFactory;
import ch.epfl.biop.bdv.select.SourceSelectorBehaviour;
import java.awt.Font;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.real.FloatType;
import org.jetbrains.annotations.NotNull;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.RayCastPositionerSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.SourceNavigatorSliderAdder;
import sc.fiji.bdvpg.bdv.navigate.TimepointAdapterAdder;
import sc.fiji.bdvpg.bdv.overlay.SourceNameOverlayAdder;
import sc.fiji.bdvpg.bdv.supplier.BdvSupplierHelper;
import sc.fiji.bdvpg.bdv.supplier.IBdvSupplier;
import sc.fiji.bdvpg.bdv.supplier.alpha.AlphaSerializableBdvOptions;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class AlphaBdvSupplier
implements IBdvSupplier {
    public final AlphaSerializableBdvOptions sOptions;
    public static final SourcesMetadata sourcesMetadata = new SourcesMetadata(){

        @Override
        public boolean isAlphaSource(SourceAndConverter<?> sac) {
            return sac.getSpimSource() instanceof IAlphaSource;
        }

        @Override
        public boolean hasAlphaSource(SourceAndConverter<?> sac) {
            return SourceAndConverterServices.getSourceAndConverterService().containsMetadata(sac, "ALPHA_SOURCE");
        }

        @Override
        public SourceAndConverter<FloatType> getAlphaSource(SourceAndConverter<?> sac) {
            return (SourceAndConverter)SourceAndConverterServices.getSourceAndConverterService().getMetadata(sac, "ALPHA_SOURCE");
        }
    };

    public AlphaBdvSupplier(AlphaSerializableBdvOptions sOptions) {
        this.sOptions = sOptions;
    }

    public BdvHandle get() {
        AccumulateProjectorFactory projectorFactory = AccumulateProjectorARGB.factory;
        if (this.sOptions.useAlphaCompositing) {
            if (this.sOptions.white_bg) {
                projectorFactory = new LayerAlphaIProjectorFactory();
                ((ILayerAlphaProjectorFactory)projectorFactory).setSourcesMeta(sourcesMetadata);
            } else {
                projectorFactory = new LayerAlphaProjectorFactory();
                ((ILayerAlphaProjectorFactory)projectorFactory).setSourcesMeta(sourcesMetadata);
            }
        }
        BdvOptions options = this.sOptions.getBdvOptions();
        ArrayImg dummyImg = ArrayImgs.bytes((long[])new long[]{2L, 2L, 2L});
        options = options.sourceTransform(new AffineTransform3D());
        options.accumulateProjectorFactory(projectorFactory);
        BdvStackSource bss = BdvFunctions.show((RandomAccessibleInterval)dummyImg, (String)"dummy", (BdvOptions)options);
        BdvHandle bdvh = bss.getBdvHandle();
        if (this.sOptions.interpolate) {
            bdvh.getViewerPanel().setInterpolation(Interpolation.NLINEAR);
        }
        bdvh.getViewerPanel().state().removeSource(bdvh.getViewerPanel().state().getCurrentSource());
        bdvh.getViewerPanel().setNumTimepoints(this.sOptions.numTimePoints);
        if (this.sOptions.useAlphaCompositing) {
            bdvh.getViewerPanel().state().changeListeners().add((Object)new AlphaSourcesSynchronizer(bdvh));
            ((ILayerAlphaProjectorFactory)projectorFactory).setLayerMeta(new GroupLayerMetadata(bdvh.getViewerPanel(), bdvh.getCardPanel()));
        }
        BdvSupplierHelper.addSourcesDragAndDrop((BdvHandle)bdvh);
        SourceSelectorBehaviour ssb = BdvSupplierHelper.addEditorMode((BdvHandle)bdvh, (String)"");
        bdvh.getSplitPanel().setCollapsed(false);
        JPanel editorModeToggle = new JPanel();
        JButton editorToggle = new JButton("Editor Mode");
        editorToggle.addActionListener(e -> {
            if (ssb.isEnabled()) {
                ssb.disable();
                editorToggle.setText("Editor Mode 'E'");
            } else {
                ssb.enable();
                editorToggle.setText("Navigation Mode 'E'");
            }
        });
        editorModeToggle.add(editorToggle);
        JButton nameToggle = new JButton("Display sources name");
        AtomicBoolean nameOverlayEnabled = new AtomicBoolean();
        nameOverlayEnabled.set(true);
        SourceNameOverlayAdder nameOverlayAdder = new SourceNameOverlayAdder(bdvh, new Font(this.sOptions.font, 0, this.sOptions.fontSize));
        nameToggle.addActionListener(e -> {
            if (nameOverlayEnabled.get()) {
                nameOverlayEnabled.set(false);
                nameToggle.setText("Display sources names");
                nameOverlayAdder.removeFromBdv();
            } else {
                nameOverlayEnabled.set(true);
                nameToggle.setText("Hide sources name");
                nameOverlayAdder.addToBdv();
            }
        });
        editorModeToggle.add(nameToggle);
        SwingUtilities.invokeLater(() -> {
            nameOverlayAdder.run();
            BdvHandleHelper.addCenterCross((BdvHandle)bdvh);
            new RayCastPositionerSliderAdder(bdvh).run();
            new SourceNavigatorSliderAdder(bdvh).run();
            new TimepointAdapterAdder(bdvh).run();
        });
        BdvHandleHelper.addCard((BdvHandle)bdvh, (String)"Mode", (JComponent)editorModeToggle, (boolean)true);
        return bdvh;
    }

    public static class AlphaSourcesSynchronizer
    implements ViewerStateChangeListener {
        final BdvHandle bdvh;

        public AlphaSourcesSynchronizer(BdvHandle bdvh) {
            this.bdvh = bdvh;
        }

        public void viewerStateChanged(ViewerStateChange change) {
            switch (change) {
                case NUM_SOURCES_CHANGED: {
                    this.syncAlphaSourcesPresent();
                    break;
                }
                case VISIBILITY_CHANGED: {
                    this.syncAlphaSourcesVisibility();
                }
            }
        }

        private void syncAlphaSourcesVisibility() {
            SynchronizedViewerState state = this.bdvh.getViewerPanel().state();
            Set alphaSourcesToActivate = state.getActiveSources().stream().filter(sac -> !sourcesMetadata.isAlphaSource((SourceAndConverter<?>)sac)).filter(sourcesMetadata::hasAlphaSource).map(sourcesMetadata::getAlphaSource).collect(Collectors.toSet());
            state.setSourcesActive(alphaSourcesToActivate, true);
            Set alphaSourcesToDeActivate = state.getSources().stream().filter(sac -> !sourcesMetadata.isAlphaSource((SourceAndConverter<?>)sac)).filter(arg_0 -> AlphaSourcesSynchronizer.lambda$syncAlphaSourcesVisibility$2((ViewerState)state, arg_0)).filter(sourcesMetadata::hasAlphaSource).map(sourcesMetadata::getAlphaSource).collect(Collectors.toSet());
            state.setSourcesActive(alphaSourcesToDeActivate, false);
        }

        private void syncAlphaSourcesPresent() {
            List currentSources = this.bdvh.getViewerPanel().state().getSources();
            HashSet<SourceAndConverter<FloatType>> alphaSourcesToAdd = new HashSet<SourceAndConverter<FloatType>>();
            HashSet<SourceAndConverter<FloatType>> usefulAlphaSources = new HashSet<SourceAndConverter<FloatType>>();
            Set currentAlphaSources = currentSources.stream().filter(sourcesMetadata::isAlphaSource).collect(Collectors.toSet());
            for (SourceAndConverter sac2 : currentSources) {
                SourceAndConverter<FloatType> alpha;
                if (sourcesMetadata.isAlphaSource(sac2)) continue;
                if (sourcesMetadata.hasAlphaSource(sac2)) {
                    alpha = sourcesMetadata.getAlphaSource(sac2);
                    if (!currentSources.contains(alpha)) {
                        alphaSourcesToAdd.add(alpha);
                        continue;
                    }
                    usefulAlphaSources.add(alpha);
                    continue;
                }
                if (sac2.getSpimSource() instanceof PlaceHolderSource) continue;
                System.out.println("Building alpha source for source " + sac2.getSpimSource().getName() + " of class " + sac2.getSpimSource().getClass().getSimpleName());
                alpha = AlphaSourceHelper.getOrBuildAlphaSource(sac2);
                alphaSourcesToAdd.add(alpha);
            }
            Set alphaSourcesToRemove = currentAlphaSources.stream().filter(sac -> !usefulAlphaSources.contains(sac)).collect(Collectors.toSet());
            this.bdvh.getViewerPanel().state().removeSources(alphaSourcesToRemove);
            this.bdvh.getViewerPanel().state().addSources(alphaSourcesToAdd);
        }

        private static /* synthetic */ boolean lambda$syncAlphaSourcesVisibility$2(ViewerState state, SourceAndConverter sac) {
            return !state.isSourceVisible(sac);
        }
    }

    public static class SourceGroupLayer
    implements Layer {
        final ViewerPanel viewer;
        final SourceGroup group;
        float alpha = 1.0f;
        final JLabel label;
        final JPanel sliderPanel;
        final int id;
        String name;
        boolean active = true;

        public SourceGroupLayer(ViewerPanel viewer, SourceGroup group, int id, String name) {
            this.name = name;
            this.viewer = viewer;
            this.id = id;
            this.group = group;
            JSlider slider = new JSlider(0, 0, 255, 255);
            slider.addChangeListener(e -> this.setAlpha((float)((double)slider.getValue() / 255.0)));
            this.label = new JLabel(name);
            this.sliderPanel = new JPanel();
            this.sliderPanel.add(this.label);
            this.sliderPanel.add(slider);
        }

        public SourceGroup getGroup() {
            return this.group;
        }

        public JComponent getSlider() {
            return this.sliderPanel;
        }

        @Override
        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float alpha) {
            if (alpha != this.alpha) {
                this.alpha = alpha;
                this.viewer.requestRepaint();
            }
        }

        public void nameChanged() {
            this.label.setText(this.viewer.state().getGroupName(this.group));
        }

        @Override
        public int getBlendingMode() {
            return 0;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        @Override
        public boolean skip() {
            return !this.active;
        }

        @Override
        public int compareTo(@NotNull Layer o) {
            return Integer.compare(this.id, ((SourceGroupLayer)o).id);
        }
    }

    public static class GroupLayerMetadata
    implements LayerMetadata,
    ViewerStateChangeListener {
        final ViewerPanel viewer;
        final Map<SourceAndConverter<?>, SourceGroup> sourceToGroup = new ConcurrentHashMap();
        final Map<SourceGroup, SourceGroupLayer> groupToLayer = new ConcurrentHashMap<SourceGroup, SourceGroupLayer>();
        final JPanel sliders;
        final JLabel[] sliderLabels;
        final SourceGroupLayer defaultLayer;

        public GroupLayerMetadata(ViewerPanel viewer, CardPanel panel) {
            this.viewer = viewer;
            this.defaultLayer = new SourceGroupLayer(viewer, new SourceGroup(), -1, "Default");
            this.sliders = new JPanel();
            this.sliders.setLayout(new BoxLayout(this.sliders, 1));
            this.sliderLabels = new JLabel[viewer.state().getGroups().size() + 1];
            this.sliders.add(this.defaultLayer.getSlider());
            this.buildLayers();
            this.buildMap();
            viewer.state().changeListeners().add((Object)this);
            SwingUtilities.invokeLater(() -> panel.addCard("Group Opacity", (JComponent)this.sliders, true));
        }

        public void buildLayers() {
            List groups = this.viewer.state().getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                SourceGroup group = (SourceGroup)groups.get(i);
                if (this.groupToLayer.containsKey(group)) continue;
                SourceGroupLayer sgl = new SourceGroupLayer(this.viewer, group, i, this.viewer.state().getGroupName(group));
                this.groupToLayer.put(group, sgl);
                this.sliders.add(sgl.getSlider());
            }
        }

        public void buildMap() {
            this.sourceToGroup.clear();
            this.viewer.state().getGroups().forEach(group -> this.viewer.state().getSourcesInGroup(group).forEach(sac -> this.sourceToGroup.put((SourceAndConverter<?>)sac, (SourceGroup)group)));
        }

        @Override
        public Layer getLayer(SourceAndConverter<?> sac) {
            if (this.sourceToGroup.containsKey(sac)) {
                return this.groupToLayer.get(this.sourceToGroup.get(sac));
            }
            return this.defaultLayer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void viewerStateChanged(ViewerStateChange change) {
            switch (change) {
                case CURRENT_GROUP_CHANGED: {
                    break;
                }
                case GROUP_ACTIVITY_CHANGED: {
                    SynchronizedViewerState synchronizedViewerState = this.viewer.state();
                    synchronized (synchronizedViewerState) {
                        this.groupToLayer.values().forEach(sgl -> sgl.setActive(this.viewer.state().isGroupActive(sgl.getGroup())));
                    }
                    this.viewer.requestRepaint();
                    break;
                }
                case GROUP_NAME_CHANGED: {
                    SynchronizedViewerState synchronizedViewerState = this.viewer.state();
                    synchronized (synchronizedViewerState) {
                        this.groupToLayer.values().forEach(SourceGroupLayer::nameChanged);
                        break;
                    }
                }
                case SOURCE_TO_GROUP_ASSIGNMENT_CHANGED: {
                    this.buildMap();
                    this.viewer.requestRepaint();
                    break;
                }
                case NUM_GROUPS_CHANGED: {
                    System.err.println("Changing the number of groups / layers is not supported!");
                }
            }
        }
    }
}

