/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.wizard;

import ij.IJ;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.command.CommandInfo;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;

public class Wizard {
    final Map<Integer, CommandInfo> steps;
    final Map<Vertex, Vertex> edges;
    final Context ctx;

    public static WizardBuilder builder(Context ctx) {
        return new WizardBuilder(ctx);
    }

    public Wizard(Context ctx, Map<Integer, CommandInfo> steps, Map<Vertex, Vertex> pipes) {
        this.steps = steps;
        this.edges = pipes;
        this.ctx = ctx;
    }

    public void run() {
        CommandService cs = (CommandService)this.ctx.getService(CommandService.class);
        boolean wizardDone = false;
        boolean wizardSuccess = false;
        int indexStep = 0;
        HashMap<Vertex, Object> storedOutputs = new HashMap<Vertex, Object>();
        while (!wizardDone) {
            CommandInfo commandType = this.steps.get(indexStep);
            try {
                HashMap kvArgs = new HashMap();
                int iStep = indexStep;
                List inputs = this.edges.keySet().stream().filter(e -> e.wizardStep == iStep).collect(Collectors.toList());
                for (Vertex input : inputs) {
                    if (!this.edges.containsKey(input)) {
                        IJ.log((String)("Input " + input + " not found!"));
                    }
                    if (!storedOutputs.containsKey(this.edges.get(input))) {
                        IJ.log((String)("Corresponding output to input " + input + " not found!"));
                    }
                    kvArgs.put(input.parameterName, storedOutputs.get(this.edges.get(input)));
                }
                Future futureModule = cs.run(commandType.getPluginClass(), true, kvArgs);
                CommandModule cm = (CommandModule)futureModule.get();
                List outputs = this.edges.values().stream().filter(e -> e.wizardStep == iStep).collect(Collectors.toList());
                for (Vertex output : outputs) {
                    storedOutputs.put(output, cm.getOutput(output.parameterName));
                }
                if (++indexStep != this.steps.size()) continue;
                wizardDone = true;
                wizardSuccess = true;
            }
            catch (Exception e2) {
                IJ.error((String)"There was a problem with the current step, would like to retry ?");
                e2.printStackTrace();
                wizardDone = true;
                wizardSuccess = false;
            }
        }
    }

    public static class Vertex {
        final int wizardStep;
        final String parameterName;

        public Vertex(Integer iStep, String parameterName) {
            this.parameterName = parameterName;
            this.wizardStep = iStep;
        }

        public String toString() {
            return "[Wizard step:" + this.wizardStep + "; '" + this.parameterName + "']";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Vertex)) {
                return false;
            }
            Vertex other = (Vertex)o;
            return this.wizardStep == other.wizardStep && this.parameterName.equals(other.parameterName);
        }

        public final int hashCode() {
            int result = 17;
            if (this.parameterName != null) {
                result = 31 * result + this.parameterName.hashCode() + this.wizardStep;
            }
            return result;
        }
    }

    public static class WizardBuilder {
        Map<Integer, CommandInfo> steps = new HashMap<Integer, CommandInfo>();
        int stepCounter = 0;
        Map<Vertex, Vertex> edges = new HashMap<Vertex, Vertex>();
        final Context ctx;

        public WizardBuilder(Context ctx) {
            this.ctx = ctx;
        }

        public WizardBuilder nextCommand(CommandInfo commandType) {
            this.steps.put(this.stepCounter, commandType);
            ++this.stepCounter;
            return this;
        }

        public WizardBuilder nextCommand(Class<? extends Command> commandType) {
            CommandInfo ci = ((CommandService)this.ctx.getService(CommandService.class)).getCommand(commandType);
            System.out.println(ci);
            this.steps.put(this.stepCounter, ci);
            ++this.stepCounter;
            return this;
        }

        public WizardBuilder connect(Integer stepOut, String parameterNameOut, Integer stepIn, String parameterNameIn) {
            Vertex eout = new Vertex(stepOut, parameterNameOut);
            Vertex ein = new Vertex(stepIn, parameterNameIn);
            this.edges.put(ein, eout);
            return this;
        }

        public Wizard build() {
            return new Wizard(this.ctx, this.steps, this.edges);
        }
    }
}

