/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.spimdata.reordered;

import ch.epfl.biop.spimdata.reordered.ISetupOrder;
import ch.epfl.biop.spimdata.reordered.LifReOrdered;
import ch.epfl.biop.spimdata.reordered.ReorderedImageLoader;
import com.google.gson.Gson;
import java.io.File;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import org.jdom2.Content;
import org.jdom2.Element;

@ImgLoaderIo(format="spimreconstruction.biop_reorderedimageloader", type=ReorderedImageLoader.class)
public class XmlIoReorderedImgLoader
implements XmlIoBasicImgLoader<ReorderedImageLoader> {
    public static final String CACHE_NUM_FETCHER = "num_fetcher_threads";
    public static final String CACHE_NUM_PRIORITIES = "num_priorities";
    public static final String ORDER_CLASS = "order_class";
    public static final String ORDER_TAG = "order";

    public Element toXml(ReorderedImageLoader imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.intElement((String)CACHE_NUM_FETCHER, (int)imgLoader.numFetcherThreads));
        elem.addContent((Content)XmlHelpers.intElement((String)CACHE_NUM_PRIORITIES, (int)imgLoader.numPriorities));
        Gson gson = new Gson();
        System.out.println(imgLoader.getOrder().getClass().getSimpleName());
        elem.addContent((Content)XmlHelpers.textElement((String)ORDER_CLASS, (String)gson.toJson((Object)imgLoader.getOrder().getClass().getSimpleName())));
        elem.addContent((Content)XmlHelpers.textElement((String)ORDER_TAG, (String)gson.toJson((Object)imgLoader.getOrder())));
        return elem;
    }

    public ReorderedImageLoader fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            int numFetcherThreads = XmlHelpers.getInt((Element)elem, (String)CACHE_NUM_FETCHER);
            int numPriorities = XmlHelpers.getInt((Element)elem, (String)CACHE_NUM_PRIORITIES);
            String orderClassName = XmlHelpers.getText((Element)elem, (String)ORDER_CLASS);
            Gson gson = new Gson();
            String orderString = XmlHelpers.getText((Element)elem, (String)ORDER_TAG);
            ISetupOrder order = (ISetupOrder)gson.fromJson(orderString, LifReOrdered.class);
            order.initialize();
            return new ReorderedImageLoader(order, sequenceDescription, numFetcherThreads, numPriorities);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

