/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.spimdata.reordered;

import bdv.AbstractViewerSetupImgLoader;
import ch.epfl.biop.spimdata.reordered.ReorderedImageLoader;
import java.util.function.Function;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.AbstractIntegerType;
import net.imglib2.type.numeric.real.FloatType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderedSetupLoader<T extends NumericType<T>, V extends Volatile<T>>
extends AbstractViewerSetupImgLoader<T, V>
implements MultiResolutionSetupImgLoader<T> {
    protected static Logger logger = LoggerFactory.getLogger(ReorderedSetupLoader.class);
    Function<RandomAccessibleInterval<T>, RandomAccessibleInterval<FloatType>> cvtRaiToFloatRai;
    final Converter<T, FloatType> cvt;
    final int setupId;
    final ReorderedImageLoader imgLoader;

    public ReorderedSetupLoader(ReorderedImageLoader imgLoader, int setupId, T t, V v) {
        super(t, v);
        this.setupId = setupId;
        this.imgLoader = imgLoader;
        if (t instanceof FloatType) {
            this.cvt = null;
            this.cvtRaiToFloatRai = rai -> rai;
        } else if (t instanceof ARGBType) {
            this.cvt = (input, output) -> {
                int val = ((ARGBType)input).get();
                int r = ARGBType.red((int)val);
                int g = ARGBType.green((int)val);
                int b = ARGBType.blue((int)val);
                output.set((float)(r + g + b));
            };
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else if (t instanceof AbstractIntegerType) {
            this.cvt = (input, output) -> output.set(((AbstractIntegerType)input).getRealFloat());
            this.cvtRaiToFloatRai = rai -> Converters.convert((RandomAccessibleInterval)rai, this.cvt, (Type)new FloatType());
        } else {
            this.cvt = null;
            this.cvtRaiToFloatRai = e -> {
                logger.error("Conversion of " + t.getClass() + " to FloatType unsupported.");
                return null;
            };
        }
    }

    public RandomAccessibleInterval<V> getVolatileImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.imgLoader.getVolatileImage(this.setupId, timepointId, level, hints);
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, int level, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, level, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId, int level) {
        return this.imgLoader.getImageSize(this.setupId, timepointId, level);
    }

    public RandomAccessibleInterval<T> getImage(int timepointId, int level, ImgLoaderHint ... hints) {
        return this.imgLoader.getImage(this.setupId, timepointId, level, hints);
    }

    public double[][] getMipmapResolutions() {
        return this.imgLoader.getMipmapResolutions(this.setupId);
    }

    public AffineTransform3D[] getMipmapTransforms() {
        return this.imgLoader.getMipmapTransforms(this.setupId);
    }

    public int numMipmapLevels() {
        return this.imgLoader.numMipmapLevels(this.setupId);
    }

    public RandomAccessibleInterval<FloatType> getFloatImage(int timepointId, boolean normalize, ImgLoaderHint ... hints) {
        return this.cvtRaiToFloatRai.apply(this.getImage(timepointId, 0, new ImgLoaderHint[0]));
    }

    public Dimensions getImageSize(int timepointId) {
        return this.imgLoader.getImageSize(this.setupId, timepointId);
    }

    public VoxelDimensions getVoxelSize(int timepointId) {
        return this.imgLoader.getVoxelSize(this.setupId, timepointId);
    }
}

