/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.spimdata.reordered;

import bdv.AbstractViewerSetupImgLoader;
import bdv.ViewerImgLoader;
import bdv.ViewerSetupImgLoader;
import bdv.cache.CacheControl;
import bdv.cache.SharedQueue;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.spimdata.reordered.ISetupOrder;
import ch.epfl.biop.spimdata.reordered.ReorderedSetupLoader;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicSetupImgLoader;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import mpicbg.spim.data.sequence.MultiResolutionSetupImgLoader;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Volatile;
import net.imglib2.cache.queue.BlockingFetchQueues;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.NumericType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReorderedImageLoader<T extends AbstractViewerSetupImgLoader>
implements ViewerImgLoader,
MultiResolutionImgLoader {
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    protected static Logger logger = LoggerFactory.getLogger(ReorderedImageLoader.class);
    Map<Integer, ReorderedSetupLoader> imgLoaders = new ConcurrentHashMap<Integer, ReorderedSetupLoader>();
    Map<Integer, T> originImgLoaders = new ConcurrentHashMap<Integer, T>();
    Map<AbstractSpimData, MultiResolutionImgLoader> spimdataImageLoaders = new ConcurrentHashMap<AbstractSpimData, MultiResolutionImgLoader>();
    protected VolatileGlobalCellCache cache;
    protected SharedQueue sq;
    public final int numFetcherThreads;
    public final int numPriorities;
    final ISetupOrder order;

    public ReorderedImageLoader(ISetupOrder shuffler, AbstractSequenceDescription<?, ?, ?> sequenceDescription, int numFetcherThreads, int numPriorities) {
        this.sequenceDescription = sequenceDescription;
        this.numFetcherThreads = numFetcherThreads;
        this.numPriorities = numPriorities;
        this.sq = new SharedQueue(numFetcherThreads, numPriorities);
        this.order = shuffler;
        this.cache = new VolatileGlobalCellCache((BlockingFetchQueues)this.sq);
    }

    public ISetupOrder getOrder() {
        return this.order;
    }

    public ReorderedSetupLoader getSetupImgLoader(int setupId) {
        if (this.imgLoaders.containsKey(setupId)) {
            return this.imgLoaders.get(setupId);
        }
        logger.debug("loading setupId = " + setupId);
        ViewId currentViewId = new ViewId(0, setupId);
        SpimDataViewId svi = this.order.getOriginalLocation(currentViewId);
        AbstractSpimData originSpimData = svi.asd;
        ViewId originViewId = svi.viewId;
        MultiResolutionImgLoader originImageLoader = this.getOrFetchImageLoader(originSpimData);
        BasicSetupImgLoader setupImgLoader = originImageLoader.getSetupImgLoader(originViewId.getViewSetupId());
        if (!(setupImgLoader instanceof AbstractViewerSetupImgLoader)) {
            logger.error("Origin setup loader is not of instance AbstractViewerSetupImgLoader, reordering is not supported");
            throw new UnsupportedOperationException("Unsupported setup loader class " + setupImgLoader.getClass());
        }
        if (!(setupImgLoader instanceof MultiResolutionSetupImgLoader)) {
            logger.error("Origin setup loader is not of instance MultiResolutionSetupImgLoader, reordering is not supported");
            throw new UnsupportedOperationException("Unsupported setup loader class " + setupImgLoader.getClass());
        }
        AbstractViewerSetupImgLoader originSetupLoader = (AbstractViewerSetupImgLoader)setupImgLoader;
        this.originImgLoaders.put(setupId, originSetupLoader);
        ReorderedSetupLoader<NumericType, Volatile> setupLoader = new ReorderedSetupLoader<NumericType, Volatile>(this, setupId, (NumericType)originSetupLoader.getImageType(), originSetupLoader.getVolatileImageType());
        this.imgLoaders.put(setupId, setupLoader);
        return setupLoader;
    }

    public CacheControl getCacheControl() {
        return this.cache;
    }

    public SharedQueue getQueue() {
        return this.sq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReorderedImageLoader reorderedImageLoader = this;
        synchronized (reorderedImageLoader) {
            this.cache.clearCache();
            this.sq.shutdown();
        }
    }

    public RandomAccessibleInterval getVolatileImage(int setupId, int timepointId, int level, ImgLoaderHint ... hints) {
        SpimDataViewId svi = this.order.getOriginalLocation(new ViewId(timepointId, setupId));
        AbstractSpimData asd = svi.asd;
        int setupIdRedirect = svi.viewId.getViewSetupId();
        int timepointRedirect = svi.viewId.getTimePointId();
        return ((ViewerSetupImgLoader)this.getOrFetchImageLoader(asd).getSetupImgLoader(setupIdRedirect)).getVolatileImage(timepointRedirect, level, hints);
    }

    public Dimensions getImageSize(int setupId, int timepointId, int level) {
        SpimDataViewId svi = this.order.getOriginalLocation(new ViewId(timepointId, setupId));
        AbstractSpimData asd = svi.asd;
        int setupIdRedirect = svi.viewId.getViewSetupId();
        int timepointRedirect = svi.viewId.getTimePointId();
        return this.getOrFetchImageLoader(asd).getSetupImgLoader(setupIdRedirect).getImageSize(timepointRedirect, level);
    }

    public RandomAccessibleInterval getImage(int setupId, int timepointId, int level, ImgLoaderHint ... hints) {
        SpimDataViewId sdvi = this.order.getOriginalLocation(new ViewId(timepointId, setupId));
        AbstractSpimData asd = sdvi.asd;
        int setupIdRedirect = sdvi.viewId.getViewSetupId();
        int timepointRedirect = sdvi.viewId.getTimePointId();
        return this.getOrFetchImageLoader(asd).getSetupImgLoader(setupIdRedirect).getImage(timepointRedirect, level, hints);
    }

    public double[][] getMipmapResolutions(int setupId) {
        return ((AbstractViewerSetupImgLoader)this.originImgLoaders.get(setupId)).getMipmapResolutions();
    }

    public AffineTransform3D[] getMipmapTransforms(int setupId) {
        return ((AbstractViewerSetupImgLoader)this.originImgLoaders.get(setupId)).getMipmapTransforms();
    }

    public int numMipmapLevels(int setupId) {
        return ((AbstractViewerSetupImgLoader)this.originImgLoaders.get(setupId)).numMipmapLevels();
    }

    public Dimensions getImageSize(int setupId, int timepointId) {
        SpimDataViewId svi = this.order.getOriginalLocation(new ViewId(timepointId, setupId));
        AbstractSpimData asd = svi.asd;
        int setupIdRedirect = svi.viewId.getViewSetupId();
        int timepointRedirect = svi.viewId.getTimePointId();
        return this.getOrFetchImageLoader(asd).getSetupImgLoader(setupIdRedirect).getImageSize(timepointRedirect);
    }

    public VoxelDimensions getVoxelSize(int setupId, int timepointId) {
        SpimDataViewId svi = this.order.getOriginalLocation(new ViewId(timepointId, setupId));
        AbstractSpimData asd = svi.asd;
        int setupIdRedirect = svi.viewId.getViewSetupId();
        int timepointRedirect = svi.viewId.getTimePointId();
        return this.getOrFetchImageLoader(asd).getSetupImgLoader(setupIdRedirect).getVoxelSize(timepointRedirect);
    }

    MultiResolutionImgLoader getOrFetchImageLoader(AbstractSpimData asd) {
        if (!this.spimdataImageLoaders.containsKey(asd)) {
            BasicImgLoader imgLoader = asd.getSequenceDescription().getImgLoader();
            if (!(imgLoader instanceof MultiResolutionImgLoader)) {
                logger.error("Origin image loader is not of instance MultiResolutionImgLoader, reoredering is not supported");
                throw new UnsupportedOperationException("Unsupported image loader class " + imgLoader.getClass());
            }
            if (!(imgLoader instanceof ViewerImgLoader)) {
                logger.error("Origin image loader is not of instance ViewerImgLoader, reoredering is not supported");
                throw new UnsupportedOperationException("Unsupported image loader class " + imgLoader.getClass());
            }
            this.spimdataImageLoaders.put(asd, (MultiResolutionImgLoader)imgLoader);
        }
        return this.spimdataImageLoaders.get(asd);
    }

    public static class SpimDataViewId {
        public AbstractSpimData asd;
        public ViewId viewId;
    }
}

