/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.spimdata.reordered;

import ch.epfl.biop.spimdata.reordered.ISetupOrder;
import ch.epfl.biop.spimdata.reordered.ReorderedImageLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.IntStream;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifReOrdered
implements ISetupOrder {
    transient AbstractSpimData spimdataOrigin;
    protected static transient Logger logger = LoggerFactory.getLogger(LifReOrdered.class);
    final int nTiles;
    final int nChannels;
    final String spimdataOriginPath;

    public LifReOrdered(String spimdataOriginPath, int nTiles, int nChannels) {
        this.spimdataOriginPath = spimdataOriginPath;
        this.nTiles = nTiles;
        this.nChannels = nChannels;
    }

    @Override
    public void initialize() {
        try {
            this.spimdataOrigin = new XmlIoSpimData().load(this.spimdataOriginPath);
        }
        catch (SpimDataException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ReorderedImageLoader.SpimDataViewId getOriginalLocation(ViewId viewId) {
        ReorderedImageLoader.SpimDataViewId svi = new ReorderedImageLoader.SpimDataViewId();
        svi.asd = this.spimdataOrigin;
        int timePointOrigin = 0;
        int viewSetupOrigin = viewId.getTimePointId() * (this.nTiles * this.nChannels) + viewId.getViewSetupId();
        svi.viewId = new ViewId(timePointOrigin, viewSetupOrigin);
        logger.debug("Current: [t = " + viewId.getTimePointId() + " s = " + viewId.getViewSetupId() + "] <- Origin [t = " + timePointOrigin + " s = " + viewSetupOrigin + "]");
        return svi;
    }

    public ViewId originToReorderedLocation(ViewId viewId) {
        int newTimePoint = viewId.getViewSetupId() / (this.nTiles * this.nChannels);
        int newSetupId = viewId.getViewSetupId() % (this.nTiles * this.nChannels);
        return new ViewId(newTimePoint, newSetupId);
    }

    public AbstractSpimData constructSpimData() {
        HashMap idToNewViewSetups = new HashMap();
        ArrayList newViewSetups = new ArrayList();
        int maxTimePoint = this.spimdataOrigin.getViewRegistrations().getViewRegistrations().keySet().stream().map(this::originToReorderedLocation).mapToInt(viewId -> viewId.getTimePointId()).max().getAsInt() + 1;
        logger.debug("Reordered spimdata max timepoint = " + maxTimePoint);
        ArrayList timePoints = new ArrayList();
        IntStream.range(0, maxTimePoint).forEach(tp -> timePoints.add(new TimePoint(tp)));
        ArrayList registrations = new ArrayList();
        ArrayList missingViews = new ArrayList();
        this.spimdataOrigin.getViewRegistrations().getViewRegistrations().keySet().stream().forEach(originViewId -> {
            ViewId newViewId = this.originToReorderedLocation((ViewId)originViewId);
            if (!idToNewViewSetups.containsKey(newViewId.getViewSetupId())) {
                BasicViewSetup bvs = (BasicViewSetup)this.spimdataOrigin.getSequenceDescription().getViewSetups().get(originViewId.getViewSetupId());
                ViewSetup newViewSetup = new ViewSetup(newViewId.getViewSetupId(), bvs.getName(), bvs.getSize(), bvs.getVoxelSize(), (Channel)bvs.getAttribute(Channel.class), (Angle)bvs.getAttribute(Angle.class), (Illumination)bvs.getAttribute(Illumination.class));
                bvs.getAttributes().forEach((name, entity) -> {
                    logger.debug("ViewSetupId : " + bvs.getId() + " " + name + ":" + entity);
                    newViewSetup.setAttribute(entity);
                });
                newViewSetups.add(newViewSetup);
                idToNewViewSetups.put(newViewId.getViewSetupId(), newViewSetup);
            }
            registrations.add(new ViewRegistration(newViewId.getTimePointId(), newViewId.getViewSetupId(), this.spimdataOrigin.getViewRegistrations().getViewRegistration(originViewId).getModel()));
        });
        newViewSetups.forEach(vs -> logger.debug(vs.getName()));
        logger.debug("Reordered spimdata number of setups = " + newViewSetups.size());
        SequenceDescription sd = new SequenceDescription(new TimePoints(timePoints), newViewSetups, null, new MissingViews(missingViews));
        sd.setImgLoader(new ReorderedImageLoader(this, (AbstractSequenceDescription<?, ?, ?>)sd, 4, 2));
        SpimData spimData = new SpimData(null, sd, new ViewRegistrations(registrations));
        return spimData;
    }
}

