/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.transform;

import bdv.util.source.time.MappedTimeSource;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import net.imglib2.converter.Converter;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceTimeMapper
implements Runnable,
Function<SourceAndConverter, SourceAndConverter> {
    SourceAndConverter sac_in;
    Function<Integer, Integer> timeMapper;
    private String name;

    public SourceTimeMapper(SourceAndConverter sac_in, Function<Integer, Integer> timeMapper, String name) {
        this.name = name;
        this.timeMapper = timeMapper;
        this.sac_in = sac_in;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter get() {
        return this.apply(this.sac_in);
    }

    @Override
    public SourceAndConverter apply(SourceAndConverter src) {
        SourceAndConverter sac;
        MappedTimeSource srcRsampled = new MappedTimeSource(src.asVolatile().getSpimSource(), this.name, this.timeMapper);
        if (src.asVolatile() != null) {
            MappedTimeSource vsrcRsampled = new MappedTimeSource(src.asVolatile().getSpimSource(), this.name, this.timeMapper);
            SourceAndConverter vsac = new SourceAndConverter(vsrcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.asVolatile().getConverter(), (SourceAndConverter)src.asVolatile()));
            sac = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.getConverter(), (SourceAndConverter)src), vsac);
        } else {
            sac = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.getConverter(), (SourceAndConverter)src));
        }
        return sac;
    }
}

