/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.transform;

import bdv.util.WrapVolatileSource;
import bdv.util.ZSlicedSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import java.util.function.Supplier;
import net.imglib2.converter.Converter;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceMosaicZSlicer
implements Runnable,
Function<SourceAndConverter, SourceAndConverter> {
    SourceAndConverter sac_in;
    SourceAndConverter model;
    boolean reuseMipMaps;
    boolean interpolate;
    boolean cache;
    Supplier<Long> subSlicer;

    public SourceMosaicZSlicer(SourceAndConverter sac_in, SourceAndConverter model, boolean reuseMipmaps, boolean cache, boolean interpolate, Supplier<Long> subSlicer) {
        this.reuseMipMaps = reuseMipmaps;
        this.model = model;
        this.sac_in = sac_in;
        this.interpolate = interpolate;
        this.cache = cache;
        this.subSlicer = subSlicer;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter get() {
        return this.apply(this.sac_in);
    }

    @Override
    public SourceAndConverter apply(SourceAndConverter src) {
        SourceAndConverter sac;
        ZSlicedSource srcRsampled = new ZSlicedSource(src.getSpimSource(), this.model.getSpimSource(), "ZSliced_" + src.getSpimSource().getName(), this.reuseMipMaps, this.cache, this.interpolate, this.subSlicer);
        if (src.asVolatile() != null) {
            Object vsrcRsampled = this.cache ? new WrapVolatileSource(srcRsampled) : new ZSlicedSource(src.asVolatile().getSpimSource(), this.model.getSpimSource(), "ZSliced_" + src.getSpimSource().getName(), this.reuseMipMaps, false, this.interpolate, this.subSlicer);
            SourceAndConverter vsac = new SourceAndConverter((Source)vsrcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.asVolatile().getConverter(), (SourceAndConverter)src.asVolatile()));
            sac = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.getConverter(), (SourceAndConverter)src), vsac);
        } else {
            sac = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)src.getConverter(), (SourceAndConverter)src));
        }
        return sac;
    }
}

