/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.transform;

import bdv.img.WarpedSource;
import bdv.util.Elliptical3DTransform;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.function.Function;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

public class Elliptic3DTransformer
implements Runnable,
Function<SourceAndConverter, SourceAndConverter> {
    SourceAndConverter sourceIn;
    Elliptical3DTransform e3Dt;
    SourceAndConverter sourceOut;

    public Elliptic3DTransformer(SourceAndConverter src, Elliptical3DTransform e3Dt) {
        this.sourceIn = src;
        this.e3Dt = e3Dt;
    }

    @Override
    public void run() {
        this.sourceOut = this.apply(this.sourceIn);
    }

    public SourceAndConverter getSourceOut() {
        return this.sourceOut;
    }

    @Override
    public SourceAndConverter apply(SourceAndConverter in) {
        WarpedSource ws = new WarpedSource(in.getSpimSource(), "Transform_" + this.e3Dt.getName() + "_" + in.getSpimSource().getName());
        ws.setBoundingBoxEstimator(new BoundingBoxEstimation(BoundingBoxEstimation.Method.CORNERS));
        ws.updateTransform((RealTransform)this.e3Dt);
        ws.setIsTransformed(true);
        if (in.asVolatile() != null) {
            WarpedSource vws = new WarpedSource(in.asVolatile().getSpimSource(), "Transform_" + this.e3Dt.getName() + "_" + in.asVolatile().getSpimSource().getName());
            vws.setBoundingBoxEstimator(new BoundingBoxEstimation(BoundingBoxEstimation.Method.CORNERS));
            vws.updateTransform((RealTransform)this.e3Dt);
            vws.setIsTransformed(true);
            SourceAndConverter vout = new SourceAndConverter((Source)vws, in.asVolatile().getConverter());
            SourceAndConverter out = new SourceAndConverter((Source)ws, in.getConverter(), vout);
            this.e3Dt.updateNotifiers.add(() -> {
                ws.updateTransform((RealTransform)this.e3Dt);
                vws.updateTransform((RealTransform)this.e3Dt);
                SourceAndConverterServices.getBdvDisplayService().getDisplaysOf(new SourceAndConverter[]{out}).forEach(bdvHandle -> bdvHandle.getViewerPanel().requestRepaint());
            });
            SourceAndConverterServices.getSourceAndConverterService().register(out);
            return out;
        }
        SourceAndConverter out = new SourceAndConverter((Source)ws, in.getConverter());
        this.e3Dt.updateNotifiers.add(() -> {
            ws.updateTransform((RealTransform)this.e3Dt);
            SourceAndConverterServices.getBdvDisplayService().getDisplaysOf(new SourceAndConverter[]{out}).forEach(bdvHandle -> bdvHandle.getViewerPanel().requestRepaint());
        });
        SourceAndConverterServices.getSourceAndConverterService().register(out);
        return out;
    }
}

