/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.register;

import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.fiji.imageplusutils.ImagePlusFunctions;
import ch.epfl.biop.java.utilities.roi.ConvertibleRois;
import ch.epfl.biop.java.utilities.roi.types.RealPointList;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusGetter;
import ch.epfl.biop.wrappers.elastix.DefaultElastixTask;
import ch.epfl.biop.wrappers.elastix.ElastixTask;
import ch.epfl.biop.wrappers.elastix.RegParamBSpline_Default;
import ch.epfl.biop.wrappers.elastix.RegisterHelper;
import ch.epfl.biop.wrappers.elastix.RegistrationParameters;
import ch.epfl.biop.wrappers.transformix.DefaultTransformixTask;
import ch.epfl.biop.wrappers.transformix.TransformHelper;
import ch.epfl.biop.wrappers.transformix.TransformixTask;
import ij.IJ;
import ij.ImagePlus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealPoint;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.InvertibleRealTransform;
import net.imglib2.realtransform.InvertibleWrapped2DTransformAs3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.ThinplateSplineTransform;
import net.imglib2.realtransform.inverse.WrappedIterativeInvertibleRealTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceRealTransformer;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

public class Elastix2DSplineRegister<FT extends NativeType<FT> & NumericType<FT>, MT extends NativeType<MT> & NumericType<MT>> {
    SourceAndConverter<FT>[] sacs_fixed;
    SourceAndConverter<MT>[] sacs_moving;
    int levelMipmapFixed;
    int levelMipmapMoving;
    int tpMoving;
    int tpFixed;
    RegisterHelper rh = new RegisterHelper();
    RealTransform realTransformOut;
    RealTransform realTransformInverseOut;
    double px;
    double py;
    double pz;
    double sx;
    double sy;
    double pxSizeInCurrentUnit;
    boolean interpolate = false;
    boolean showResultIJ1;
    int nbControlPointsX;
    int numberOfIterationPerScale;
    Supplier<TransformixTask> tt = () -> new DefaultTransformixTask();
    ElastixTask et = new DefaultElastixTask();
    double background_offset_value_moving = 0.0;
    double background_offset_value_fixed = 0.0;
    String errorMessage = "";

    public Elastix2DSplineRegister(SourceAndConverter<FT>[] sacs_fixed, int levelMipmapFixed, int tpFixed, SourceAndConverter<MT>[] sacs_moving, int levelMipmapMoving, int tpMoving, int nbControlPointsX, double pxSizeInCurrentUnit, double px, double py, double pz, double sx, double sy, int numberOfIterationPerScale, double background_offset_value_moving, double background_offset_value_fixed, boolean showResultIJ1) {
        this.sacs_fixed = sacs_fixed;
        this.sacs_moving = sacs_moving;
        this.pxSizeInCurrentUnit = pxSizeInCurrentUnit;
        this.px = px;
        this.py = py;
        this.pz = pz;
        this.sx = sx;
        this.sy = sy;
        this.levelMipmapFixed = levelMipmapFixed;
        this.levelMipmapMoving = levelMipmapMoving;
        this.tpFixed = tpFixed;
        this.tpMoving = tpMoving;
        this.showResultIJ1 = showResultIJ1;
        this.nbControlPointsX = nbControlPointsX;
        this.background_offset_value_fixed = background_offset_value_fixed;
        this.background_offset_value_moving = background_offset_value_moving;
        this.numberOfIterationPerScale = numberOfIterationPerScale;
    }

    public void setInterpolate(boolean interpolate) {
        this.interpolate = interpolate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean run() {
        RegistrationParameters rp;
        this.levelMipmapFixed = Math.min(this.levelMipmapFixed, this.sacs_fixed[0].getSpimSource().getNumMipmapLevels() - 1);
        this.levelMipmapMoving = Math.min(this.levelMipmapMoving, this.sacs_moving[0].getSpimSource().getNumMipmapLevels() - 1);
        ImagePlus croppedMoving = this.getCroppedImage("Moving", this.sacs_moving, this.tpMoving, this.levelMipmapMoving);
        ImagePlus croppedFixed = this.getCroppedImage("Fixed", this.sacs_fixed, this.tpFixed, this.levelMipmapFixed);
        Source sMoving = this.sacs_moving[0].getSpimSource();
        Source sFixed = this.sacs_fixed[0].getSpimSource();
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.identity();
        at3D.translate(new double[]{-this.px, -this.py, -this.pz});
        FinalRealInterval fi = new FinalRealInterval(new double[]{0.0, 0.0, 0.0}, new double[]{this.sx, this.sy, 0.0});
        AffineTransform3D atMoving = new AffineTransform3D();
        sMoving.getSourceTransform(this.tpMoving, this.levelMipmapMoving, atMoving);
        AffineTransform3D atFixed = new AffineTransform3D();
        sFixed.getSourceTransform(this.tpMoving, this.levelMipmapFixed, atFixed);
        if (this.background_offset_value_moving != 0.0) {
            System.err.println("Ignored background_offset_value_moving");
        }
        at3D.identity();
        at3D.translate(new double[]{-this.px, -this.py, -this.pz});
        if (this.background_offset_value_fixed != 0.0) {
            System.err.println("Ignored background_offset_value_fixed");
        }
        this.rh.setMovingImage(croppedMoving);
        this.rh.setFixedImage(croppedFixed);
        int nbControlPointsY = (int)((double)this.nbControlPointsX / (double)croppedFixed.getWidth() * (double)croppedFixed.getHeight());
        if (nbControlPointsY < 2) {
            nbControlPointsY = 2;
        }
        double dX = (double)croppedFixed.getWidth() / (double)this.nbControlPointsX;
        double dY = (double)croppedFixed.getHeight() / (double)nbControlPointsY;
        if (this.sacs_fixed.length > 1) {
            if (this.sacs_fixed.length == this.sacs_moving.length) {
                RegistrationParameters[] rps = new RegistrationParameters[this.sacs_fixed.length];
                for (int iCh = 0; iCh < this.sacs_fixed.length; ++iCh) {
                    rps[iCh] = this.getRegistrationParameters((int)dX);
                }
                rp = RegistrationParameters.combineRegistrationParameters((RegistrationParameters[])rps);
            } else {
                System.err.println("Cannot perform multichannel registration : non identical number of channels between moving and fixed sources.");
                rp = this.getRegistrationParameters((int)dX);
            }
        } else {
            rp = this.getRegistrationParameters((int)dX);
        }
        this.rh.addTransform(rp);
        try {
            this.rh.align(this.et);
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
            e.printStackTrace();
            return false;
        }
        if (this.showResultIJ1) {
            Class<Elastix2DSplineRegister> e = Elastix2DSplineRegister.class;
            // MONITORENTER : ch.epfl.biop.sourceandconverter.register.Elastix2DSplineRegister.class
            croppedFixed.show();
            ImagePlus transformedImage = ImagePlusFunctions.splitApplyRecompose(imp -> {
                TransformHelper th = new TransformHelper();
                th.setTransformFile(this.rh);
                th.setImage(imp);
                th.transform(this.tt.get());
                return (ImagePlus)th.getTransformedImage().to(ImagePlus.class);
            }, (ImagePlus)croppedMoving);
            transformedImage.show();
            IJ.run((ImagePlus)croppedFixed, (String)"Enhance Contrast", (String)"saturated=0.35");
            IJ.run((ImagePlus)transformedImage, (String)"Enhance Contrast", (String)"saturated=0.35");
            IJ.run((ImagePlus)croppedFixed, (String)"32-bit", (String)"");
            if (transformedImage.getNChannels() == 1 && croppedFixed.getNChannels() == 1) {
                IJ.run((ImagePlus)null, (String)"Merge Channels...", (String)"c1=Transformed_Moving c2=Fixed create");
            }
            // MONITOREXIT : e
        }
        ArrayList<RealPoint> fixedImageGridPointsInFixedImageCoordinates = new ArrayList<RealPoint>();
        for (int xi = 0; xi < this.nbControlPointsX; ++xi) {
            for (int yi = 0; yi < nbControlPointsY; ++yi) {
                RealPoint pt2 = new RealPoint(2);
                pt2.setPosition(new double[]{(double)xi * dX + dX / 2.0, (double)yi * dY + dY / 2.0});
                fixedImageGridPointsInFixedImageCoordinates.add(pt2);
            }
        }
        TransformHelper th = new TransformHelper();
        th.setTransformFile(this.rh);
        ConvertibleRois rois = new ConvertibleRois();
        RealPointList rpl = new RealPointList(fixedImageGridPointsInFixedImageCoordinates);
        rois.set((Object)rpl);
        th.setRois(rois);
        th.transform(this.tt.get());
        ConvertibleRois tr_rois = th.getTransformedRois();
        RealPointList rpl_tr = (RealPointList)tr_rois.to(RealPointList.class);
        AffineTransform3D nonRegisteredPatchTransformPixToGLobal = new AffineTransform3D();
        nonRegisteredPatchTransformPixToGLobal.identity();
        nonRegisteredPatchTransformPixToGLobal.scale(this.pxSizeInCurrentUnit);
        double cx = this.px;
        double cy = this.py;
        double cz = this.pz;
        nonRegisteredPatchTransformPixToGLobal.translate(new double[]{cx, cy, cz});
        List fixedImageGridPointsInGlobalCoordinates = fixedImageGridPointsInFixedImageCoordinates.stream().map(pt -> {
            double[] newPos = new double[3];
            double[] oldPos = new double[]{pt.positionAsDoubleArray()[0], pt.positionAsDoubleArray()[1], 0.0};
            nonRegisteredPatchTransformPixToGLobal.apply(oldPos, newPos);
            return new RealPoint(newPos);
        }).collect(Collectors.toList());
        List movingImageGridPointsInGlobalCoordinates = rpl_tr.ptList.stream().map(pt -> {
            double[] newPos = new double[3];
            double[] oldPos = new double[]{pt.positionAsDoubleArray()[0], pt.positionAsDoubleArray()[1], 0.0};
            nonRegisteredPatchTransformPixToGLobal.apply(oldPos, newPos);
            return new RealPoint(newPos);
        }).collect(Collectors.toList());
        double[][] coordsFixed = new double[2][this.nbControlPointsX * nbControlPointsY];
        double[][] coordsMoving = new double[2][this.nbControlPointsX * nbControlPointsY];
        int xi = 0;
        while (true) {
            if (xi >= this.nbControlPointsX) {
                WrappedIterativeInvertibleRealTransform invTransform = new WrappedIterativeInvertibleRealTransform((RealTransform)new ThinplateSplineTransform(coordsFixed, coordsMoving));
                this.realTransformOut = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)invTransform);
                WrappedIterativeInvertibleRealTransform invTransformPatch = new WrappedIterativeInvertibleRealTransform((RealTransform)new ThinplateSplineTransform(coordsMoving, coordsFixed));
                this.realTransformInverseOut = new InvertibleWrapped2DTransformAs3D((InvertibleRealTransform)invTransformPatch);
                return true;
            }
            for (int yi = 0; yi < nbControlPointsY; ++yi) {
                int idx = yi * this.nbControlPointsX + xi;
                double[] fixed_coords = ((RealPoint)fixedImageGridPointsInGlobalCoordinates.get(idx)).positionAsDoubleArray();
                double[] moving_coords = ((RealPoint)movingImageGridPointsInGlobalCoordinates.get(idx)).positionAsDoubleArray();
                coordsFixed[0][idx] = fixed_coords[0];
                coordsFixed[1][idx] = fixed_coords[1];
                coordsMoving[0][idx] = moving_coords[0];
                coordsMoving[1][idx] = moving_coords[1];
            }
            ++xi;
        }
    }

    private RegistrationParameters getRegistrationParameters(int gridSpacing) {
        RegParamBSpline_Default rp = new RegParamBSpline_Default();
        rp.AutomaticScalesEstimation = true;
        double maxSize = Math.max(this.sx / this.pxSizeInCurrentUnit, this.sy / this.pxSizeInCurrentUnit);
        int nScales = 0;
        while (Math.pow(2.0, nScales) < maxSize) {
            ++nScales;
        }
        rp.NumberOfResolutions = nScales - 2;
        rp.BSplineInterpolationOrder = 1;
        rp.MaximumNumberOfIterations = this.numberOfIterationPerScale;
        rp.FinalGridSpacingInVoxels = gridSpacing;
        return rp;
    }

    private <T extends NativeType<T> & NumericType<T>> ImagePlus getCroppedImage(String name, SourceAndConverter<T>[] sacs, int tp, int level) {
        FinalRealInterval window = new FinalRealInterval(new double[]{this.px, this.py, this.pz}, new double[]{this.px + this.sx, this.py + this.sy, this.pz + this.pxSizeInCurrentUnit});
        SourceAndConverter model = new EmptySourceAndConverterCreator("model", (RealInterval)window, this.pxSizeInCurrentUnit, this.pxSizeInCurrentUnit, this.pxSizeInCurrentUnit).get();
        SourceResampler resampler = new SourceResampler(null, model, model.getSpimSource().getName(), false, false, this.interpolate, level);
        List resampled = Arrays.stream(sacs).map(resampler).collect(Collectors.toList());
        ArrayList<Integer> channels = new ArrayList<Integer>(sacs.length);
        for (int i = 0; i < sacs.length; ++i) {
            channels.add(i);
        }
        ArrayList<Integer> slices = new ArrayList<Integer>();
        slices.add(0);
        ArrayList<Integer> timepoints = new ArrayList<Integer>();
        timepoints.add(tp);
        CZTRange range = new CZTRange(channels, slices, timepoints);
        return ImagePlusGetter.getImagePlus(name, resampled, 0, range, false, false, false, null);
    }

    public SourceAndConverter[] getRegisteredSacs() {
        SourceAndConverter[] out = new SourceAndConverter[this.sacs_moving.length];
        SourceRealTransformer srt = new SourceRealTransformer(null, this.realTransformOut);
        for (int iCh = 0; iCh < this.sacs_moving.length; ++iCh) {
            out[iCh] = srt.apply(this.sacs_moving[iCh]);
        }
        return out;
    }

    public RealTransform getRealTransform() {
        return this.realTransformOut;
    }

    public RealTransform getRealTransformInverse() {
        return this.realTransformInverseOut;
    }

    public void setRegistrationInfo(String taskInfo) {
        this.rh.setExtraRegisterInfo(taskInfo);
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

