/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.importer;

import bdv.util.RandomAccessibleIntervalSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.Random;
import java.util.function.Supplier;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.KDTree;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealPoint;
import net.imglib2.RealPointSampleList;
import net.imglib2.RealRandomAccessible;
import net.imglib2.algorithm.util.Grids;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.neighborsearch.NearestNeighborSearchInterpolatorFactory;
import net.imglib2.neighborsearch.NearestNeighborSearchOnKDTree;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class WeightedVoronoiSourceGetter
implements Runnable,
Supplier<SourceAndConverter> {
    final long[] imgSize;
    final int numPts;
    final boolean copyImg;

    public WeightedVoronoiSourceGetter(long[] imgSize, int numPts, boolean copyImg) {
        this.imgSize = imgSize;
        this.numPts = numPts;
        this.copyImg = copyImg;
    }

    @Override
    public void run() {
    }

    @Override
    public SourceAndConverter get() {
        RandomAccessibleInterval<FloatType> voronoi = WeightedVoronoiSourceGetter.getVoronoiTestLabelImage(this.imgSize, this.numPts, this.copyImg);
        VoxelDimensions voxDimensions = new VoxelDimensions(){

            public String unit() {
                return "undefined";
            }

            public void dimensions(double[] dimensions) {
                dimensions[0] = 1.0;
                dimensions[1] = 1.0;
                dimensions[2] = 1.0;
            }

            public double dimension(int d) {
                return 1.0;
            }

            public int numDimensions() {
                return 3;
            }
        };
        RandomAccessibleIntervalSource s = new RandomAccessibleIntervalSource(voronoi, (NumericType)new FloatType(), new AffineTransform3D(), "Voronoi_" + this.numPts + " Pts_[" + this.imgSize[0] + "," + this.imgSize[1] + "," + this.imgSize[2] + "]");
        return SourceAndConverterHelper.createSourceAndConverter((Source)s);
    }

    public static RandomAccessibleInterval<FloatType> getVoronoiTestLabelImage(long[] imgTestSize, int numPts, boolean copyImg) {
        FinalInterval interval = new FinalInterval(imgTestSize);
        RealPointSampleList<FloatType> realInterval = WeightedVoronoiSourceGetter.createRandomPoints((RealInterval)interval, numPts);
        NearestNeighborSearchOnKDTree search = new NearestNeighborSearchOnKDTree(new KDTree(realInterval));
        RealRandomAccessible realRandomAccessible = Views.interpolate((EuclideanSpace)search, (InterpolatorFactory)new NearestNeighborSearchInterpolatorFactory());
        RandomAccessibleOnRealRandomAccessible randomAccessible = Views.raster((RealRandomAccessible)realRandomAccessible);
        IntervalView labelImage = Views.interval((RandomAccessible)randomAccessible, (Interval)interval);
        if (copyImg) {
            ArrayImg labelImageCopy = new ArrayImgFactory((NativeType)Util.getTypeFromInterval((Interval)labelImage)).create((Dimensions)labelImage);
            Grids.collectAllContainedIntervals((long[])imgTestSize, (int[])new int[]{64, 64, 64}).forEach(arg_0 -> WeightedVoronoiSourceGetter.lambda$getVoronoiTestLabelImage$0((RandomAccessibleInterval)labelImage, (RandomAccessibleInterval)labelImageCopy, arg_0));
            return labelImageCopy;
        }
        return labelImage;
    }

    public static <T extends Type<T>> void copy(RandomAccessible<T> source, IterableInterval<T> target) {
        Cursor targetCursor = target.localizingCursor();
        RandomAccess sourceRandomAccess = source.randomAccess();
        while (targetCursor.hasNext()) {
            targetCursor.fwd();
            sourceRandomAccess.setPosition((Localizable)targetCursor);
            ((Type)targetCursor.get()).set((Type)sourceRandomAccess.get());
        }
    }

    public static RealPointSampleList<FloatType> createRandomPoints(RealInterval interval, int numPoints) {
        int numDimensions = interval.numDimensions();
        Random rnd = new Random(2001L);
        RealPointSampleList elements = new RealPointSampleList(numDimensions);
        for (int i = 0; i < numPoints; ++i) {
            RealPoint point = new RealPoint(numDimensions);
            for (int d = 0; d < numDimensions; ++d) {
                point.setPosition(rnd.nextDouble() * (interval.realMax(d) - interval.realMin(d)) + interval.realMin(d), d);
            }
            double r0 = 600.0;
            double rx0 = 0.8;
            double ry0 = 1.0;
            double rz0 = 1.5;
            double rx = (point.getDoublePosition(0) - 1024.0) * rx0;
            double ry = (point.getDoublePosition(1) - 1024.0) * ry0;
            double rz = (point.getDoublePosition(2) - 1024.0) * rz0;
            double r = Math.sqrt(rx * rx + ry * ry + rz * rz);
            double factor = (r - r0) * (r - r0);
            factor = Math.max(0.0, 1.0 - factor * factor / 1.0E8);
            elements.add(point, (Object)new FloatType((float)factor * 255.0f));
        }
        return elements;
    }

    private static /* synthetic */ void lambda$getVoronoiTestLabelImage$0(RandomAccessibleInterval labelImage, RandomAccessibleInterval labelImageCopy, Interval blockinterval) {
        WeightedVoronoiSourceGetter.copy(labelImage, Views.interval((RandomAccessible)labelImageCopy, (Interval)blockinterval));
    }
}

