/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.exporter;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ij.ImagePlus;
import ij.VirtualStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.LUT;
import ij.process.ShortProcessor;
import java.awt.Color;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.type.volatiles.VolatileARGBType;
import net.imglib2.type.volatiles.VolatileFloatType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedShortType;
import net.imglib2.util.Util;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.scijava.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceAndConverterVirtualStack<T extends NumericType<T> & NativeType<T>>
extends VirtualStack {
    private static final Logger logger = LoggerFactory.getLogger(SourceAndConverterVirtualStack.class);
    final int bitDepth;
    final int size;
    final int height;
    final int width;
    Map<Integer, ImageProcessor> cachedImageProcessor = new ConcurrentHashMap<Integer, ImageProcessor>();
    Map<Integer, Object> currentlyProcessedProcessor = new HashMap<Integer, Object>();
    Map<CZTId, Integer> cztIdToComputedProcessor = new HashMap<CZTId, Integer>();
    final List<SourceAndConverter<T>> sources;
    final int resolutionLevel;
    final CZTRange range;
    final int nBytesPerProcessor;
    final int nPixPerPlane;
    final AtomicLong bytesCounter;
    final boolean cache;
    final int totalPlanes;
    final Task task;
    private final long totalBytes;
    ImagePlus imagePlusLocalizer = null;
    final Object lockAnalyzePreviousData = new Object();

    public SourceAndConverterVirtualStack(List<SourceAndConverter<T>> sources, int resolutionLevel, CZTRange range, AtomicLong bytesCounter, boolean cache, Task task) {
        this.cache = cache;
        this.task = task;
        int tModel = range.getRangeT().get(0);
        RandomAccessibleInterval raiModel = sources.get(0).asVolatile() != null ? sources.get(0).asVolatile().getSpimSource().getSource(tModel, resolutionLevel) : sources.get(0).getSpimSource().getSource(tModel, resolutionLevel);
        this.width = (int)raiModel.dimension(0);
        this.height = (int)raiModel.dimension(1);
        this.size = (int)range.getTotalPlanes();
        Object type = Util.getTypeFromInterval((Interval)raiModel);
        if (type instanceof UnsignedShortType || type instanceof VolatileUnsignedShortType) {
            this.bitDepth = 16;
        } else if (type instanceof UnsignedByteType || type instanceof VolatileUnsignedByteType) {
            this.bitDepth = 8;
        } else if (type instanceof FloatType || type instanceof VolatileFloatType) {
            this.bitDepth = 32;
        } else if (type instanceof ARGBType || type instanceof VolatileARGBType) {
            this.bitDepth = 24;
        } else {
            this.bitDepth = -1;
            throw new UnsupportedOperationException("Type " + type.getClass() + " unsupported.");
        }
        this.nBytesPerProcessor = this.width * this.height * (this.bitDepth / 8);
        this.sources = sources;
        this.resolutionLevel = resolutionLevel;
        this.range = range;
        this.nPixPerPlane = this.width * this.height;
        this.bytesCounter = bytesCounter;
        this.totalPlanes = (int)range.getTotalPlanes();
        this.totalBytes = (long)this.totalPlanes * (long)this.nBytesPerProcessor;
    }

    public void setImagePlusCZTSLocalizer(ImagePlus imp) {
        this.imagePlusLocalizer = imp;
    }

    public Object getPixels(int n) {
        ImageProcessor ip = this.getProcessor(n);
        if (ip != null) {
            return ip.getPixels();
        }
        return null;
    }

    public boolean noSourcePresent(SourceAndConverter sac, int iZ, int iT) {
        return !sac.getSpimSource().isPresent(iT);
    }

    public ByteProcessor getByteProcessor(int iC, int iZ, int iT) {
        SourceAndConverter<T> sac = this.sources.get(iC);
        if (this.noSourcePresent(sac, iZ, iT)) {
            return new ByteProcessor(this.width, this.height);
        }
        RandomAccessibleInterval rai = sac.getSpimSource().getSource(iT, this.resolutionLevel);
        IntervalView slice = Views.hyperSlice((RandomAccessibleInterval)rai, (int)2, (long)iZ);
        byte[] bytes = new byte[this.nPixPerPlane];
        IterableInterval ii = Views.flatIterable((RandomAccessibleInterval)slice);
        int idx = 0;
        Cursor s = ii.cursor();
        while (s.hasNext()) {
            bytes[idx] = (byte)((UnsignedByteType)s.next()).get();
            ++idx;
        }
        if (this.task != null) {
            long bytesLoaded = this.bytesCounter.addAndGet(this.nBytesPerProcessor);
            this.task.setProgressValue(bytesLoaded);
            if (bytesLoaded == this.totalBytes) {
                this.task.run(() -> {});
            }
        }
        return new ByteProcessor(this.width, this.height, bytes, this.getCM(iC));
    }

    public ShortProcessor getShortProcessor(int iC, int iZ, int iT) {
        SourceAndConverter<T> sac = this.sources.get(iC);
        if (this.noSourcePresent(sac, iZ, iT)) {
            return new ShortProcessor(this.width, this.height);
        }
        RandomAccessibleInterval rai = sac.getSpimSource().getSource(iT, this.resolutionLevel);
        IntervalView slice = Views.hyperSlice((RandomAccessibleInterval)rai, (int)2, (long)iZ);
        short[] shorts = new short[this.nPixPerPlane];
        IterableInterval ii = Views.flatIterable((RandomAccessibleInterval)slice);
        int idx = 0;
        Cursor s = ii.cursor();
        while (s.hasNext()) {
            shorts[idx] = (short)((UnsignedShortType)s.next()).get();
            ++idx;
        }
        if (this.task != null) {
            long bytesLoaded = this.bytesCounter.addAndGet(this.nBytesPerProcessor);
            this.task.setProgressValue(bytesLoaded);
            if (bytesLoaded == this.totalBytes) {
                this.task.run(() -> {});
            }
        }
        return new ShortProcessor(this.width, this.height, shorts, this.getCM(iC));
    }

    ColorModel getCM(int iC) {
        if (this.imagePlusLocalizer == null) {
            return null;
        }
        LUT[] luts = this.imagePlusLocalizer.getLuts();
        if (luts.length > iC && luts[iC] != null && luts[iC].getColorModel() != null) {
            return luts[iC].getColorModel();
        }
        LUT lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)255), ARGBType.green((int)255), ARGBType.blue((int)255)));
        logger.debug("Null Color Model");
        return lut.getColorModel();
    }

    public FloatProcessor getFloatProcessor(int iC, int iZ, int iT) {
        SourceAndConverter<T> sac = this.sources.get(iC);
        if (this.noSourcePresent(sac, iZ, iT)) {
            return new FloatProcessor(this.width, this.height);
        }
        RandomAccessibleInterval rai = sac.getSpimSource().getSource(iT, this.resolutionLevel);
        IntervalView slice = Views.hyperSlice((RandomAccessibleInterval)rai, (int)2, (long)iZ);
        float[] floats = new float[this.nPixPerPlane];
        IterableInterval ii = Views.flatIterable((RandomAccessibleInterval)slice);
        int idx = 0;
        Cursor s = ii.cursor();
        while (s.hasNext()) {
            floats[idx] = ((FloatType)s.next()).get();
            ++idx;
        }
        if (this.task != null) {
            long bytesLoaded = this.bytesCounter.addAndGet(this.nBytesPerProcessor);
            this.task.setProgressValue(bytesLoaded);
            if (bytesLoaded == this.totalBytes) {
                this.task.run(() -> {});
            }
        }
        return new FloatProcessor(this.width, this.height, floats, this.getCM(iC));
    }

    public ColorProcessor getColorProcessor(int iC, int iZ, int iT) {
        SourceAndConverter<T> sac = this.sources.get(iC);
        if (this.noSourcePresent(sac, iZ, iT)) {
            return new ColorProcessor(this.width, this.height);
        }
        RandomAccessibleInterval rai = sac.getSpimSource().getSource(iT, this.resolutionLevel);
        IntervalView slice = Views.hyperSlice((RandomAccessibleInterval)rai, (int)2, (long)iZ);
        int[] ints = new int[this.nPixPerPlane];
        IterableInterval ii = Views.flatIterable((RandomAccessibleInterval)slice);
        int idx = 0;
        Cursor s = ii.cursor();
        while (s.hasNext()) {
            ints[idx] = ((ARGBType)s.next()).get();
            ++idx;
        }
        if (this.task != null) {
            long bytesLoaded = this.bytesCounter.addAndGet(this.nBytesPerProcessor);
            this.task.setProgressValue(bytesLoaded);
            if (bytesLoaded == this.totalBytes) {
                this.task.run(() -> {});
            }
        }
        return new ColorProcessor(this.width, this.height, ints);
    }

    public void setProcessor(ImageProcessor ip, int n) {
        this.cachedImageProcessor.put(n, ip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageProcessor getProcessor(int n) {
        Object lockWaitedFor = null;
        if (n == 1 && this.cachedImageProcessor.containsKey(n)) {
            return (ImageProcessor)this.cachedImageProcessor.get(n).clone();
        }
        int[] czt = this.imagePlusLocalizer == null ? new int[]{1, 1, 1} : this.imagePlusLocalizer.convertIndexToPosition(n);
        boolean waitForResult = false;
        if (this.cache) {
            Object lockProcessing;
            int iC = this.range.getRangeC().get(czt[0] - 1);
            int iZ = this.range.getRangeZ().get(czt[1] - 1);
            int iT = this.range.getRangeT().get(czt[2] - 1);
            CZTId cztId = new CZTId(iC, iZ, iT);
            Object object = this.lockAnalyzePreviousData;
            synchronized (object) {
                if (this.cachedImageProcessor.containsKey(n)) {
                    return this.cachedImageProcessor.get(n);
                }
                if (this.currentlyProcessedProcessor.containsKey(n)) {
                    lockWaitedFor = this.currentlyProcessedProcessor.get(n);
                    waitForResult = true;
                } else {
                    if (this.cztIdToComputedProcessor.containsKey(cztId)) {
                        int nReferenced = this.cztIdToComputedProcessor.get(cztId);
                        this.cachedImageProcessor.put(n, this.cachedImageProcessor.get(nReferenced));
                        if (this.task != null) {
                            long bytesLoaded = this.bytesCounter.addAndGet(this.nBytesPerProcessor);
                            this.task.setProgressValue(bytesLoaded);
                            if (bytesLoaded == this.totalBytes) {
                                this.task.run(() -> {});
                            }
                        }
                        return this.cachedImageProcessor.get(n);
                    }
                    this.currentlyProcessedProcessor.put(n, new Object());
                }
            }
            if (waitForResult) {
                object = lockWaitedFor;
                synchronized (object) {
                    while (!this.cachedImageProcessor.containsKey(n)) {
                        try {
                            lockWaitedFor.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                return this.cachedImageProcessor.get(n);
            }
            Object object2 = lockProcessing = this.currentlyProcessedProcessor.get(n);
            synchronized (object2) {
                ByteProcessor ip = null;
                switch (this.bitDepth) {
                    case 8: {
                        ip = this.getByteProcessor(iC, iZ, iT);
                        break;
                    }
                    case 16: {
                        ip = this.getShortProcessor(iC, iZ, iT);
                        break;
                    }
                    case 24: {
                        ip = this.getColorProcessor(iC, iZ, iT);
                        break;
                    }
                    case 32: {
                        ip = this.getFloatProcessor(iC, iZ, iT);
                    }
                }
                Object object3 = this.lockAnalyzePreviousData;
                synchronized (object3) {
                    this.cztIdToComputedProcessor.put(cztId, n);
                    this.currentlyProcessedProcessor.remove(n);
                }
                this.cachedImageProcessor.put(n, (ImageProcessor)ip);
                lockProcessing.notifyAll();
            }
            return this.cachedImageProcessor.get(n);
        }
        int iC = this.range.getRangeC().get(czt[0] - 1);
        int iZ = this.range.getRangeZ().get(czt[1] - 1);
        int iT = this.range.getRangeT().get(czt[2] - 1);
        switch (this.bitDepth) {
            case 8: {
                return this.getByteProcessor(iC, iZ, iT);
            }
            case 16: {
                return this.getShortProcessor(iC, iZ, iT);
            }
            case 24: {
                return this.getColorProcessor(iC, iZ, iT);
            }
            case 32: {
                return this.getFloatProcessor(iC, iZ, iT);
            }
        }
        throw new UnsupportedOperationException("Invalid bitdepth " + this.bitDepth);
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public int getSize() {
        return this.size;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public static class CZTId {
        final int c;
        final int z;
        final int t;

        public CZTId(int c, int z, int t) {
            this.c = c;
            this.z = z;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CZTId cztId = (CZTId)o;
            return this.c == cztId.c && this.z == cztId.z && this.t == cztId.t;
        }

        public int hashCode() {
            return Objects.hash(this.c, this.z, this.t);
        }
    }
}

