/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.exporter;

import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IntRangeParser {
    final String expression;

    public IntRangeParser(String expression) {
        this.expression = expression;
    }

    public List<Integer> get(int length) throws Exception {
        if (this.expression == null || this.expression.trim().equals("")) {
            return IntStream.range(0, length).boxed().collect(Collectors.toList());
        }
        String[] blocks = this.expression.split(",");
        LinkedList<Integer> list = new LinkedList<Integer>();
        int location = 0;
        for (String block : blocks) {
            int endInclusive;
            int startInclusive;
            location += block.length();
            String[] params = block.split(":");
            if (params.length == 1) {
                list.add((int)IntRangeParser.cvt(block, length));
                continue;
            }
            if (params.length == 2) {
                startInclusive = (int)IntRangeParser.cvt(params[0], length);
                endInclusive = (int)IntRangeParser.cvt(params[1], length);
                if (endInclusive < startInclusive) {
                    throw new Exception("Wrong range : max (" + endInclusive + ") is inferior to min (" + startInclusive + ")");
                }
                list.addAll(IntStream.range(startInclusive, endInclusive + 1).boxed().collect(Collectors.toList()));
                continue;
            }
            if (params.length == 3) {
                double index;
                startInclusive = (int)IntRangeParser.cvt(params[0], length);
                endInclusive = (int)IntRangeParser.cvt(params[2], length);
                double step = IntRangeParser.cvtDouble(params[1], length);
                if (step == 0.0) {
                    throw new Exception("Error step size is zero.");
                }
                if (step > 0.0 && endInclusive < startInclusive) {
                    throw new Exception("Wrong range : max (" + endInclusive + ") is inferior to min (" + startInclusive + ") with a positive step (" + step + ").");
                }
                if (step < 0.0 && endInclusive > startInclusive) {
                    throw new Exception("Wrong range : max (" + endInclusive + ") is superior to min (" + startInclusive + ") with a negative step (" + step + ").");
                }
                if (step > 0.0) {
                    for (index = (double)startInclusive; index <= (double)endInclusive; index += step) {
                        list.add((int)index);
                    }
                    continue;
                }
                for (index = (double)startInclusive; index >= (double)endInclusive; index += step) {
                    list.add((int)index);
                }
                continue;
            }
            throw new ParseException("Wrong number of arguments in index expression", location);
        }
        for (Integer i : list) {
            if (i < 0) {
                throw new Exception("Invalid negative index (" + i + ")");
            }
            if (i < length) continue;
            throw new Exception("Out of bounds index (" + i + ") found in expression");
        }
        return list;
    }

    static double cvt(String arg, int length) throws Exception {
        double value = Double.valueOf(arg);
        if (value < 0.0) {
            value = (double)length + value;
        }
        return value;
    }

    static double cvtDouble(String arg, int length) throws Exception {
        return Double.valueOf(arg);
    }

    public String toString() {
        return this.expression;
    }

    public static void main(String ... args) throws Exception {
        int maxDisplay = 200;
        IntRangeParser.TestExpression("", 0, maxDisplay);
        IntRangeParser.TestExpression("", 1, maxDisplay);
        IntRangeParser.TestExpression("", 10, maxDisplay);
        IntRangeParser.TestExpression(null, 0, maxDisplay);
        IntRangeParser.TestExpression(null, 1, maxDisplay);
        IntRangeParser.TestExpression(null, 10, maxDisplay);
        IntRangeParser.TestExpression("0", 0, maxDisplay);
        IntRangeParser.TestExpression("0", 1, maxDisplay);
        IntRangeParser.TestExpression("0:0", 0, maxDisplay);
        IntRangeParser.TestExpression("0:1", 1, maxDisplay);
        IntRangeParser.TestExpression("0:0", 1, maxDisplay);
        IntRangeParser.TestExpression("0:-1", 1, maxDisplay);
        IntRangeParser.TestExpression("0:-1", 10, maxDisplay);
        IntRangeParser.TestExpression("0:9", 10, maxDisplay);
        IntRangeParser.TestExpression("0:2:-1", 10, maxDisplay);
        IntRangeParser.TestExpression("0:2:9", 10, maxDisplay);
        IntRangeParser.TestExpression("-1:-2:0", 10, maxDisplay);
        IntRangeParser.TestExpression("9:-2:0", 10, maxDisplay);
        IntRangeParser.TestExpression("-1:-1:0", 10, maxDisplay);
        IntRangeParser.TestExpression("9:-1:0", 10, maxDisplay);
        IntRangeParser.TestExpression("0:0.5:-1", 10, maxDisplay);
        IntRangeParser.TestExpression("0:0.5:9", 10, maxDisplay);
        IntRangeParser.TestExpression("0:0.5:9,9", 10, maxDisplay);
        IntRangeParser.TestExpression("-1:-0.5:0", 10, maxDisplay);
        IntRangeParser.TestExpression("9:-0.5:0", 10, maxDisplay);
        IntRangeParser.TestExpression("0:0.5:-1,0:0.5:9", 10, maxDisplay);
        IntRangeParser.TestExpression("-1:-0.5:0,9:-0.5:0", 10, maxDisplay);
    }

    public static void TestExpression(String expression, int length, int maxDisplayed) {
        try {
            System.out.println("Testing " + expression + " with length = " + length);
            List<Integer> out = new IntRangeParser(expression).get(length);
            if (out.size() < maxDisplayed) {
                out.stream().forEach(i -> System.out.print(i + ","));
                System.out.println();
            } else {
                System.out.println("More than " + maxDisplayed + " elements, first = " + out.get(0) + " last = " + out.get(out.size() - 1));
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.getMessage());
        }
    }
}

