/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.exporter;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusGetter;
import ij.ImagePlus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import org.scijava.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

public class ImagePlusSampler {
    private static Logger logger = LoggerFactory.getLogger(ImagePlusSampler.class);

    public static Builder Builder() {
        return new Builder();
    }

    private static <T extends NumericType<T> & NativeType<T>> ImagePlus get(String imageName, List<SourceAndConverter<T>> sourceList, SourceAndConverter model, boolean automipmap, int level, CZTRange range, String unit, boolean interpolate, boolean virtual, boolean cache, Task task, boolean parallelC, boolean parallelZ, boolean parallelT) throws UnsupportedOperationException {
        if (sourceList.size() == 0) {
            throw new UnsupportedOperationException("No input sources");
        }
        if (sourceList.stream().map(sac -> ((NumericType)sac.getSpimSource().getType()).getClass()).distinct().count() > 1L) {
            throw new UnsupportedOperationException("Cannot make composite because all sources are not of the same type");
        }
        List resampledSourceList = sourceList.stream().map(sac -> new SourceResampler(sac, model, sac.getSpimSource().getName() + "_SampledLike_" + model.getSpimSource().getName(), automipmap, cache, interpolate, level).get()).collect(Collectors.toList());
        SourceAndConverterServices.getSourceAndConverterService().register(model);
        int timepointbegin = 0;
        ImagePlus compositeImage = !virtual ? ImagePlusGetter.getImagePlus(imageName, resampledSourceList, 0, range, parallelC, parallelZ, parallelT, task) : ImagePlusGetter.getVirtualImagePlus(imageName, resampledSourceList, 0, range, cache, task);
        compositeImage.setTitle(imageName);
        AffineTransform3D at3D = new AffineTransform3D();
        model.getSpimSource().getSourceTransform(timepointbegin, 0, at3D);
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)compositeImage, (AffineTransform3D)at3D, (String)unit, (int)timepointbegin);
        compositeImage.show();
        return compositeImage;
    }

    public static class Builder {
        private String imageName = "Image";
        private SourceAndConverter[] sacs = new SourceAndConverter[0];
        private SourceAndConverter<?> model;
        private boolean interpolate;
        private boolean cache = true;
        private boolean virtual = false;
        private int level = -1;
        private String unit;
        private CZTRange.Builder rangeBuilder = new CZTRange.Builder();
        private Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter = sacslist -> SourceAndConverterHelper.sortDefaultGeneric((Collection)sacslist);
        private boolean parallelC = false;
        private boolean parallelZ = false;
        private boolean parallelT = false;
        transient Task task = null;

        public Builder sources(SourceAndConverter[] sacs) {
            this.sacs = sacs;
            return this;
        }

        public Builder sort(Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter) {
            this.sorter = sorter;
            return this;
        }

        public Builder setModel(SourceAndConverter<?> model) {
            this.model = model;
            return this;
        }

        public Builder rangeC(String rangeC) {
            this.rangeBuilder.setC(rangeC);
            return this;
        }

        public Builder rangeT(String rangeT) {
            this.rangeBuilder.setT(rangeT);
            return this;
        }

        public Builder rangeZ(String rangeZ) {
            this.rangeBuilder.setZ(rangeZ);
            return this;
        }

        public Builder monitor(Task task) {
            this.task = task;
            return this;
        }

        public Builder virtual(boolean flag) {
            this.virtual = flag;
            return this;
        }

        public Builder level(int level) {
            this.level = level;
            return this;
        }

        public Builder interpolate(boolean flag) {
            this.interpolate = flag;
            return this;
        }

        public Builder cache(boolean flag) {
            this.cache = flag;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public Builder title(String title) {
            this.imageName = title;
            return this;
        }

        public Builder parallelC() {
            this.parallelC = true;
            return this;
        }

        public Builder parallelC(boolean flag) {
            this.parallelC = flag;
            return this;
        }

        public Builder parallelZ() {
            this.parallelZ = true;
            return this;
        }

        public Builder parallelZ(boolean flag) {
            this.parallelZ = flag;
            return this;
        }

        public Builder parallelT() {
            this.parallelT = true;
            return this;
        }

        public Builder parallelT(boolean flag) {
            this.parallelT = flag;
            return this;
        }

        public ImagePlus get() throws Exception {
            int maxTimeFrames = SourceAndConverterHelper.getMaxTimepoint((SourceAndConverter[])this.sacs);
            int maxZSlices = (int)this.model.getSpimSource().getSource(0, this.level).dimension(2);
            CZTRange range = this.rangeBuilder.get(this.sacs.length, maxZSlices, maxTimeFrames);
            return ImagePlusSampler.get(this.imageName, Arrays.asList(this.sacs), this.model, this.level == -1, this.level, range, this.unit, this.interpolate, this.virtual, this.cache, this.task, this.parallelC, this.parallelZ, this.parallelT);
        }
    }
}

