/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter.exporter;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ch.epfl.biop.sourceandconverter.exporter.SourceAndConverterVirtualStack;
import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.HyperStackConverter;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.LinearRange;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import org.scijava.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class ImagePlusGetter {
    private static final Logger logger = LoggerFactory.getLogger(ImagePlusGetter.class);

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus getVirtualImagePlus(String name, List<SourceAndConverter<T>> sources, int resolutionLevel, CZTRange range, boolean cache, Task task) {
        boolean monitor;
        AtomicLong bytesCounter = new AtomicLong();
        if (!cache) {
            task = null;
        }
        SourceAndConverterVirtualStack<T> vStack = new SourceAndConverterVirtualStack<T>(sources, resolutionLevel, range, bytesCounter, cache, task);
        vStack.getProcessor(1);
        ImagePlus out = new ImagePlus(name, vStack);
        int[] czt = range.getCZTDimensions();
        if (out.getBitDepth() == 24 && czt[0] > 1) {
            IJ.log((String)"Error: RGB Images cannot be multichannel");
            throw new UnsupportedOperationException("RGB Images cannot be multichannel");
        }
        if (czt[0] + czt[1] + czt[2] > 3 && out.getBitDepth() != 24) {
            out = HyperStackConverter.toHyperStack((ImagePlus)out, (int)czt[0], (int)czt[1], (int)czt[2], null, (String)"color");
            out.setStack(vStack);
        }
        vStack.setImagePlusCZTSLocalizer(out);
        long totalBytes = (long)range.getRangeC().size() * (long)range.getRangeZ().size() * (long)range.getRangeT().size() * (long)(vStack.getBitDepth() / 8) * (long)vStack.getHeight() * (long)vStack.getWidth();
        boolean bl = monitor = task != null;
        if (monitor) {
            task.setStatusMessage("Counting bytes...");
            task.setProgressMaximum(totalBytes);
        }
        if (czt[0] + czt[1] + czt[2] > 3) {
            LUT[] luts = new LUT[range.getRangeC().size()];
            int iC = 0;
            for (Integer sourceIndex : range.getRangeC()) {
                SourceAndConverter<T> sac = sources.get(sourceIndex);
                if (!(sac.getSpimSource().getType() instanceof ARGBType)) {
                    LUT lut;
                    ColorConverter converter;
                    if (sac.getConverter() instanceof ColorConverter) {
                        converter = (ColorConverter)sac.getConverter();
                        ARGBType c = converter.getColor();
                        lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)c.get()), ARGBType.green((int)c.get()), ARGBType.blue((int)c.get())));
                    } else {
                        lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)255), ARGBType.green((int)255), ARGBType.blue((int)255)));
                    }
                    luts[iC] = lut;
                    out.setC(iC + 1);
                    out.getProcessor().setLut(lut);
                    if (sac.getConverter() instanceof LinearRange) {
                        converter = (LinearRange)sac.getConverter();
                        out.setDisplayRange(converter.getMin(), converter.getMax());
                    }
                }
                ++iC;
            }
            boolean oneIsNull = false;
            for (LUT lut : luts) {
                if (lut != null) continue;
                oneIsNull = true;
                break;
            }
            if (!oneIsNull && out instanceof CompositeImage) {
                ((CompositeImage)out).setLuts(luts);
            }
        }
        AffineTransform3D at3D = new AffineTransform3D();
        int timepointbegin = 0;
        sources.get(0).getSpimSource().getSourceTransform(timepointbegin, resolutionLevel, at3D);
        String unit = "px";
        if (sources.get(0).getSpimSource().getVoxelDimensions() != null && (unit = sources.get(0).getSpimSource().getVoxelDimensions().unit()) == null) {
            unit = "px";
        }
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)out, (AffineTransform3D)at3D, (String)unit, (int)timepointbegin);
        return out;
    }

    public static <T extends NumericType<T> & NativeType<T>> ImagePlus getImagePlus(String name, List<SourceAndConverter<T>> sources, int resolutionLevel, CZTRange range, boolean parallelC, boolean parallelZ, boolean parallelT, Task task) {
        boolean monitor;
        ImagePlus vImage = ImagePlusGetter.getVirtualImagePlus(name, sources, resolutionLevel, range, false, null);
        AtomicLong bytesCounter = new AtomicLong();
        int nBytesPerPlane = vImage.getHeight() * vImage.getWidth() * (vImage.getBitDepth() / 8);
        long totalBytes = (long)range.getRangeC().size() * (long)range.getRangeZ().size() * (long)range.getRangeT().size() * (long)nBytesPerPlane;
        boolean bl = monitor = task != null;
        if (monitor) {
            task.setStatusMessage("Counting bytes...");
            task.setProgressMaximum(totalBytes);
        }
        int w = vImage.getWidth();
        int h = vImage.getHeight();
        ImageStack vStack = vImage.getStack();
        ImageStack stack = ImageStack.create((int)w, (int)h, (int)((int)range.getTotalPlanes()), (int)vImage.getBitDepth());
        ImagePlus imp = new ImagePlus(name, stack);
        int[] czt = range.getCZTDimensions();
        if (imp.getBitDepth() != 24 && czt[0] + czt[1] + czt[2] > 3) {
            imp = HyperStackConverter.toHyperStack((ImagePlus)imp, (int)czt[0], (int)czt[1], (int)czt[2]);
        }
        ImagePlus image = imp;
        Stream cStream = range.rangeC.stream();
        if (parallelC) {
            cStream = (Stream)cStream.parallel();
        }
        cStream.forEach(c -> {
            Stream tStream = range.rangeT.stream();
            if (parallelT) {
                tStream = (Stream)tStream.parallel();
            }
            tStream.forEach(t -> {
                Stream zStream = range.rangeZ.stream();
                if (parallelZ) {
                    zStream = (Stream)zStream.parallel();
                }
                zStream.forEach(z -> {
                    int iC = range.rangeC.indexOf(c);
                    int iZ = range.rangeZ.indexOf(z);
                    int iT = range.rangeT.indexOf(t);
                    int n = image.getStackIndex(iC + 1, iZ + 1, iT + 1);
                    ImageProcessor ip = vStack.getProcessor(n);
                    if (n == 1) {
                        image.setProcessor(ip);
                    }
                    stack.setProcessor(ip, n);
                    if (monitor) {
                        long bytes = bytesCounter.addAndGet(nBytesPerPlane);
                        task.setProgressValue(bytes);
                    }
                });
            });
        });
        if (czt[0] + czt[1] + czt[2] > 3) {
            LUT[] luts = new LUT[range.getRangeC().size()];
            int iC = 0;
            for (Integer sourceIndex : range.getRangeC()) {
                SourceAndConverter<T> sac = sources.get(sourceIndex);
                if (!(sac.getSpimSource().getType() instanceof ARGBType)) {
                    LUT lut;
                    ColorConverter converter;
                    if (sac.getConverter() instanceof ColorConverter) {
                        converter = (ColorConverter)sac.getConverter();
                        ARGBType c2 = converter.getColor();
                        lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)c2.get()), ARGBType.green((int)c2.get()), ARGBType.blue((int)c2.get())));
                    } else {
                        lut = LUT.createLutFromColor((Color)new Color(ARGBType.red((int)255), ARGBType.green((int)255), ARGBType.blue((int)255)));
                    }
                    luts[iC] = lut;
                    imp.setC(iC + 1);
                    imp.getProcessor().setLut(lut);
                    if (sac.getConverter() instanceof LinearRange) {
                        converter = (LinearRange)sac.getConverter();
                        imp.setDisplayRange(converter.getMin(), converter.getMax());
                    }
                }
                ++iC;
            }
            boolean oneIsNull = false;
            for (LUT lut : luts) {
                if (lut != null) continue;
                oneIsNull = true;
                break;
            }
            if (!oneIsNull && imp instanceof CompositeImage) {
                ((CompositeImage)imp).setLuts(luts);
            }
        }
        AffineTransform3D at3D = new AffineTransform3D();
        int timepointbegin = 0;
        sources.get(0).getSpimSource().getSourceTransform(timepointbegin, resolutionLevel, at3D);
        String unit = "px";
        if (sources.get(0).getSpimSource().getVoxelDimensions() != null && (unit = sources.get(0).getSpimSource().getVoxelDimensions().unit()) == null) {
            unit = "px";
        }
        ImagePlusHelper.storeExtendedCalibrationToImagePlus((ImagePlus)imp, (AffineTransform3D)at3D, (String)unit, (int)timepointbegin);
        if (task != null) {
            task.run(() -> {});
        }
        return imp;
    }

    public static CZTRange fromSource(SourceAndConverter<?> source, int t, int resolutionLevel) throws Exception {
        int maxTimeFrames = SourceAndConverterHelper.getMaxTimepoint(source);
        int maxZSlices = (int)source.getSpimSource().getSource(t, resolutionLevel).dimension(2);
        return new CZTRange.Builder().get(1, maxZSlices, maxTimeFrames);
    }

    public static CZTRange fromSources(List<SourceAndConverter<?>> sources, int t, int resolutionLevel) throws Exception {
        int maxTimeFrames = SourceAndConverterHelper.getMaxTimepoint(sources.get(0));
        int maxZSlices = (int)sources.get(0).getSpimSource().getSource(t, resolutionLevel).dimension(2);
        return new CZTRange.Builder().get(sources.size(), maxZSlices, maxTimeFrames);
    }

    public static <T extends NumericType<T> & NativeType<T>> List<SourceAndConverter<T>> sanitizeList(List<SourceAndConverter<?>> sources) {
        ArrayList<SourceAndConverter<T>> sanitizedList = new ArrayList<SourceAndConverter<T>>();
        for (SourceAndConverter<?> source : sources) {
            sanitizedList.add(source);
        }
        return sanitizedList;
    }
}

