/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter;

import bdv.BigDataViewer;
import bdv.cache.SharedQueue;
import bdv.util.WrapVolatileSource;
import bdv.util.source.process.VoxelProcessedSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.LoadedCellCacheLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.LinearRange;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.type.PrimitiveType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import sc.fiji.bdvpg.cache.GlobalLoaderCache;

public class SourceVoxelProcessor<I extends NumericType<I>, O extends NumericType<O>>
implements Runnable,
Function<SourceAndConverter<I>, SourceAndConverter<O>> {
    final VoxelProcessedSource.Processor processor;
    final SourceAndConverter<I> source_in;
    final String name;
    final O pixel;
    private final SharedQueue queue;

    public SourceVoxelProcessor(String name, SourceAndConverter<I> source_in, VoxelProcessedSource.Processor processor, O pixel, int nThreads) {
        this.processor = processor;
        this.source_in = source_in;
        this.name = name;
        this.pixel = pixel;
        this.queue = new SharedQueue(nThreads, source_in.getSpimSource().getNumMipmapLevels());
    }

    public SourceVoxelProcessor(String name, SourceAndConverter<I> source_in, VoxelProcessedSource.Processor processor, O pixel, SharedQueue queue) {
        this.processor = processor;
        this.source_in = source_in;
        this.name = name;
        this.pixel = pixel;
        this.queue = queue;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter<O> get() {
        return this.apply(this.source_in);
    }

    @Override
    public SourceAndConverter<O> apply(SourceAndConverter<I> sac) {
        VoxelProcessedSource srcProcessed = new VoxelProcessedSource(this.name, sac.getSpimSource(), this.processor, this.pixel);
        WrapVolatileSource vsrcRsampled = new WrapVolatileSource(srcProcessed, this.queue);
        Converter volatileConverter = BigDataViewer.createConverterToARGB((NumericType)((NumericType)vsrcRsampled.getType()));
        Converter converter = BigDataViewer.createConverterToARGB((NumericType)((NumericType)srcProcessed.getType()));
        if (sac.getConverter() instanceof ColorConverter && volatileConverter instanceof ColorConverter) {
            ((ColorConverter)volatileConverter).setColor(((ColorConverter)sac.getConverter()).getColor().copy());
        }
        if (sac.getConverter() instanceof ColorConverter && converter instanceof ColorConverter) {
            ((ColorConverter)converter).setColor(((ColorConverter)sac.getConverter()).getColor().copy());
        }
        if (sac.getConverter() instanceof LinearRange && volatileConverter instanceof LinearRange) {
            ((LinearRange)volatileConverter).setMin(((LinearRange)sac.getConverter()).getMin());
            ((LinearRange)volatileConverter).setMax(((LinearRange)sac.getConverter()).getMax());
        }
        if (sac.getConverter() instanceof LinearRange && converter instanceof LinearRange) {
            ((LinearRange)converter).setMin(((LinearRange)sac.getConverter()).getMin());
            ((LinearRange)converter).setMax(((LinearRange)sac.getConverter()).getMax());
        }
        SourceAndConverter vsac = new SourceAndConverter((Source)vsrcRsampled, volatileConverter);
        SourceAndConverter sac_out = new SourceAndConverter(srcProcessed, converter, vsac);
        return sac_out;
    }

    public static <T extends NumericType<T>> SourceAndConverter<UnsignedByteType> getBorders(SourceAndConverter<T> source) {
        VoxelProcessedSource.Processor borderMaker = new VoxelProcessedSource.Processor<T, UnsignedByteType>(){
            ConcurrentHashMap<Integer, ConcurrentHashMap<Integer, RandomAccessibleInterval<UnsignedByteType>>> cachedRAIs = new ConcurrentHashMap();

            RandomAccessibleInterval<UnsignedByteType> buildSource(RandomAccessibleInterval<T> rai, int t, int level) {
                int[] cellDimensions = new int[]{32, 32, 32};
                IntervalView lblImgWithBorder = Views.expandBorder(rai, (long[])new long[]{1L, 1L, 1L});
                IntervalView lblImgXShift = Views.translate((RandomAccessibleInterval)lblImgWithBorder, (long[])new long[]{1L, 0L, 0L});
                IntervalView lblImgYShift = Views.translate((RandomAccessibleInterval)lblImgWithBorder, (long[])new long[]{0L, 1L, 0L});
                IntervalView lblImgZShift = Views.translate((RandomAccessibleInterval)lblImgWithBorder, (long[])new long[]{0L, 0L, 1L});
                CellGrid grid = new CellGrid(rai.dimensionsAsLongArray(), cellDimensions);
                UnsignedByteType type = new UnsignedByteType();
                Cache cache = new GlobalLoaderCache(new Object(), t, level).withLoader((CacheLoader)LoadedCellCacheLoader.get((CellGrid)grid, arg_0 -> 1.lambda$buildSource$0(rai, (RandomAccessibleInterval)lblImgXShift, (RandomAccessibleInterval)lblImgYShift, (RandomAccessibleInterval)lblImgZShift, arg_0), (NativeType)type, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
                CachedCellImg img = new CachedCellImg(grid, (NativeType)type, cache, (DataAccess)ArrayDataAccessFactory.get((PrimitiveType)PrimitiveType.BYTE, (Set)AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE)));
                return img;
            }

            @Override
            public synchronized RandomAccessibleInterval<UnsignedByteType> process(RandomAccessibleInterval<T> rai, int t, int level) {
                if (!this.cachedRAIs.containsKey(t)) {
                    this.cachedRAIs.put(t, new ConcurrentHashMap());
                }
                if (!this.cachedRAIs.get(t).containsKey(level)) {
                    this.cachedRAIs.get(t).put(level, this.buildSource(rai, t, level));
                }
                return this.cachedRAIs.get(t).get(level);
            }

            private static /* synthetic */ void lambda$buildSource$0(RandomAccessibleInterval rai, RandomAccessibleInterval lblImgXShift, RandomAccessibleInterval lblImgYShift, RandomAccessibleInterval lblImgZShift, SingleCellArrayImg cell) throws Exception {
                Cursor inNS = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)rai, (Interval)cell)).cursor();
                Cursor inXS = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)lblImgXShift, (Interval)cell)).cursor();
                Cursor inYS = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)lblImgYShift, (Interval)cell)).cursor();
                Cursor inZS = Views.flatIterable((RandomAccessibleInterval)Views.interval((RandomAccessible)lblImgZShift, (Interval)cell)).cursor();
                Cursor out = Views.flatIterable((RandomAccessibleInterval)cell).cursor();
                while (out.hasNext()) {
                    NumericType v = (NumericType)inNS.next();
                    if (!v.equals(inXS.next())) {
                        ((UnsignedByteType)out.next()).set(126);
                        inYS.next();
                        inZS.next();
                        continue;
                    }
                    if (!v.equals(inYS.next())) {
                        ((UnsignedByteType)out.next()).set(126);
                        inZS.next();
                        continue;
                    }
                    if (!v.equals(inZS.next())) {
                        ((UnsignedByteType)out.next()).set(126);
                        continue;
                    }
                    out.next();
                }
            }
        };
        return new SourceVoxelProcessor<T, UnsignedByteType>("Borders_" + source.getSpimSource().getName(), source, borderMaker, new UnsignedByteType(), Runtime.getRuntime().availableProcessors() - 1).get();
    }
}

