/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter;

import bdv.BigDataViewer;
import bdv.cache.SharedQueue;
import bdv.util.EmptySource;
import bdv.util.ResampledSource;
import bdv.util.WrapVolatileSource;
import bdv.util.source.process.LazyDownscaledXY2Source;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.EmptyMultiResolutionSourceAndConverterCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.FinalRealInterval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.converter.Converter;
import net.imglib2.display.ColorConverter;
import net.imglib2.display.LinearRange;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.LinAlgHelpers;

public class SourceHelper {
    public static <T> Source<T> AlignAxisResample(Source<T> src, RealPoint pA, RealPoint pB, double voxSize, int nPixX, int nPixY, int nPixZ, boolean alignX, boolean sourceInterpolate) {
        AffineTransform3D rot = SourceHelper.getRotationMatrixAlignZ(pA, pB, alignX);
        double cx = (pA.getDoublePosition(0) + pB.getDoublePosition(0)) / 2.0;
        double cy = (pA.getDoublePosition(1) + pB.getDoublePosition(1)) / 2.0;
        double cz = (pA.getDoublePosition(2) + pB.getDoublePosition(2)) / 2.0;
        RealPoint center = new RealPoint(3);
        center.setPosition(new double[]{cx, cy, cz});
        AffineTransform3D translateCenterBwd = new AffineTransform3D();
        translateCenterBwd.translate(new double[]{(double)(-nPixX) / 2.0, (double)(-nPixY) / 2.0, (double)(-nPixZ) / 2.0});
        AffineTransform3D translateCenterFwd = new AffineTransform3D();
        translateCenterFwd.translate(new double[]{-cx, -cy, -cz});
        AffineTransform3D scaler = new AffineTransform3D();
        scaler.scale(voxSize, voxSize, voxSize);
        AffineTransform3D m = new AffineTransform3D();
        m.concatenate(translateCenterFwd.inverse());
        m.concatenate(rot);
        m.concatenate(scaler);
        m.concatenate(translateCenterBwd);
        EmptySource model = new EmptySource((long)nPixX, (long)nPixY, (long)nPixZ, m, src.getName() + "_ZAlignedModel", (VoxelDimensions)new FinalVoxelDimensions(src.getVoxelDimensions().unit(), new double[]{voxSize, voxSize, voxSize}));
        ResampledSource resampled_src = new ResampledSource(src, (Source)model, src.getName() + "_SampledLike_" + model.getName(), false, true, sourceInterpolate, 0);
        return resampled_src;
    }

    public static AffineTransform3D getRotationMatrixAlignZ(RealPoint pt1, RealPoint pt2, boolean alignX) {
        double v1x = pt2.getDoublePosition(0) - pt1.getDoublePosition(0);
        double v1y = pt2.getDoublePosition(1) - pt1.getDoublePosition(1);
        double v1z = pt2.getDoublePosition(2) - pt1.getDoublePosition(2);
        double normv1 = Math.sqrt(v1x * v1x + v1y * v1y + v1z * v1z);
        double v2x = 0.0;
        double v2y = 0.0;
        double v2z = 1.0;
        double normv2 = Math.sqrt(v2x * v2x + v2y * v2y + v2z * v2z);
        double[] q1 = new double[]{1.0 + (v2x /= normv2) * v1x + (v2y /= normv2) * v1y + (v2z /= normv2) * (v1z /= normv1), v2y * v1z - v2z * (v1y /= normv1), v2z * (v1x /= normv1) - v2x * v1z, v2x * v1y - v2y * v1x};
        double normq1 = Math.sqrt(q1[0] * q1[0] + q1[1] * q1[1] + q1[2] * q1[2] + q1[3] * q1[3]);
        q1[0] = q1[0] / normq1;
        q1[1] = q1[1] / normq1;
        q1[2] = q1[2] / normq1;
        q1[3] = q1[3] / normq1;
        double[][] m = new double[3][3];
        AffineTransform3D rotMatrix = new AffineTransform3D();
        if (alignX) {
            double[] q2 = new double[4];
            double alpha = (Math.atan2(v1y, v1x) + 1.5707963267948966) / 2.0;
            q2[0] = Math.cos(alpha);
            q2[3] = Math.sin(alpha);
            double[] q1q2 = new double[4];
            LinAlgHelpers.quaternionMultiply((double[])q1, (double[])q2, (double[])q1q2);
            LinAlgHelpers.quaternionToR((double[])q1q2, (double[][])m);
        } else {
            LinAlgHelpers.quaternionToR((double[])q1, (double[][])m);
        }
        rotMatrix.set(m[0][0], m[0][1], m[0][2], 0.0, m[1][0], m[1][1], m[1][2], 0.0, m[2][0], m[2][1], m[2][2], 0.0);
        return rotMatrix;
    }

    public static SourceAndConverter<?> getModelFusedMultiSources(SourceAndConverter<?>[] sources, int timepoint, int nTimepoints, double pixSizeX, double pixSizeY, double pixSizeZ, int nResolutionLevels, int downscaleX, int downscaleY, int downscaleZ, String model_name) {
        List intervalList = Arrays.stream(sources).filter(sourceAndConverter -> sourceAndConverter.getSpimSource() != null).filter(sourceAndConverter -> sourceAndConverter.getSpimSource().isPresent(timepoint)).map(sourceAndConverter -> {
            RandomAccessibleInterval interval = sourceAndConverter.getSpimSource().getSource(timepoint, 0);
            AffineTransform3D sourceTransform = new AffineTransform3D();
            ArrayList<RealPoint> corners = new ArrayList<RealPoint>();
            sourceAndConverter.getSpimSource().getSourceTransform(timepoint, 0, sourceTransform);
            corners.add(new RealPoint(new float[]{interval.min(0), interval.min(1), interval.min(2)}));
            corners.add(new RealPoint(new float[]{interval.min(0), interval.min(1), interval.max(2) + 1L}));
            corners.add(new RealPoint(new float[]{interval.min(0), interval.max(1) + 1L, interval.min(2)}));
            corners.add(new RealPoint(new float[]{interval.min(0), interval.max(1) + 1L, interval.max(2) + 1L}));
            corners.add(new RealPoint(new float[]{interval.max(0) + 1L, interval.min(1), interval.min(2)}));
            corners.add(new RealPoint(new float[]{interval.max(0) + 1L, interval.min(1), interval.max(2) + 1L}));
            corners.add(new RealPoint(new float[]{interval.max(0) + 1L, interval.max(1) + 1L, interval.min(2)}));
            corners.add(new RealPoint(new float[]{interval.max(0) + 1L, interval.max(1) + 1L, interval.max(2) + 1L}));
            corners.forEach(pt -> sourceTransform.apply((RealLocalizable)pt, (RealPositionable)pt));
            double minX = corners.stream().mapToDouble(pt -> pt.getDoublePosition(0)).min().getAsDouble();
            double minY = corners.stream().mapToDouble(pt -> pt.getDoublePosition(1)).min().getAsDouble();
            double minZ = corners.stream().mapToDouble(pt -> pt.getDoublePosition(2)).min().getAsDouble();
            double maxX = corners.stream().mapToDouble(pt -> pt.getDoublePosition(0)).max().getAsDouble();
            double maxY = corners.stream().mapToDouble(pt -> pt.getDoublePosition(1)).max().getAsDouble();
            double maxZ = corners.stream().mapToDouble(pt -> pt.getDoublePosition(2)).max().getAsDouble();
            return new FinalRealInterval(new double[]{minX, minY, minZ}, new double[]{maxX, maxY, maxZ});
        }).collect(Collectors.toList());
        RealInterval maxInterval = (RealInterval)intervalList.stream().reduce((i1, i2) -> new FinalRealInterval(new double[]{Math.min(i1.realMin(0), i2.realMin(0)), Math.min(i1.realMin(1), i2.realMin(1)), Math.min(i1.realMin(2), i2.realMin(2))}, new double[]{Math.max(i1.realMax(0), i2.realMax(0)), Math.max(i1.realMax(1), i2.realMax(1)), Math.max(i1.realMax(2), i2.realMax(2))})).get();
        FinalRealInterval imageInterval = new FinalRealInterval(new double[]{maxInterval.realMin(0), maxInterval.realMin(1), maxInterval.realMin(2)}, new double[]{maxInterval.realMax(0), maxInterval.realMax(1), maxInterval.realMax(2)});
        double sizeX = imageInterval.realMax(0) - imageInterval.realMin(0);
        double sizeY = imageInterval.realMax(1) - imageInterval.realMin(1);
        double sizeZ = imageInterval.realMax(2) - imageInterval.realMin(2);
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.scale(pixSizeX, pixSizeY, pixSizeZ);
        at3D.translate(new double[]{imageInterval.realMin(0), imageInterval.realMin(1), imageInterval.realMin(2)});
        long nPx = (long)Math.ceil(sizeX / pixSizeX);
        long nPy = (long)Math.ceil(sizeY / pixSizeY);
        long nPz = (long)Math.ceil(sizeZ / pixSizeZ);
        return new EmptyMultiResolutionSourceAndConverterCreator(model_name, at3D, nPx, nPy, nPz, nTimepoints, downscaleX, downscaleY, downscaleZ, nResolutionLevels).get();
    }

    public static <T extends RealType<T> & NativeType<T>> SourceAndConverter<T> lazyPyramidizeXY2(SourceAndConverter<T> sac) {
        return SourceHelper.lazyPyramidizeXY2(sac, new SharedQueue(Runtime.getRuntime().availableProcessors() - 1, 5));
    }

    public static <T extends RealType<T> & NativeType<T>> SourceAndConverter<T> lazyPyramidizeXY2(SourceAndConverter<T> sac, SharedQueue queue) {
        LazyDownscaledXY2Source srcLazyDownscaled = new LazyDownscaledXY2Source(sac.getSpimSource().getName() + "_pyramid", sac.getSpimSource());
        WrapVolatileSource vsrcRsampled = new WrapVolatileSource(srcLazyDownscaled, queue);
        if (sac.asVolatile() == null) {
            throw new UnsupportedOperationException("Can't lazy downscale non cached source");
        }
        vsrcRsampled.setVolatileSourceForHighestResolution(sac.asVolatile().getSpimSource());
        Converter volatileConverter = BigDataViewer.createConverterToARGB((NumericType)((NumericType)vsrcRsampled.getType()));
        Converter converter = BigDataViewer.createConverterToARGB((NumericType)((NumericType)srcLazyDownscaled.getType()));
        if (sac.getConverter() instanceof ColorConverter && volatileConverter instanceof ColorConverter) {
            ((ColorConverter)volatileConverter).setColor(((ColorConverter)sac.getConverter()).getColor().copy());
        }
        if (sac.getConverter() instanceof ColorConverter && converter instanceof ColorConverter) {
            ((ColorConverter)converter).setColor(((ColorConverter)sac.getConverter()).getColor().copy());
        }
        if (sac.getConverter() instanceof LinearRange && volatileConverter instanceof LinearRange) {
            ((LinearRange)volatileConverter).setMin(((LinearRange)sac.getConverter()).getMin());
            ((LinearRange)volatileConverter).setMax(((LinearRange)sac.getConverter()).getMax());
        }
        if (sac.getConverter() instanceof LinearRange && converter instanceof LinearRange) {
            ((LinearRange)converter).setMin(((LinearRange)sac.getConverter()).getMin());
            ((LinearRange)converter).setMax(((LinearRange)sac.getConverter()).getMax());
        }
        SourceAndConverter vsac = new SourceAndConverter((Source)vsrcRsampled, volatileConverter);
        SourceAndConverter sac_out = new SourceAndConverter(srcLazyDownscaled, converter, vsac);
        return sac_out;
    }
}

