/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.sourceandconverter;

import bdv.cache.SharedQueue;
import bdv.util.WrapVolatileSource;
import bdv.util.source.fused.AlphaFusedResampledSource;
import bdv.viewer.Interpolation;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.imglib2.converter.Converter;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

public class SourceFuserAndResampler<T extends NumericType<T>>
implements Runnable,
Function<List<SourceAndConverter<T>>, SourceAndConverter<T>> {
    List<SourceAndConverter<T>> sacs_in;
    SourceAndConverter model;
    boolean reuseMipMaps;
    boolean interpolate;
    boolean cache;
    int cacheX;
    int cacheY;
    int cacheZ;
    int defaultMipMapLevel;
    private String name;
    String blendingMode;
    private int nThreads;

    public SourceFuserAndResampler(List<SourceAndConverter<T>> sacs_in, String blendingMode, SourceAndConverter model, String name, boolean reuseMipmaps, boolean cache, boolean interpolate, int defaultMipMapLevel, int cacheX, int cacheY, int cacheZ, int cacheBounds, int nThreads) {
        this.nThreads = nThreads;
        this.blendingMode = blendingMode;
        this.name = name;
        this.reuseMipMaps = reuseMipmaps;
        this.model = model;
        this.sacs_in = sacs_in;
        this.interpolate = interpolate;
        this.cache = cache;
        this.defaultMipMapLevel = defaultMipMapLevel;
        this.cacheX = cacheX;
        this.cacheY = cacheY;
        this.cacheZ = cacheZ;
    }

    @Override
    public void run() {
    }

    public SourceAndConverter<T> get() {
        return this.apply(this.sacs_in);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SourceAndConverter<T> apply(List<SourceAndConverter<T>> srcs) {
        void var7_10;
        SourceAndConverter<T> sacExample = srcs.get(0);
        ArrayList<Object> sources = new ArrayList();
        HashMap<Object, Object> interpolationMap = new HashMap();
        boolean volatileIsPossible = true;
        for (SourceAndConverter<T> sourceAndConverter : srcs) {
            sources.add(sourceAndConverter.getSpimSource());
            volatileIsPossible = volatileIsPossible && sourceAndConverter.asVolatile() != null;
            interpolationMap.put(sourceAndConverter.getSpimSource(), this.interpolate ? Interpolation.NLINEAR : Interpolation.NEARESTNEIGHBOR);
        }
        AlphaFusedResampledSource srcRsampled = new AlphaFusedResampledSource(sources, this.blendingMode, this.model.getSpimSource(), this.name, this.reuseMipMaps, this.cache, interpolationMap, this.defaultMipMapLevel, this.cacheX, this.cacheY, this.cacheZ);
        if (volatileIsPossible) {
            Object vsrcRsampled;
            if (this.cache) {
                vsrcRsampled = new WrapVolatileSource(srcRsampled, new SharedQueue(this.nThreads));
            } else {
                sources = new ArrayList();
                interpolationMap = new HashMap();
                for (SourceAndConverter<T> sac_in : srcs) {
                    sources.add(sac_in.asVolatile().getSpimSource());
                    interpolationMap.put(sac_in.asVolatile().getSpimSource(), this.interpolate ? Interpolation.NLINEAR : Interpolation.NEARESTNEIGHBOR);
                }
                vsrcRsampled = new AlphaFusedResampledSource(sources, this.blendingMode, this.model.getSpimSource(), this.name, this.reuseMipMaps, false, interpolationMap, this.defaultMipMapLevel, this.cacheX, this.cacheY, this.cacheZ);
            }
            SourceAndConverter vsac = new SourceAndConverter((Source)vsrcRsampled, SourceAndConverterHelper.cloneConverter((Converter)sacExample.asVolatile().getConverter(), (SourceAndConverter)sacExample.asVolatile()));
            SourceAndConverter sourceAndConverter = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)sacExample.getConverter(), sacExample), vsac);
        } else {
            SourceAndConverter sourceAndConverter = new SourceAndConverter(srcRsampled, SourceAndConverterHelper.cloneConverter((Converter)sacExample.getConverter(), sacExample));
        }
        return var7_10;
    }
}

