/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.ui.swing;

import bdv.util.Elliptical3DTransform;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.viewer.EasySwingDisplayViewer;
import org.scijava.ui.viewer.DisplayViewer;

@Plugin(type=DisplayViewer.class)
public class SwingElliptical3DTransformViewer
extends EasySwingDisplayViewer<Elliptical3DTransform> {
    Elliptical3DTransform e3Dt;
    JPanel panelInfo;
    JLabel nameLabel;
    JTextArea textInfo;
    Map<String, Double> paramsTransfo;
    Map<String, DoubleValueSwingSetLog> paramsUI;

    public SwingElliptical3DTransformViewer() {
        super(Elliptical3DTransform.class);
    }

    protected boolean canView(Elliptical3DTransform elliptical3DTransform) {
        return true;
    }

    protected void redoLayout() {
    }

    protected void setLabel(String s) {
    }

    protected void redraw() {
        Map<String, Double> params = this.e3Dt.getParameters();
        this.paramsUI.keySet().forEach(k -> this.paramsUI.get(k).setValue((Double)params.get(k)));
    }

    protected JPanel createDisplayPanel(Elliptical3DTransform elliptical3DTransform) {
        this.e3Dt = elliptical3DTransform;
        this.paramsTransfo = this.e3Dt.getParameters();
        this.paramsUI = new LinkedHashMap<String, DoubleValueSwingSetLog>();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.panelInfo = new JPanel();
        this.panelInfo.setLayout(new GridLayout(9, 1));
        panel.add((Component)this.panelInfo, "Center");
        this.nameLabel = new JLabel("Elliptical transform name");
        JTextField nameField = new JTextField();
        JPanel paneName = new JPanel();
        paneName.setLayout(new GridLayout(1, 2));
        paneName.add(this.nameLabel);
        paneName.add(nameField);
        nameField.setEditable(true);
        nameField.setText(this.e3Dt.getName());
        nameField.addActionListener(e -> this.e3Dt.setName(nameField.getText()));
        panel.add((Component)paneName, "North");
        this.textInfo = new JTextArea();
        this.textInfo.setEditable(false);
        this.paramsTransfo.keySet().forEach(k -> {
            this.paramsUI.put((String)k, new DoubleValueSwingSetLog((String)k, this.paramsTransfo.get(k), v -> this.e3Dt.setParameters(k, v)));
            this.panelInfo.add(this.paramsUI.get(k).getPanel());
        });
        panel.setPreferredSize(new Dimension(500, 500));
        this.redraw();
        return panel;
    }

    static class DoubleValueSwingSetLog {
        JSlider sliderLog;
        JTextField valueTF;
        JLabel labelName;
        JPanel pane;
        Double value;
        Double valueOld;
        Consumer<Double> vChanged;

        public DoubleValueSwingSetLog(String name, Double v, Consumer<Double> valueChanged) {
            this.vChanged = valueChanged;
            this.sliderLog = new JSlider();
            this.valueOld = 0.0;
            this.valueOld = v;
            this.sliderLog.setMinimum(-100);
            this.sliderLog.setMaximum(100);
            this.sliderLog.setValue(0);
            this.sliderLog.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent event) {
                    if (!sliderLog.getValueIsAdjusting()) {
                        sliderLog.setValue(0);
                        valueOld = value;
                    } else {
                        this.setValue(valueOld * Math.pow(10.0, (double)sliderLog.getValue() / 100.0));
                    }
                }
            });
            this.valueTF = new JTextField();
            this.valueTF.addActionListener(e -> {
                try {
                    Double d = Double.valueOf(this.valueTF.getText());
                    this.setValue(d);
                    this.valueOld = d;
                }
                catch (Exception exception) {
                    this.valueTF.setText(Double.toString(this.valueOld));
                }
            });
            this.labelName = new JLabel();
            this.labelName.setText(name);
            this.value = v;
            this.setValue(this.value);
            this.pane = new JPanel();
            this.pane.setLayout(new GridLayout(1, 3));
            this.pane.add(this.labelName);
            this.pane.add(this.valueTF);
            this.pane.add(this.sliderLog);
        }

        void setValue(Double v) {
            this.value = v;
            this.valueTF.setText(Double.toString(v));
            this.vChanged.accept(v);
        }

        public JPanel getPanel() {
            return this.pane;
        }
    }
}

