/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.processors;

import org.scijava.ItemVisibility;
import org.scijava.log.LogService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.widget.Button;

@Plugin(type=PreprocessorPlugin.class, priority=-9999.0)
public class MessageResolverProcessor
extends AbstractPreprocessorPlugin {
    int unresolvedInputsExceptMessageCount = 0;
    int messagesCount = 0;
    int buttonCount = 0;
    @Parameter
    LogService logger;

    public void process(Module module) {
        if (module.getInfo() == null) {
            this.logger.warn((Object)("null getInfo for module " + module));
            return;
        }
        module.getInputs().forEach((name, input) -> {
            ModuleItem inputKind = module.getInfo().getInput(name);
            if (inputKind == null) {
                this.logger.warn((Object)("null input " + name + " for module " + module));
                return;
            }
            ItemVisibility visibility = inputKind.getVisibility();
            if (visibility == null) {
                this.logger.warn((Object)("null visibility for input " + name + " for module " + module));
                return;
            }
            if (visibility.equals((Object)ItemVisibility.MESSAGE)) {
                ++this.messagesCount;
            } else if (!module.isInputResolved(name)) {
                ++this.unresolvedInputsExceptMessageCount;
            }
        });
        module.getInputs().forEach((name, input) -> {
            ModuleItem inputKind = module.getInfo().getInput(name);
            if (inputKind == null) {
                this.logger.warn((Object)("null input " + name + " for module " + module));
                return;
            }
            if (inputKind.getType().equals(Button.class)) {
                ++this.buttonCount;
            }
        });
        if (this.messagesCount > 0 && (this.unresolvedInputsExceptMessageCount == 0 || this.unresolvedInputsExceptMessageCount == this.buttonCount)) {
            module.getInputs().forEach((name, input) -> {
                if (module.getInfo().getInput(name).getVisibility().equals((Object)ItemVisibility.MESSAGE) || module.getInfo().getInput(name).getType().equals(Button.class)) {
                    this.logger.debug((Object)("Resolving parameter " + name + " in module " + module + " in MessageResolverProcessor."));
                    module.resolveInput(name);
                }
            });
        }
    }
}

