/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.viewer.SourceAndConverter;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Recenter sources")
public class SourcesRecenterCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    int timepoint = 0;
    @Parameter(style="format:0.#####E0")
    double cx;
    @Parameter(style="format:0.#####E0")
    double cy;
    @Parameter(style="format:0.#####E0")
    double cz;
    @Parameter(label="Sources", type=ItemIO.BOTH)
    public SourceAndConverter[] sacs;
    @Parameter(choices={"Mutate", "Append"})
    String mode = "Mutate";

    public void run() {
        block8: for (SourceAndConverter sac : this.sacs) {
            long sx = sac.getSpimSource().getSource(this.timepoint, 0).dimension(0);
            long sy = sac.getSpimSource().getSource(this.timepoint, 0).dimension(1);
            AffineTransform3D at3D = new AffineTransform3D();
            sac.getSpimSource().getSourceTransform(this.timepoint, 0, at3D);
            AffineTransform3D at3DCenter = new AffineTransform3D();
            at3DCenter.concatenate(at3D.inverse());
            at3DCenter.translate(new double[]{-sx / 2L, -sy / 2L, 0.0});
            at3D.set(this.cx, 0, 3);
            at3D.set(this.cy, 1, 3);
            at3D.set(this.cz, 2, 3);
            at3DCenter.preConcatenate(at3D);
            switch (this.mode) {
                case "Mutate": {
                    SourceTransformHelper.mutate((AffineTransform3D)at3DCenter, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, this.timepoint));
                    continue block8;
                }
                case "Append": {
                    SourceTransformHelper.append((AffineTransform3D)at3DCenter, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, this.timepoint));
                }
            }
        }
        SourceAndConverterServices.getBdvDisplayService().updateDisplays(this.sacs);
    }
}

