/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.tools.transformation.TransformedSource;
import bdv.viewer.SourceAndConverter;
import ij.IJ;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.LinAlgHelpers;
import org.scijava.command.InteractiveCommand;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Rotation 3D Transform")
public class Rotation3DTransformCommand
extends InteractiveCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    SourceAndConverter[] sacs;
    @Parameter(style="slider,format:0.#####E0", min="0", max="360")
    int rx;
    @Parameter(style="slider,format:0.#####E0", min="0", max="360")
    int ry;
    @Parameter(style="slider,format:0.#####E0", min="0", max="360")
    double rz;
    @Parameter(style="format:0.#####E0")
    double cx;
    @Parameter(style="format:0.#####E0")
    double cy;
    @Parameter(style="format:0.#####E0")
    double cz;

    public Rotation3DTransformCommand() {
        super(new String[0]);
    }

    public void run() {
        double rxRad = Math.PI * (double)this.rx / 360.0;
        double ryRad = Math.PI * (double)this.ry / 360.0;
        double rzRad = Math.PI * this.rz / 360.0;
        double[] qx = new double[]{Math.cos(rxRad), Math.sin(rxRad), 0.0, 0.0};
        double[] qy = new double[]{Math.cos(ryRad), 0.0, Math.sin(ryRad), 0.0};
        double[] qz = new double[]{Math.cos(rzRad), 0.0, 0.0, Math.sin(rzRad)};
        double[] qXY = new double[4];
        LinAlgHelpers.quaternionMultiply((double[])qy, (double[])qx, (double[])qXY);
        double[] qRes = new double[4];
        LinAlgHelpers.quaternionMultiply((double[])qz, (double[])qXY, (double[])qRes);
        double[][] m = new double[3][3];
        AffineTransform3D rotMatrix = new AffineTransform3D();
        LinAlgHelpers.quaternionToR((double[])qRes, (double[][])m);
        rotMatrix.set(m[0][0], m[0][1], m[0][2], 0.0, m[1][0], m[1][1], m[1][2], 0.0, m[2][0], m[2][1], m[2][2], 0.0);
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.translate(new double[]{-this.cx, -this.cy, -this.cz});
        at3D.preConcatenate(rotMatrix);
        if (this.sacs != null) {
            for (SourceAndConverter sac : this.sacs) {
                if (sac == null) continue;
                if (sac.getSpimSource() instanceof TransformedSource) {
                    ((TransformedSource)sac.getSpimSource()).setFixedTransform(at3D);
                    SourceAndConverterServices.getBdvDisplayService().updateDisplays(new SourceAndConverter[]{sac});
                    continue;
                }
                IJ.log((String)"Can't rotate a non transformed source, please use  BigDataViewer-Playground \u203a Sources \u203a Transform \u203a Wrap as Transformed Source");
            }
        }
    }
}

