/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusHelper;
import ch.epfl.biop.bdv.img.imageplus.ImagePlusToSpimData;
import ij.ImagePlus;
import ij.gui.PointRoi;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.frame.RoiManager;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.LinAlgHelpers;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Image>Stacks>Rotation 3D Resample", description="Required : two point roi in the ROI Manager and an ImagePlus. This command reorients a 3D IJ1 image (ImagePlus) by creating another IJ1 image wherethe two points Roi are aligned in Z. Hyperstakcs are supporteda and metadata (original pixel size)matters.")
public class Rot3DReSampleCommand<T extends NumericType<T> & NativeType<T>>
implements BdvPlaygroundActionCommand {
    @Parameter
    ImagePlus imp_in;
    @Parameter
    RoiManager rm;
    @Parameter(label="Final Image Size X (physical unit)", style="format:0.#####E0")
    double radiusx;
    @Parameter(label="Final Image Size Y (physical unit)", style="format:0.#####E0")
    double radiusy;
    @Parameter(label="Final Image Size Z (physical unit)", style="format:0.#####E0")
    double radiusz;
    @Parameter(label="Final Voxel Size X (physical unit)", style="format:0.#####E0")
    double voxfx;
    @Parameter(label="Final Voxel Size Y (physical unit)", style="format:0.#####E0")
    double voxfy;
    @Parameter(label="Final Voxel Size Z (physical unit)", style="format:0.#####E0")
    double voxfz;
    @Parameter(label="Align X axis (default true)")
    boolean align_x = true;
    @Parameter(type=ItemIO.OUTPUT)
    ImagePlus imp_out;
    @Parameter(label="Interpolate pixel values during resampling.")
    boolean interpolate;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        AbstractSpimData asd = ImagePlusToSpimData.getSpimData((ImagePlus)this.imp_in);
        this.sac_service.register(asd);
        this.sac_service.setSpimDataName(asd, this.imp_in.getTitle());
        List sacs = SourceAndConverterServices.getSourceAndConverterService().getSourceAndConverterFromSpimdata(asd);
        if (this.rm.getCount() < 2) {
            System.err.println("Error : 2 point Rois should be present in the Roi Manager to reorient a stack");
            return;
        }
        if (this.rm.getCount() > 2) {
            System.out.println("Ignoring rois with index > 1");
        }
        Roi roi1 = this.rm.getRoi(0);
        Roi roi2 = this.rm.getRoi(1);
        if (!(roi1 instanceof PointRoi)) {
            System.err.println("First Roi is not a point!");
            return;
        }
        if (!(roi2 instanceof PointRoi)) {
            System.err.println("Second Roi is not a point!");
            return;
        }
        PointRoi pt1 = (PointRoi)roi1;
        PointRoi pt2 = (PointRoi)roi2;
        double voxIX = this.imp_in.getCalibration().pixelWidth;
        double voxIY = this.imp_in.getCalibration().pixelHeight;
        double voxIZ = this.imp_in.getCalibration().pixelDepth;
        double v1x = (pt2.getXBase() - pt1.getXBase()) * voxIX;
        double v1y = (pt2.getYBase() - pt1.getYBase()) * voxIY;
        double v1z = (double)(pt2.getZPosition() - pt1.getZPosition()) * voxIZ;
        double normv1 = Math.sqrt(v1x * v1x + v1y * v1y + v1z * v1z);
        double v2x = 0.0;
        double v2y = 0.0;
        double v2z = 1.0;
        double normv2 = Math.sqrt(v2x * v2x + v2y * v2y + v2z * v2z);
        double[] q1 = new double[]{1.0 + (v2x /= normv2) * v1x + (v2y /= normv2) * v1y + (v2z /= normv2) * (v1z /= normv1), v2y * v1z - v2z * (v1y /= normv1), v2z * (v1x /= normv1) - v2x * v1z, v2x * v1y - v2y * v1x};
        double normq1 = Math.sqrt(q1[0] * q1[0] + q1[1] * q1[1] + q1[2] * q1[2] + q1[3] * q1[3]);
        q1[0] = q1[0] / normq1;
        q1[1] = q1[1] / normq1;
        q1[2] = q1[2] / normq1;
        q1[3] = q1[3] / normq1;
        double[][] m = new double[3][3];
        AffineTransform3D rotMatrix = new AffineTransform3D();
        if (this.align_x) {
            double[] q2 = new double[4];
            double alpha = (Math.atan2(v1y, v1x) + 1.5707963267948966) / 2.0;
            q2[0] = Math.cos(alpha);
            q2[3] = Math.sin(alpha);
            double[] q1q2 = new double[4];
            LinAlgHelpers.quaternionMultiply((double[])q1, (double[])q2, (double[])q1q2);
            LinAlgHelpers.quaternionToR((double[])q1q2, (double[][])m);
        } else {
            LinAlgHelpers.quaternionToR((double[])q1, (double[][])m);
        }
        rotMatrix.set(m[0][0], m[0][1], m[0][2], 0.0, m[1][0], m[1][1], m[1][2], 0.0, m[2][0], m[2][1], m[2][2], 0.0);
        double cx = (pt1.getXBase() + pt2.getXBase()) / 2.0 * voxIX;
        double cy = (pt1.getYBase() + pt2.getYBase()) / 2.0 * voxIY;
        double cz = (double)(pt1.getZPosition() + pt2.getZPosition()) / 2.0 * voxIZ;
        double nx = 2.0 * (this.radiusx / this.voxfx);
        double ny = 2.0 * (this.radiusy / this.voxfy);
        double nz = 2.0 * (this.radiusz / this.voxfz);
        AffineTransform3D translateCenterBwd = new AffineTransform3D();
        translateCenterBwd.translate(new double[]{-nx / 2.0, -ny / 2.0, -nz / 2.0});
        AffineTransform3D translateCenterFwd = new AffineTransform3D();
        translateCenterFwd.translate(new double[]{-cx, -cy, -cz});
        AffineTransform3D scaler = new AffineTransform3D();
        scaler.scale(this.voxfx, this.voxfy, this.voxfz);
        AffineTransform3D at3D = new AffineTransform3D();
        at3D.concatenate(translateCenterFwd.inverse());
        at3D.concatenate(rotMatrix);
        at3D.concatenate(scaler);
        at3D.concatenate(translateCenterBwd);
        SourceAndConverter model = new EmptySourceAndConverterCreator("dummy", at3D, (long)nx, (long)ny, (long)nz).get();
        if (model == null) {
            System.out.println("model is null");
        }
        SourceResampler sampler = new SourceResampler(null, model, "Sampler", false, false, this.interpolate, 0);
        List<SourceAndConverter> reoriented_sources = sacs.stream().map(source -> sampler.apply(source)).collect(Collectors.toList());
        HashMap mapMipmap = new HashMap();
        reoriented_sources.forEach(sac -> mapMipmap.put(sac, 0));
        this.imp_out = ImagePlusHelper.wrap(reoriented_sources, mapMipmap, (int)0, (int)this.imp_in.getNFrames(), (int)1);
        this.imp_out.setTitle("Reoriented_" + this.imp_in.getTitle());
        Calibration calibration = new Calibration();
        calibration.setImage(this.imp_out);
        calibration.xOrigin = cx;
        calibration.yOrigin = cy;
        calibration.zOrigin = cz;
        calibration.pixelWidth = this.voxfx;
        calibration.pixelHeight = this.voxfy;
        calibration.pixelDepth = this.voxfz;
        calibration.setUnit(this.imp_in.getCalibration().getUnit());
        this.imp_out.setCalibration(calibration);
    }
}

