/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.viewer.SourceAndConverter;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Remove Z Offset")
public class RemoveZOffsetCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    int timepoint = 0;
    @Parameter(label="Sources", type=ItemIO.BOTH)
    public SourceAndConverter[] sacs;
    @Parameter(choices={"Mutate", "Append"})
    String mode = "Mutate";

    public void run() {
        block8: for (SourceAndConverter sac : this.sacs) {
            long sz = sac.getSpimSource().getSource(this.timepoint, 0).dimension(2);
            AffineTransform3D at3D = new AffineTransform3D();
            sac.getSpimSource().getSourceTransform(this.timepoint, 0, at3D);
            AffineTransform3D at3DCenter = new AffineTransform3D();
            at3DCenter.concatenate(at3D.inverse());
            at3DCenter.translate(new double[]{0.0, 0.0, (double)(-sz) / 2.0});
            at3D.set(0.0, 2, 3);
            at3DCenter.preConcatenate(at3D);
            switch (this.mode) {
                case "Mutate": {
                    SourceTransformHelper.mutate((AffineTransform3D)at3DCenter, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, this.timepoint));
                    continue block8;
                }
                case "Append": {
                    SourceTransformHelper.append((AffineTransform3D)at3DCenter, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(sac, this.timepoint));
                }
            }
        }
        SourceAndConverterServices.getBdvDisplayService().updateDisplays(this.sacs);
    }
}

