/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.img.WarpedSource;
import bdv.util.Elliptical3DTransform;
import bdv.viewer.Interpolation;
import bdv.viewer.SourceAndConverter;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.imglib2.RealRandomAccess;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.RealType;
import org.apache.commons.math3.analysis.MultivariateFunction;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.optim.InitialGuess;
import org.apache.commons.math3.optim.MaxEval;
import org.apache.commons.math3.optim.OptimizationData;
import org.apache.commons.math3.optim.PointValuePair;
import org.apache.commons.math3.optim.nonlinear.scalar.GoalType;
import org.apache.commons.math3.optim.nonlinear.scalar.ObjectiveFunction;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.NelderMeadSimplex;
import org.apache.commons.math3.optim.nonlinear.scalar.noderiv.SimplexOptimizer;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;

@Plugin(type=BdvPlaygroundActionCommand.class, initializer="init", menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Elliptic 3D Transform Optimization")
public class Optimize3DEllipticalTransformCommand
implements BdvPlaygroundActionCommand {
    @Parameter(type=ItemIO.BOTH)
    Elliptical3DTransform e3dt;
    @Parameter
    double threshold_intensity = 0.0;
    @Parameter
    boolean r1 = true;
    @Parameter(style="format:0.#####E0")
    double sr1 = 1.0;
    @Parameter
    boolean r2 = true;
    @Parameter(style="format:0.#####E0")
    double sr2 = 1.0;
    @Parameter
    boolean r3 = true;
    @Parameter(style="format:0.#####E0")
    double sr3 = 1.0;
    @Parameter
    boolean rx = true;
    @Parameter(style="format:0.#####E0")
    double srx = 0.1;
    @Parameter
    boolean ry = true;
    @Parameter(style="format:0.#####E0")
    double sry = 0.1;
    @Parameter
    boolean rz = true;
    @Parameter(style="format:0.#####E0")
    double srz = 0.1;
    @Parameter
    boolean tx = true;
    @Parameter(style="format:0.#####E0")
    double stx = 1.0;
    @Parameter
    boolean ty = true;
    @Parameter(style="format:0.#####E0")
    double sty = 1.0;
    @Parameter
    boolean tz = true;
    @Parameter(style="format:0.#####E0")
    double stz = 1.0;
    @Parameter
    SourceAndConverter sac;
    int nOptimizedParams;
    @Parameter
    int source_mip_map_level = 0;
    @Parameter
    int source_timepoint = 0;
    @Parameter
    double phi_min = -Math.PI;
    @Parameter
    double phi_max = Math.PI;
    @Parameter
    double theta_min = 0.0;
    @Parameter
    double theta_max = Math.PI;
    @Parameter
    double d_phi = 0.05;
    @Parameter
    double d_theta = 0.05;
    @Parameter
    int max_optimisation_step;
    @Parameter
    int timeout_seconds;
    int counter = 0;

    public void run() {
        WarpedSource ws = (WarpedSource)this.sac.getSpimSource();
        this.nOptimizedParams = 0;
        if (this.r1) {
            ++this.nOptimizedParams;
        }
        if (this.r2) {
            ++this.nOptimizedParams;
        }
        if (this.r3) {
            ++this.nOptimizedParams;
        }
        if (this.rx) {
            ++this.nOptimizedParams;
        }
        if (this.ry) {
            ++this.nOptimizedParams;
        }
        if (this.rz) {
            ++this.nOptimizedParams;
        }
        if (this.tx) {
            ++this.nOptimizedParams;
        }
        if (this.ty) {
            ++this.nOptimizedParams;
        }
        if (this.tz) {
            ++this.nOptimizedParams;
        }
        if (ws.getType() instanceof RealType) {
            final MultivariateFunction mf = doubles -> {
                this.setParams(doubles);
                double ans = this.computeIntegratedIntensity(ws.getInterpolatedSource(this.source_timepoint, this.source_mip_map_level, Interpolation.NEARESTNEIGHBOR).realRandomAccess());
                Map<String, Double> params = this.e3dt.getParameters();
                return ans * params.get("radiusX") * params.get("radiusY") * params.get("radiusZ");
            };
            final SimplexOptimizer optimizer = new SimplexOptimizer(1.0E-10, 1.0E-30);
            try {
                Duration timeout = Duration.ofSeconds(this.timeout_seconds);
                ExecutorService executor = Executors.newSingleThreadExecutor();
                Future handler = executor.submit(new Callable(){

                    public double[] call() throws Exception {
                        PointValuePair optimum = optimizer.optimize(new OptimizationData[]{new MaxEval(Optimize3DEllipticalTransformCommand.this.max_optimisation_step), new ObjectiveFunction(mf), GoalType.MAXIMIZE, new InitialGuess(Optimize3DEllipticalTransformCommand.this.getCurrentOptimizedParamsAsDoubles()), new NelderMeadSimplex(Optimize3DEllipticalTransformCommand.this.getStepOptimizedParamsAsDoubles())});
                        return optimum.getPoint();
                    }
                });
                try {
                    this.setParams((double[])handler.get(timeout.toMillis(), TimeUnit.MILLISECONDS));
                }
                catch (TimeoutException e) {
                    handler.cancel(true);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                executor.shutdownNow();
            }
            catch (TooManyEvaluationsException e) {
                System.err.println("Optimization did not converge in " + this.max_optimisation_step + " iterations");
            }
        } else {
            System.err.println("Cannot optimize because the pixel type is not numeric");
        }
    }

    public double[] getCurrentOptimizedParamsAsDoubles() {
        double[] ans = new double[this.nOptimizedParams];
        int cIndex = 0;
        Map<String, Double> p = this.e3dt.getParameters();
        if (this.r1) {
            ans[cIndex] = p.get("radiusX");
            ++cIndex;
        }
        if (this.r2) {
            ans[cIndex] = p.get("radiusY");
            ++cIndex;
        }
        if (this.r3) {
            ans[cIndex] = p.get("radiusZ");
            ++cIndex;
        }
        if (this.rx) {
            ans[cIndex] = p.get("rotationX");
            ++cIndex;
        }
        if (this.ry) {
            ans[cIndex] = p.get("rotationY");
            ++cIndex;
        }
        if (this.rz) {
            ans[cIndex] = p.get("rotationZ");
            ++cIndex;
        }
        if (this.tx) {
            ans[cIndex] = p.get("centerX");
            ++cIndex;
        }
        if (this.ty) {
            ans[cIndex] = p.get("centerY");
            ++cIndex;
        }
        if (this.tz) {
            ans[cIndex] = p.get("centerZ");
            ++cIndex;
        }
        return ans;
    }

    public double[] getStepOptimizedParamsAsDoubles() {
        double[] ans = new double[this.nOptimizedParams];
        int cIndex = 0;
        Map<String, Double> p = this.e3dt.getParameters();
        if (this.r1) {
            ans[cIndex] = this.sr1;
            ++cIndex;
        }
        if (this.r2) {
            ans[cIndex] = this.sr2;
            ++cIndex;
        }
        if (this.r3) {
            ans[cIndex] = this.sr3;
            ++cIndex;
        }
        if (this.rx) {
            ans[cIndex] = this.srx;
            ++cIndex;
        }
        if (this.ry) {
            ans[cIndex] = this.sry;
            ++cIndex;
        }
        if (this.rz) {
            ans[cIndex] = this.srz;
            ++cIndex;
        }
        if (this.tx) {
            ans[cIndex] = this.stx;
            ++cIndex;
        }
        if (this.ty) {
            ans[cIndex] = this.sty;
            ++cIndex;
        }
        if (this.tz) {
            ans[cIndex] = this.stz;
            ++cIndex;
        }
        return ans;
    }

    public void setParams(double[] params) {
        Object[] args = new Object[params.length * 2];
        int cIndex = 0;
        if (this.r1) {
            args[2 * cIndex] = "radiusX";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.r2) {
            args[2 * cIndex] = "radiusY";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.r3) {
            args[2 * cIndex] = "radiusZ";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.rx) {
            args[2 * cIndex] = "rotationX";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.ry) {
            args[2 * cIndex] = "rotationY";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.rz) {
            args[2 * cIndex] = "rotationZ";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.tx) {
            args[2 * cIndex] = "centerX";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.ty) {
            args[2 * cIndex] = "centerY";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        if (this.tz) {
            args[2 * cIndex] = "centerZ";
            args[2 * cIndex + 1] = params[cIndex];
            ++cIndex;
        }
        this.e3dt.setParameters(args);
    }

    public <T extends RealType<T> & NativeType<T>> double computeIntegratedIntensity(RealRandomAccess<T> rra) {
        double somme = 0.0;
        for (double pTheta = this.theta_min; pTheta <= this.theta_max; pTheta += this.d_theta) {
            for (double pPhi = this.phi_min; pPhi <= this.phi_max; pPhi += this.d_phi) {
                rra.setPosition(new double[]{1.0, pTheta, pPhi});
                double v = ((RealType)rra.get()).getRealDouble();
                if (!(v > this.threshold_intensity)) continue;
                somme += v * Math.abs(Math.sin(pTheta));
            }
        }
        ++this.counter;
        System.out.println(this.counter + "\t v=" + somme);
        return somme;
    }
}

