/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.img.WarpedSource;
import bdv.util.Elliptical3DTransform;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.sourceandconverter.exporter.CZTRange;
import ch.epfl.biop.sourceandconverter.exporter.ImagePlusSampler;
import ij.IJ;
import ij.ImagePlus;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.imglib2.Interval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Util;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.ItemVisibility;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.task.Task;
import org.scijava.task.TaskService;
import org.scijava.widget.Button;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Export elliptic 3D transformed sources")
public class ExportEllipticProjection
implements Command {
    @Parameter(label="", visibility=ItemVisibility.MESSAGE, required=false, persist=false)
    String export_sources_message = "<html><h2>Exported Elliptic Transformed Source</h2></html>";
    @Parameter(label="Select the elliptic transformed sources", callback="validateMessage")
    SourceAndConverter<?>[] sacs;
    @Parameter(label="Resolution level (0 = highest)")
    public int level;
    @Parameter(label="Update", callback="validateMessage")
    Button update_button1;
    @Parameter(label="", visibility=ItemVisibility.MESSAGE, required=false, persist=false)
    String validate_message = "Please select the sources to export. Click update for more info.";
    @Parameter(label="", visibility=ItemVisibility.MESSAGE, required=false, persist=false)
    String export_range_message = "<html><h2>Exported Range</h2></html>";
    @Parameter(callback="validateMessage", style="format:0.#####E0")
    double r_min = 0.8;
    @Parameter(callback="validateMessage", style="format:0.#####E0")
    double r_max = 1.2;
    @Parameter(callback="validateMessage", style="format:0.#####E0")
    double radius_step = 0.01;
    @Parameter(style="slider, format:0.#####E0", stepSize="1", min="0", max="180", callback="validateMessage")
    double theta_min = 0.0;
    @Parameter(style="slider, format:0.#####E0", stepSize="1", min="0", max="180", callback="validateMessage")
    double theta_max = 180.0;
    @Parameter(style="slider, format:0.#####E0", stepSize="1", min="0", max="360", callback="validateMessage")
    double phi_min = 0.0;
    @Parameter(style="slider, format:0.#####E0", stepSize="1", min="0", max="360", callback="validateMessage")
    double phi_max = 360.0;
    @Parameter(callback="validateMessage", style="format:0.#####E0")
    double angle_step = 0.01;
    @Parameter(label="", visibility=ItemVisibility.MESSAGE, required=false, persist=false)
    String exported_image_message = "<html><h2>Exported Image Parameters</h2></html>";
    @Parameter(label="Exported Image Name")
    public String name = "Image_00";
    @Parameter(label="Select Range", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String range_message = "You can use commas or colons to separate ranges. eg. '1:10' or '1,3,5,8' ";
    @Parameter(label="Selected Channels. Leave blank for all", required=false)
    String range_channels = "";
    @Parameter(label="Selected Slices. Leave blank for all", required=false)
    String range_slices = "";
    @Parameter(label="Selected Timepoints. Leave blank for all", required=false)
    String range_frames = "";
    @Parameter(label="Export mode", choices={"Normal", "Virtual", "Virtual no-cache"}, required=false)
    String export_mode = "Non virtual";
    @Parameter(label="Monitor loaded data")
    Boolean monitor = false;
    @Parameter(label="Interpolate")
    public boolean interpolate = false;
    @Parameter
    String unit = "px";
    @Parameter(type=ItemIO.OUTPUT)
    public ImagePlus imp_out;
    @Parameter(label="Update", callback="validateMessage")
    Button update_button2;
    @Parameter(label="Image Info", visibility=ItemVisibility.MESSAGE, persist=false, required=false)
    String message = "[SX: , SY:, SZ:, #C:, #T:], ? Mb";
    @Parameter
    Context context;
    Elliptical3DTransform e3dt;
    int maxTimepoint = 1;
    CZTRange range;
    @Parameter
    TaskService taskService;
    Elliptical3DTransform transform = null;
    public Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter = sacslist -> SourceAndConverterHelper.sortDefaultGeneric((Collection)sacslist);

    public void run() {
        boolean virtual;
        this.validateMessage();
        List<SourceAndConverter<?>> sources = this.sorter.apply(Arrays.asList(this.sacs));
        if (this.sacs == null || this.sacs.length == 0) {
            IJ.log((String)"No selected source. Abort command.");
            return;
        }
        SourceAndConverter<?> model = this.createModelSource();
        boolean cacheImage = false;
        switch (this.export_mode) {
            case "Normal": {
                virtual = false;
                break;
            }
            case "Virtual": {
                virtual = true;
                cacheImage = true;
                break;
            }
            case "Virtual no-cache": {
                virtual = true;
                cacheImage = false;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unrecognized export mode " + this.export_mode);
            }
        }
        DecimalFormat df = new DecimalFormat("#.00");
        String suffixName = "_R[" + df.format(this.r_min) + "; " + df.format(this.r_max) + "]_Theta[" + df.format(this.theta_min) + "; " + df.format(this.theta_max) + "]_Phi[" + df.format(this.phi_min) + "; " + df.format(this.phi_max) + "]";
        try {
            Task task = null;
            if (this.monitor.booleanValue()) {
                task = this.taskService.createTask("Elliptic projection:" + this.name + suffixName);
            }
            this.imp_out = ImagePlusSampler.Builder().cache(cacheImage).unit(this.unit).title(this.name + suffixName).setModel(model).virtual(virtual).interpolate(this.interpolate).rangeT(this.range_frames).rangeC(this.range_channels).rangeZ(this.range_slices).monitor(task).level(this.level).sources(sources.toArray(new SourceAndConverter[0])).get();
            this.imp_out.show();
            if (this.transform != null) {
                String transformSerialized = ScijavaGsonHelper.getGson((Context)this.context).toJson((Object)this.transform);
                String info = this.imp_out.getInfoProperty();
                info = info + "\n" + transformSerialized + "\n";
                this.imp_out.setProperty("Info", (Object)info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void validateMessage() {
        int maxZSlices;
        if (this.sacs == null || this.sacs.length == 0) {
            this.validate_message = "Please select the sources to export";
            return;
        }
        this.transform = null;
        boolean hasMultipleTransforms = false;
        for (SourceAndConverter<?> source : this.sacs) {
            if (!(source.getSpimSource() instanceof WarpedSource)) {
                this.validate_message = source.getSpimSource().getName() + " is not a transformed source";
                return;
            }
            RealTransform rt = ((WarpedSource)source.getSpimSource()).getTransform();
            if (!(rt instanceof Elliptical3DTransform)) {
                this.validate_message = source.getSpimSource().getName() + " is not an elliptic transformed source";
                return;
            }
            if (this.transform == null) {
                this.transform = (Elliptical3DTransform)rt;
                continue;
            }
            if (rt.equals(this.transform)) continue;
            hasMultipleTransforms = true;
        }
        this.e3dt = this.transform;
        this.validate_message = "<html>";
        if (hasMultipleTransforms) {
            this.validate_message = this.validate_message + "Multiple transforms found. Potential incorrect sampling advice.<br>";
        }
        SourceAndConverter<?> modelSource = this.sacs[0];
        Source wrappedSource = ((WarpedSource)modelSource.getSpimSource()).getWrappedSource();
        double rMean = (this.e3dt.getParameters().get("radiusX") + this.e3dt.getParameters().get("radiusY") + this.e3dt.getParameters().get("radiusZ")) / 3.0;
        double dxy = rMean * this.angle_step * Math.PI / 180.0;
        double dz = rMean * this.radius_step;
        DecimalFormat df = new DecimalFormat("00.###E0");
        if (dxy == 0.0 || dz == 0.0) {
            this.validate_message = this.validate_message + "<font color=\"red\"> Error! Wrong step size. </font><br>";
        } else {
            int levelXY = SourceAndConverterHelper.bestLevel((Source)wrappedSource, (int)0, (double)dxy);
            this.validate_message = this.validate_message + "Equatorial pixel size (xy): " + df.format(dxy) + "<br>";
            this.validate_message = this.validate_message + "Recommended Level:" + levelXY + "<br>";
            int levelZ = SourceAndConverterHelper.bestLevel((Source)wrappedSource, (int)0, (double)dz);
            this.validate_message = this.validate_message + "Equatorial pixel size (z): " + df.format(dz) + "<br>";
            this.validate_message = this.validate_message + "Recommended Level:" + levelZ + "<br>";
        }
        this.maxTimepoint = SourceAndConverterHelper.getMaxTimepoint(this.sacs);
        int maxTimeFrames = SourceAndConverterHelper.getMaxTimepoint(this.sacs);
        if (this.r_min == this.r_max) {
            maxZSlices = 1;
        } else {
            if (this.radius_step <= 0.0) {
                this.validate_message = this.validate_message + "<font color=\"red\">Error : radius Step is null!</font><br></html>";
                return;
            }
            maxZSlices = (int)((this.r_max - this.r_min) / this.radius_step) + 1;
        }
        if (this.angle_step <= 0.0) {
            this.validate_message = this.validate_message + "<font color=\"red\">Error : angle Step is null!</font><br></html>";
        }
        this.validate_message = this.validate_message + "</html>";
        int imageWidth = (int)((this.phi_max - this.phi_min) / this.angle_step);
        int imageHeight = (int)((this.theta_max - this.theta_min) / this.angle_step);
        try {
            this.range = new CZTRange.Builder().setC(this.range_channels).setZ(this.range_slices).setT(this.range_frames).get(this.sacs.length, maxZSlices, maxTimeFrames);
        }
        catch (Exception e) {
            this.validate_message = this.validate_message + "<font color=\"red\">" + e.getMessage() + "</font><br></html>";
            return;
        }
        long nBytesPerPlane = (long)imageWidth * (long)imageHeight * 2L;
        int nc = this.range.getRangeC().size();
        int nz = this.range.getRangeZ().size();
        int nt = this.range.getRangeT().size();
        int bytesPerPix = this.getBytesPerPixel(this.sacs[0]);
        long nTotalBytes = this.range.getTotalPlanes() * nBytesPerPlane * (long)bytesPerPix;
        double totalMb = (double)nTotalBytes / 1048576.0;
        DecimalFormat df2 = new DecimalFormat("###.0");
        this.message = "[SX:" + imageWidth + ", SY:" + imageHeight + ", SZ:" + nz + ", #C:" + nc + ", #T:" + nt + "], " + df2.format(totalMb) + " Mb";
    }

    private int getBytesPerPixel(SourceAndConverter sac) {
        Object o = Util.getTypeFromInterval((Interval)sac.getSpimSource().getSource(0, 0));
        if (o instanceof UnsignedByteType) {
            return 1;
        }
        if (o instanceof UnsignedShortType) {
            return 2;
        }
        if (o instanceof ARGBType) {
            return 4;
        }
        if (o instanceof FloatType) {
            return 4;
        }
        throw new UnsupportedOperationException("Unsupported pixel type " + o.getClass());
    }

    private SourceAndConverter<?> createModelSource() {
        AffineTransform3D at3D = new AffineTransform3D();
        double samplingxyinphysicalunit = this.angle_step * Math.PI / 180.0;
        double samplingzinphysicalunit = this.radius_step;
        at3D.set(samplingxyinphysicalunit, 0, 0);
        at3D.set(samplingxyinphysicalunit, 1, 1);
        at3D.set(samplingzinphysicalunit, 2, 2);
        at3D.rotate(1, -1.5707963267948966);
        at3D.translate(new double[]{this.r_max - this.radius_step, this.theta_min * Math.PI / 180.0, this.phi_min * Math.PI / 180.0});
        long nPx = (int)((this.phi_max - this.phi_min) / this.angle_step);
        long nPy = (int)((this.theta_max - this.theta_min) / this.angle_step);
        long nPz = this.r_min == this.r_max ? 1L : (long)((int)((this.r_max - this.r_min) / this.radius_step) + 1);
        if (nPz == 0L) {
            nPz = 1L;
        }
        if (nPx == 0L) {
            nPx = 1L;
        }
        if (nPy == 0L) {
            nPy = 1L;
        }
        return new EmptySourceAndConverterCreator(this.name + "_Model", at3D, nPx, nPy, nPz).get();
    }
}

