/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.util.Elliptical3DTransform;
import ch.epfl.biop.scijava.command.transform.DisplayEllipseFromTransformCommand;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Import Elliptic 3D Transform")
public class Elliptic3DTransformImporterCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    CommandService commandService;
    @Parameter
    Context context;
    @Parameter(label="Json file")
    File file;
    @Parameter(type=ItemIO.OUTPUT)
    Elliptical3DTransform e3dt;

    public void run() {
        this.e3dt = this.readTransformFromFile(this.file);
        this.commandService.run(DisplayEllipseFromTransformCommand.class, false, new Object[]{"r_min", 0.9, "r_max", 1.1, "e3dt", this.e3dt});
    }

    private Elliptical3DTransform readTransformFromFile(File file) {
        try {
            return (Elliptical3DTransform)ScijavaGsonHelper.getGson((Context)this.context).fromJson((Reader)new FileReader(file), Elliptical3DTransform.class);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

