/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.util.Elliptical3DTransform;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import net.imglib2.realtransform.RealTransform;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.persist.ScijavaGsonHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Export Elliptic 3D Transform")
public class Elliptic3DTransformExporterCommand
implements BdvPlaygroundActionCommand {
    @Parameter
    Context context;
    @Parameter
    Elliptical3DTransform e3dt;
    @Parameter(label="Output file", style="save")
    File file;

    public void run() {
        String json = ScijavaGsonHelper.getGson((Context)this.context).toJson((Object)this.e3dt, RealTransform.class);
        this.ensureEndsWithJSON(this.file);
        this.writeToFile(json, this.file);
    }

    private void writeToFile(String json, File file) {
        try {
            FileUtils.writeStringToFile((File)file, (String)json, (Charset)Charset.defaultCharset(), (boolean)false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void ensureEndsWithJSON(File file) {
        if (!file.toString().endsWith(".json")) {
            this.file.renameTo(new File(this.file + ".json"));
        }
    }
}

