/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.img.WarpedSource;
import bdv.util.BdvHandle;
import bdv.util.RealTransformHelper;
import bdv.viewer.SourceAndConverter;
import ij.gui.WaitForUserDialog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.imglib2.realtransform.RealTransform;
import org.scijava.ItemIO;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.register.BigWarpLauncher;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Register>Obsolete>Edit Sources Warping")
public class EditSourcesWarpingCommand
implements BdvPlaygroundActionCommand {
    @Parameter(type=ItemIO.BOTH)
    SourceAndConverter<?>[] moving_sources;
    @Parameter(required=false)
    SourceAndConverter<?>[] fixed_sources;
    @Parameter
    boolean is2d;
    Runnable waitForUser = () -> {
        WaitForUserDialog dialog = new WaitForUserDialog("Choose slice", "Please perform carefully your registration then press ok.");
        dialog.show();
    };

    public void run() {
        List<Object> fixedSacs;
        for (SourceAndConverter<?> sac : this.moving_sources) {
            if (sac.getSpimSource() instanceof WarpedSource) continue;
            System.err.println(sac.getSpimSource().getName() + " is not a Warped source, it cannot be edited");
        }
        RealTransform rt = ((WarpedSource)this.moving_sources[0].getSpimSource()).getTransform();
        List movingSacs = Arrays.stream(this.moving_sources).collect(Collectors.toList());
        List converterSetups = Arrays.stream(this.moving_sources).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList());
        if (this.fixed_sources != null) {
            fixedSacs = Arrays.stream(this.fixed_sources).collect(Collectors.toList());
            converterSetups.addAll(Arrays.stream(this.fixed_sources).map(src -> SourceAndConverterServices.getSourceAndConverterService().getConverterSetup(src)).collect(Collectors.toList()));
        } else {
            fixedSacs = new ArrayList();
        }
        BigWarpLauncher bwl = new BigWarpLauncher(movingSacs, fixedSacs, "Big Warp", converterSetups);
        bwl.set2d();
        bwl.run();
        BdvHandle bdvhQ = bwl.getBdvHandleQ();
        BdvHandle bdvhP = bwl.getBdvHandleP();
        bdvhP.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhP, (double[])new double[]{0.0, 0.0, 0.0}));
        bdvhQ.getViewerPanel().state().setViewerTransform(BdvHandleHelper.getViewerTransformWithNewCenter((BdvHandle)bdvhQ, (double[])new double[]{0.0, 0.0, 0.0}));
        SourceAndConverterServices.getBdvDisplayService().pairClosing(bdvhQ, bdvhP);
        bdvhP.getViewerPanel().requestRepaint();
        bdvhQ.getViewerPanel().requestRepaint();
        bwl.getBigWarp().getLandmarkFrame().repaint();
        bwl.getBigWarp().loadLandmarks(RealTransformHelper.BigWarpFileFromRealTransform(rt));
        bwl.getBigWarp().setIsMovingDisplayTransformed(true);
        this.waitForUser.run();
        rt = bwl.getBigWarp().getBwTransform().getTransformation();
        bwl.getBigWarp().closeAll();
        for (SourceAndConverter<?> sac : this.moving_sources) {
            WarpedSource src2 = (WarpedSource)sac.getSpimSource();
            src2.updateTransform(rt);
            src2.setIsTransformed(true);
            if (sac.asVolatile() == null) continue;
            WarpedSource vsrc = (WarpedSource)sac.asVolatile().getSpimSource();
            vsrc.updateTransform(rt);
            vsrc.setIsTransformed(true);
        }
    }
}

