/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.scijava.command.bdv.userdefinedregion.BoxSelectorCommand;
import ch.epfl.biop.scijava.command.transform.ExportEllipticProjection;
import ij.IJ;
import ij.ImagePlus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Function;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.CommandModule;
import org.scijava.command.CommandService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.command.BdvPlaygroundActionCommand;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;

@Plugin(type=BdvPlaygroundActionCommand.class, menuPath="Plugins>BigDataViewer-Playground>Sources>Transform>Export elliptic 3D transformed sources (interactive box)")
public class EasyExportEllipticProjection
implements Command {
    @Parameter(label="Select the elliptic transformed sources", callback="validateMessage")
    SourceAndConverter<?>[] sacs;
    @Parameter(type=ItemIO.OUTPUT)
    public ImagePlus imp_out;
    @Parameter
    CommandService cs;
    @Parameter
    SourceAndConverterBdvDisplayService displayService;
    public Function<Collection<SourceAndConverter<?>>, List<SourceAndConverter<?>>> sorter = sacslist -> SourceAndConverterHelper.sortDefaultGeneric((Collection)sacslist);

    public void run() {
        try {
            List<SourceAndConverter<?>> sources = this.sorter.apply(Arrays.asList(this.sacs));
            BdvHandle bdvh = this.displayService.getNewBdv();
            this.displayService.show(bdvh, sources.toArray(new SourceAndConverter[0]));
            AffineTransform3D view = new AffineTransform3D();
            view.set(0.0, 0.0, 30.0, 415.0, 0.0, 30.0, 0.0, 260.0, -30.0, 0.0, 0.0, 30.0);
            bdvh.getViewerPanel().state().setViewerTransform(view);
            if (this.sacs == null || this.sacs.length == 0) {
                IJ.log((String)"No selected source. Abort command.");
                return;
            }
            CommandModule boxSelector = (CommandModule)this.cs.run(BoxSelectorCommand.class, true, new Object[]{"bdvh", bdvh, "message", "Select (r, theta, phi) bounds to crop", "zmin", Math.PI * -4, "zmax", Math.PI * 4, "ymin", Math.PI * -2, "ymax", Math.PI * 2, "xmin", 0, "xmax", 3, "zmin_ini", Math.PI * -2, "zmax_ini", Math.PI * 2, "ymin_ini", -Math.PI, "ymax_ini", Math.PI, "xmin_ini", 0.7, "xmax_ini", 1.3}).get();
            if (((Boolean)boxSelector.getOutput("result")).booleanValue()) {
                RealInterval interval = (RealInterval)boxSelector.getOutput("interval");
                Future imageGetter = this.cs.run(ExportEllipticProjection.class, true, new Object[]{"sacs", this.sacs, "r_min", interval.realMin(0), "r_max", interval.realMax(0), "theta_min", interval.realMin(1) * 180.0 / Math.PI, "theta_max", interval.realMax(1) * 180.0 / Math.PI, "phi_min", interval.realMin(2) * 180.0 / Math.PI, "phi_max", interval.realMax(2) * 180.0 / Math.PI});
                this.imp_out = (ImagePlus)((CommandModule)imageGetter.get()).getOutput("imp_out");
            } else {
                IJ.log((String)"Invalid box");
            }
            this.displayService.closeBdv(bdvh);
            bdvh.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

