/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.transform;

import bdv.img.WarpedSource;
import bdv.util.Elliptical3DTransform;
import bdv.util.Procedural3DImageShort;
import bdv.util.RealRandomAccessibleIntervalSource;
import bdv.viewer.Source;
import bdv.viewer.SourceAndConverter;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.BoundingBoxEstimation;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.services.SourceAndConverterServices;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAdjuster;

public class DisplayEllipseFromTransformCommand
implements Command {
    @Parameter(type=ItemIO.OUTPUT)
    SourceAndConverter sac_out;
    @Parameter(type=ItemIO.BOTH)
    Elliptical3DTransform e3dt;
    @Parameter(style="format:0.#####E0")
    double r_min = 0.9;
    @Parameter(style="format:0.#####E0")
    double r_max = 1.1;
    @Parameter
    SourceAndConverterService sacService;

    public void run() {
        RealRandomAccessible rra = new Procedural3DImageShort(p -> {
            if (p[0] > this.r_min && p[0] < this.r_max) {
                if (p[1] > 1.5707963267948966) {
                    return (int)(255.0 * (1.0 + 0.25 * Math.cos(20.0 * p[2])) / 2.0);
                }
                return (int)(126.0 * (1.0 + 0.25 * Math.cos(20.0 * p[2])) / 2.0);
            }
            return 0;
        }).getRRA();
        FinalInterval interval = new FinalInterval(new long[]{-2L, -2L, -2L}, new long[]{2L, 2L, 2L});
        UnsignedShortType type = (UnsignedShortType)rra.realRandomAccess().get();
        RealRandomAccessibleIntervalSource s = new RealRandomAccessibleIntervalSource(rra, (Interval)interval, (Type)type, new AffineTransform3D(), "Ellipse");
        WarpedSource ws = new WarpedSource((Source)s, "Ellipsoid");
        ws.setBoundingBoxEstimator(new BoundingBoxEstimation(BoundingBoxEstimation.Method.CORNERS));
        ws.updateTransform((RealTransform)this.e3dt.inverse());
        ws.setIsTransformed(true);
        this.sac_out = SourceAndConverterHelper.createSourceAndConverter((Source)ws);
        this.sacService.register(this.sac_out);
        this.e3dt.updateNotifiers.add(() -> {
            ws.updateTransform((RealTransform)this.e3dt.inverse());
            SourceAndConverterServices.getBdvDisplayService().getDisplaysOf(new SourceAndConverter[]{this.sac_out}).forEach(bdvHandle -> bdvHandle.getViewerPanel().requestRepaint());
        });
        new BrightnessAdjuster(this.sac_out, 0.0, 255.0).run();
    }
}

