/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsBdvOpener;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsToSpimData;
import ch.epfl.biop.bdv.img.legacy.bioformats.BioFormatsTools;
import ch.epfl.biop.bdv.img.legacy.bioformats.entity.FileIndex;
import ch.epfl.biop.spimdata.reordered.LifReOrdered;
import ij.IJ;
import java.io.File;
import loci.formats.IFormatReader;
import loci.formats.meta.IMetadata;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.apache.commons.io.FilenameUtils;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import spimdata.SpimDataHelper;
import spimdata.util.Displaysettings;

@Deprecated
@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Edit>(Legacy) Reorder BDV Dataset")
public class ReorderDatasetCommand
implements Command {
    @Parameter(label="Lif file to reorder", style="open")
    File file;
    @Parameter(label="Xml Bdv Dataset output", style="save")
    File xmlout;
    @Parameter(label="Number of tiles")
    int n_tiles;
    @Parameter(label="Number of channels")
    int n_channels;

    public void run() {
        if (this.xmlout.exists()) {
            IJ.error((String)"The output file already exist! Skipping execution");
        } else {
            try {
                BioFormatsBdvOpener opener = BioFormatsToSpimData.getDefaultOpener((String)this.file.getAbsolutePath()).micrometer();
                IFormatReader reader = opener.getNewReader();
                Length[] voxSizes = BioFormatsTools.getSeriesVoxelSizeAsLengths((IMetadata)((IMetadata)reader.getMetadataStore()), (int)0);
                double pixSizeXYMicrometer = voxSizes[0].value(UNITS.MICROMETER).doubleValue();
                double scalingForBigStitcher = 1.0 / pixSizeXYMicrometer;
                reader.close();
                AbstractSpimData asd = BioFormatsToSpimData.getSpimData((BioFormatsBdvOpener)opener.voxSizeReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)).positionReferenceFrameLength(new Length((Number)1, UNITS.MICROMETER)));
                String intermediateXml = FilenameUtils.removeExtension((String)this.xmlout.getAbsolutePath()) + "_nonreordered.xml";
                System.out.println(intermediateXml);
                SpimDataHelper.removeEntities((AbstractSpimData)asd, (Class[])new Class[]{Displaysettings.class, FileIndex.class});
                asd.setBasePath(new File(intermediateXml).getParentFile());
                if (asd instanceof SpimData) {
                    new XmlIoSpimData().save((AbstractSpimData)((SpimData)asd), intermediateXml);
                } else if (asd instanceof SpimDataMinimal) {
                    new XmlIoSpimDataMinimal().save((AbstractSpimData)((SpimDataMinimal)asd), FilenameUtils.getName((String)intermediateXml));
                }
                LifReOrdered kd = new LifReOrdered(intermediateXml, this.n_tiles, this.n_channels);
                kd.initialize();
                AbstractSpimData reshuffled = kd.constructSpimData();
                reshuffled.setBasePath(new File(this.xmlout.getAbsolutePath()).getParentFile());
                new XmlIoSpimData().save((AbstractSpimData)((SpimData)reshuffled), this.xmlout.getAbsolutePath());
                SpimDataHelper.scale((AbstractSpimData)reshuffled, (String)"BigStitcher Scaling", (double)scalingForBigStitcher);
                String bigstitcherXml = FilenameUtils.removeExtension((String)this.xmlout.getAbsolutePath()) + "_bigstitcher.xml";
                new XmlIoSpimData().save((AbstractSpimData)((SpimData)reshuffled), bigstitcherXml);
                IJ.log((String)("- Dataset created - " + intermediateXml));
                IJ.log((String)("- Reordered Dataset created - " + this.xmlout.getAbsolutePath()));
                IJ.log((String)("- Reordered Dataset created, rescaled for BigStitched - " + bigstitcherXml));
                IJ.log((String)"Done!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

