/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import ij.IJ;
import java.io.File;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.XmlIoSpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import spimdata.SpimDataHelper;
import spimdata.util.Displaysettings;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Edit>Remove Display Settings from BDVDataset")
public class RemoveDisplaySettingsCommand
implements Command {
    @Parameter(label="Xml Bdv Dataset input", style="open")
    File xmlin;
    @Parameter(label="Xml Bdv Dataset output", style="save")
    File xmlout;

    public void run() {
        if (this.xmlout.exists()) {
            IJ.error((String)"The output file already exist! Skipping execution");
            return;
        }
        try {
            AbstractSpimData asd = new XmlIoSpimData().load(this.xmlin.getAbsolutePath());
            SpimDataHelper.removeEntities((AbstractSpimData)asd, (Class[])new Class[]{Displaysettings.class});
            new XmlIoSpimData().save((AbstractSpimData)((SpimData)asd), this.xmlout.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

