/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import bdv.viewer.SourceGroup;
import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import ch.epfl.biop.operetta.OperettaManager;
import ij.IJ;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.AffineTransform3D;
import ome.xml.model.Well;
import org.apache.commons.io.FileUtils;
import org.scijava.Context;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.scijava.services.ui.SourceAndConverterServiceUI;
import sc.fiji.bdvpg.scijava.services.ui.SourceFilterNode;
import sc.fiji.bdvpg.scijava.services.ui.SpimDataFilterNode;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.display.BrightnessAdjuster;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset [Operetta]")
public class OpenOperettaDatasetCommand
implements Command {
    @Parameter(required=false, label="Physical unit", choices={"MILLIMETER", "MICROMETER", "NANOMETER"})
    public String unit = "MILLIMETER";
    String message = "BIOP Operetta BigDataViewer";
    @Parameter(label="Select the 'Images' folder of your Operetta dataset", style="directory")
    File folder;
    @Parameter
    Context ctx;
    @Parameter
    SourceAndConverterService sourceService;
    @Parameter
    SourceAndConverterBdvDisplayService sourceDisplayService;
    @Parameter
    double min_display_value = 0.0;
    @Parameter
    double max_display_value = 20000.0;
    @Parameter
    boolean show = true;
    @Parameter(type=ItemIO.OUTPUT)
    String dataset_name;
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    static final DecimalFormat df = new DecimalFormat("00");

    public void run() {
        int estimatedOpeningTimeInMin;
        XMLFILE file = null;
        for (XMLFILE version : XMLFILE.values()) {
            File candidate = new File(this.folder, version.getIndexFileName());
            if (!candidate.exists()) continue;
            file = version;
            break;
        }
        if (file == null) {
            IJ.log((String)("Error, no matching Index files found in " + this.folder.getAbsolutePath()));
            IJ.log((String)"Implemented valid Index files:");
            for (XMLFILE version : XMLFILE.values()) {
                IJ.log((String)("\t" + version.getIndexFileName() + " (" + version.getDescription() + ")"));
            }
            return;
        }
        File f = new File(this.folder, file.getIndexFileName());
        int sizeInMb = (int)((double)FileUtils.sizeOf((File)f) / 1048576.0);
        IJ.log((String)("- Opening Operetta dataset " + f.getAbsolutePath() + " (" + sizeInMb + " Mb)"));
        File fmemo = new File(this.folder, ".Index.idx.xml.bfmemo");
        if (!fmemo.exists()) {
            estimatedOpeningTimeInMin = sizeInMb / 30;
            IJ.log((String)"- No memo file, the first opening will take longer.");
        } else {
            estimatedOpeningTimeInMin = sizeInMb / 600;
            IJ.log((String)"- Memo file detected.");
        }
        if (estimatedOpeningTimeInMin == 0) {
            IJ.log((String)"- Estimated opening time below 1 minute.");
        } else {
            IJ.log((String)("- Estimated opening time = " + estimatedOpeningTimeInMin + " min."));
        }
        IFormatReader[] reader = new IFormatReader[1];
        Thread t = new Thread(() -> {
            try {
                reader[0] = OperettaManager.Builder.createReader((String)f.getAbsolutePath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (FormatException e) {
                e.printStackTrace();
            }
        });
        t.start();
        int countSeconds = 0;
        while (t.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                IJ.log((String)"Operetta dataset opening interrupted!");
                return;
            }
            if (++countSeconds % 20 != 0) continue;
            IJ.log((String)("- t = " + countSeconds + " s"));
        }
        if (reader[0] == null) {
            IJ.log((String)"Error during reader creation, please retry or post your issue in forum.image.sc.");
            return;
        }
        OperettaManager.Builder opmBuilder = new OperettaManager.Builder().reader(reader[0]);
        OperettaManager opm = opmBuilder.build();
        IJ.log((String)("Dataset " + opm.getPlateName() + " : " + opm.getRange()));
        int stack_width = reader[0].getSizeX();
        int stack_height = reader[0].getSizeY();
        try {
            ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
            int nSeries = BioFormatsHelper.getNSeries((File)f);
            for (int i = 0; i < nSeries; ++i) {
                openerSettings.add(OpenerSettings.BioFormats().location(f).setSerie(i).unit(this.unit).splitRGBChannels(false).cornerPositionConvention().cornerPositionConvention().cacheBlockSize(stack_width, stack_height, 1).context(this.ctx));
            }
            AbstractSpimData asd = OpenersToSpimData.getSpimData(openerSettings);
            this.sourceService.register(asd);
            IJ.log((String)"Done! Dataset opened.");
            this.dataset_name = opm.getPlateName();
            if (this.dataset_name == null) {
                IJ.log((String)"Error, could not find plate name!");
                this.dataset_name = this.folder.getParentFile().getName();
            }
            this.sourceService.setSpimDataName(asd, this.dataset_name);
            LinkedHashMap wellFilters = new LinkedHashMap();
            LinkedHashMap fieldsFilters = new LinkedHashMap();
            DefaultTreeModel model = this.sourceService.getUI().getTreeModel();
            opm.getWells().forEach(w -> {
                int row = (Integer)w.getRow().getValue() + 1;
                int col = (Integer)w.getColumn().getValue() + 1;
                String name = OpenOperettaDatasetCommand.getWellName(row, col);
                SourceFilterNode sfn = new SourceFilterNode(model, name, source -> source.getSpimSource().getName().startsWith("Well " + name + ","), false);
                wellFilters.put(w, sfn);
            });
            opm.getFieldIds().forEach(id -> fieldsFilters.put(id, new SourceFilterNode(model, "Field " + id, source -> source.getSpimSource().getName().contains(" Field " + id + "-"), false)));
            TreePath tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName());
            SpimDataFilterNode datasetNode = (SpimDataFilterNode)tp.getLastPathComponent();
            SourceFilterNode wellsNode = new SourceFilterNode(model, "Wells", source -> true, false);
            SourceFilterNode fieldsNode = new SourceFilterNode(model, "Fields", source -> true, false);
            this.sourceService.getUI().addNode((DefaultMutableTreeNode)datasetNode, (DefaultMutableTreeNode)wellsNode);
            this.sourceService.getUI().addNode((DefaultMutableTreeNode)datasetNode, (DefaultMutableTreeNode)fieldsNode);
            tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">SeriesIndex");
            this.sourceService.getUI().removeNode((DefaultMutableTreeNode)((SourceFilterNode)tp.getLastPathComponent()));
            tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">Illumination");
            this.sourceService.getUI().removeNode((DefaultMutableTreeNode)((SourceFilterNode)tp.getLastPathComponent()));
            tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">FileName");
            this.sourceService.getUI().removeNode((DefaultMutableTreeNode)((SourceFilterNode)tp.getLastPathComponent()));
            tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">Displaysettings");
            this.sourceService.getUI().removeNode((DefaultMutableTreeNode)((SourceFilterNode)tp.getLastPathComponent()));
            tp = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">Angle");
            this.sourceService.getUI().removeNode((DefaultMutableTreeNode)((SourceFilterNode)tp.getLastPathComponent()));
            wellFilters.values().forEach(wf -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        SourceFilterNode node = (SourceFilterNode)wf.clone();
                        this.sourceService.getUI().addNode((DefaultMutableTreeNode)wellsNode, (DefaultMutableTreeNode)node);
                        fieldsFilters.values().forEach(ff -> {
                            SourceFilterNode ffc = (SourceFilterNode)ff.clone();
                            this.sourceService.getUI().addNode((DefaultMutableTreeNode)node, (DefaultMutableTreeNode)ffc);
                            this.sourceService.getUI().addNode((DefaultMutableTreeNode)ffc, (DefaultMutableTreeNode)new SourceFilterNode(model, "Sources", source -> true, true));
                        });
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            });
            fieldsFilters.values().forEach(ff -> {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        SourceFilterNode node = (SourceFilterNode)ff.clone();
                        this.sourceService.getUI().addNode((DefaultMutableTreeNode)fieldsNode, (DefaultMutableTreeNode)node);
                        wellFilters.values().forEach(wf -> {
                            SourceFilterNode wfc = (SourceFilterNode)wf.clone();
                            this.sourceService.getUI().addNode((DefaultMutableTreeNode)node, (DefaultMutableTreeNode)wfc);
                            this.sourceService.getUI().addNode((DefaultMutableTreeNode)wfc, (DefaultMutableTreeNode)new SourceFilterNode(model, "Sources", source -> true, true));
                        });
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            });
            IJ.log((String)"Setting location in space...");
            double minX = Double.MAX_VALUE;
            double minY = Double.MAX_VALUE;
            double minZ = Double.MAX_VALUE;
            double maxX = -1.7976931348623157E308;
            double maxY = -1.7976931348623157E308;
            double maxZ = -1.7976931348623157E308;
            AffineTransform3D at3d = new AffineTransform3D();
            RealPoint topLeft = new RealPoint(3);
            RealPoint bottomRight = new RealPoint(3);
            int nSlices = opm.getRange().getRangeZ().size();
            Well w0 = (Well)opm.getWells().get(0);
            int row0 = (Integer)w0.getRow().getValue() + 1;
            int col0 = (Integer)w0.getColumn().getValue() + 1;
            String wellName0 = OpenOperettaDatasetCommand.getWellName(row0, col0);
            TreePath pathFirstWell = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">Wells>" + wellName0);
            for (SourceAndConverter source2 : this.sourceService.getUI().getSourceAndConvertersFromTreePath(pathFirstWell)) {
                source2.getSpimSource().getSourceTransform(0, 0, at3d);
                topLeft.setPosition(new double[]{0.0, 0.0, 0.0});
                at3d.apply((RealLocalizable)topLeft, (RealPositionable)topLeft);
                if (topLeft.getDoublePosition(0) < minX) {
                    minX = topLeft.getDoublePosition(0);
                }
                if (topLeft.getDoublePosition(1) < minY) {
                    minY = topLeft.getDoublePosition(1);
                }
                if (topLeft.getDoublePosition(2) < minZ) {
                    minZ = topLeft.getDoublePosition(2);
                }
                bottomRight.setPosition(new double[]{stack_width * 2, stack_height * 2, nSlices});
                at3d.apply((RealLocalizable)bottomRight, (RealPositionable)bottomRight);
                if (bottomRight.getDoublePosition(0) > maxX) {
                    maxX = bottomRight.getDoublePosition(0);
                }
                if (bottomRight.getDoublePosition(1) > maxY) {
                    maxY = bottomRight.getDoublePosition(1);
                }
                if (!(bottomRight.getDoublePosition(2) > maxZ)) continue;
                maxZ = bottomRight.getDoublePosition(2);
            }
            double originX = minX;
            double originY = minY;
            double originZ = minZ;
            double sizeX = maxX - minX;
            double sizeY = maxY - minY;
            double sizeZ = maxZ - minZ;
            double startX = Double.MAX_VALUE;
            double startY = Double.MAX_VALUE;
            for (Well w2 : opm.getWells()) {
                int row = (Integer)w2.getRow().getValue() + 1;
                int col = (Integer)w2.getColumn().getValue() + 1;
                String wellName = OpenOperettaDatasetCommand.getWellName(row, col);
                TreePath p = this.sourceService.getUI().getTreePathFromString(opm.getPlateName() + ">Wells>" + wellName);
                List sources = this.sourceService.getUI().getSourceAndConvertersFromTreePath(p);
                sources.forEach(source -> new BrightnessAdjuster(source, this.min_display_value, this.max_display_value).run());
                List<SourceAndConverterAndTimeRange> sourceAndTime = sources.stream().map(source -> new SourceAndConverterAndTimeRange(source, 0, opm.getRange().getRangeT().size())).collect(Collectors.toList());
                AffineTransform3D transform = new AffineTransform3D();
                if ((double)col * sizeX - originX < startX) {
                    startX = (double)col * sizeX - originX;
                }
                if ((double)row * sizeY - originY < startY) {
                    startY = (double)row * sizeY - originY;
                }
                transform.translate(new double[]{(double)col * sizeX - originX, (double)row * sizeY - originY, 0.5 * sizeZ - originZ});
                sourceAndTime.forEach(sat -> SourceTransformHelper.appendNewSpimdataTransformation((AffineTransform3D)transform, (SourceAndConverterAndTimeRange)sat));
            }
            IJ.log((String)"Done.");
            if (this.show) {
                BdvHandle bdvh = this.sourceDisplayService.getNewBdv();
                SourceAndConverter[] sources = this.sourceService.getSourceAndConverterFromSpimdata(asd).toArray(new SourceAndConverter[0]);
                this.sourceDisplayService.show(bdvh, sources);
                new ViewerTransformAdjuster(bdvh, sources).run();
                bdvh.getViewerPanel().state().getGroups();
                List groups = bdvh.getViewerPanel().state().getGroups();
                int maxChannels = Math.min(10, opm.getRange().getRangeC().size());
                for (int iCh = 0; iCh < maxChannels; ++iCh) {
                    SourceGroup group = (SourceGroup)groups.get(iCh);
                    SourceAndConverterServiceUI.Node chNode = this.sourceService.getUI().getRoot().child(opm.getPlateName()).child("Channel").child(iCh);
                    List<SourceAndConverter> sourcesInChannel = Arrays.asList(chNode.sources());
                    List sourcesCast = sourcesInChannel.stream().map(sac -> sac).collect(Collectors.toList());
                    bdvh.getViewerPanel().state().addSourcesToGroup(sourcesCast, group);
                    bdvh.getViewerPanel().state().setGroupName(group, chNode.name());
                }
                bdvh.getViewerPanel().setNumTimepoints(opm.getRange().getRangeT().size());
            }
            reader[0].close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getWellName(int row, int col) {
        return alphabet.substring(row - 1, row) + df.format(col);
    }

    private static enum XMLFILE {
        V5("Index.idx.xml", "PerkinElmer Harmony V5"),
        V5FLEX("Index.flex.xml", "PerkinElmer Harmony V5 Flatfield data"),
        V6("Index.xml", "PerkinElmer Harmony V6");

        private final String description;
        private final String indexFileName;

        private XMLFILE(String indexFileName, String description) {
            this.indexFileName = indexFileName;
            this.description = description;
        }

        private String getIndexFileName() {
            return this.indexFileName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

