/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import bdv.viewer.SourceAndConverter;
import ch.epfl.biop.bdv.img.OpenersToSpimData;
import ch.epfl.biop.bdv.img.bioformats.BioFormatsHelper;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import mpicbg.spim.data.generic.AbstractSpimData;
import net.imglib2.realtransform.AffineTransform3D;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterAndTimeRange;
import sc.fiji.bdvpg.sourceandconverter.SourceAndConverterHelper;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceTransformHelper;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDVDataset>Create BDV Dataset [Zeiss LLS7]", description="Open and live deskew a zeiss Lattice Light Sheet dataset with  Bio-Formats (BioFormats) and BigDataViewer")
public class LLS7OpenDatasetCommand
implements Command {
    public String unit = "MICROMETER";
    @Parameter(label="CZI LLS7 file")
    File czi_file;
    String plane_origin_convention = "TOP LEFT";
    @Parameter
    Context ctx;
    @Parameter
    boolean legacy_xy_mode;
    @Parameter
    SourceAndConverterService sac_service;

    public void run() {
        ArrayList<OpenerSettings> openerSettings = new ArrayList<OpenerSettings>();
        int nSeries = BioFormatsHelper.getNSeries((File)this.czi_file);
        for (int i = 0; i < nSeries; ++i) {
            openerSettings.add(OpenerSettings.BioFormats().location(this.czi_file).setSerie(i).unit(this.unit).splitRGBChannels(false).positionConvention(this.plane_origin_convention).cornerPositionConvention().context(this.ctx));
        }
        AbstractSpimData spimdata = OpenersToSpimData.getSpimData(openerSettings);
        this.sac_service.register(spimdata);
        this.sac_service.setSpimDataName(spimdata, FilenameUtils.removeExtension((String)this.czi_file.getName()));
        List sources = this.sac_service.getSourceAndConverterFromSpimdata(spimdata);
        int nTimepoints = SourceAndConverterHelper.getMaxTimepoint((SourceAndConverter)((SourceAndConverter)sources.get(0)));
        double angle = -1.0471975511965976;
        for (SourceAndConverter source : sources) {
            AffineTransform3D latticeTransform = new AffineTransform3D();
            latticeTransform.set(1.0, 0.0, 0.0, 0.0, 0.0, Math.cos(angle), 0.0, 0.0, 0.0, Math.sin(angle), -1.0, 0.0);
            AffineTransform3D rotateX = new AffineTransform3D();
            rotateX.rotate(0, 1.5707963267948966);
            latticeTransform.preConcatenate(rotateX);
            AffineTransform3D addOffset = new AffineTransform3D();
            source.getSpimSource().getSourceTransform(0, 0, addOffset);
            double ox = addOffset.get(0, 3);
            double oy = addOffset.get(1, 3);
            double oz = addOffset.get(2, 3);
            addOffset.identity();
            addOffset.set(ox, 0, 3);
            addOffset.set(oy, 1, 3);
            addOffset.set(oz, 2, 3);
            AffineTransform3D rmOffset = addOffset.inverse();
            latticeTransform.preConcatenate(addOffset);
            latticeTransform.concatenate(rmOffset);
            SourceTransformHelper.append((AffineTransform3D)latticeTransform, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(source, 0, nTimepoints));
        }
        String mipFileName = FilenameUtils.removeExtension((String)this.czi_file.getName()) + "_MIP.czi";
        File mipFile = new File(this.czi_file.getParent(), mipFileName);
        if (mipFile.exists()) {
            openerSettings = new ArrayList();
            nSeries = BioFormatsHelper.getNSeries((File)this.czi_file);
            AffineTransform3D scaleVoxZUp = new AffineTransform3D();
            scaleVoxZUp.scale(1.0, 1.0, 1000.0);
            for (int i = 0; i < nSeries; ++i) {
                openerSettings.add(OpenerSettings.BioFormats().location(mipFile).setSerie(i).unit(this.unit).splitRGBChannels(false).positionConvention(this.plane_origin_convention).cornerPositionConvention().setPositionPreTransform(scaleVoxZUp).context(this.ctx));
            }
            spimdata = OpenersToSpimData.getSpimData(openerSettings);
            this.sac_service.register(spimdata);
            this.sac_service.setSpimDataName(spimdata, FilenameUtils.removeExtension((String)mipFile.getName()));
            sources = this.sac_service.getSourceAndConverterFromSpimdata(spimdata);
            if (!this.legacy_xy_mode) {
                for (SourceAndConverter source : sources) {
                    AffineTransform3D ori = new AffineTransform3D();
                    source.getSpimSource().getSourceTransform(0, 0, ori);
                    double ox = ori.get(0, 3);
                    double oy = ori.get(1, 3);
                    double oz = ori.get(2, 3);
                    AffineTransform3D addOffset = new AffineTransform3D();
                    addOffset.identity();
                    addOffset.set(ox, 0, 3);
                    addOffset.set(oy, 1, 3);
                    addOffset.set(oz, 2, 3);
                    AffineTransform3D concatTr = new AffineTransform3D();
                    concatTr.set(ori.get(0, 0), 0, 1);
                    concatTr.set(-ori.get(1, 1), 1, 0);
                    concatTr.set(0.0, 0, 0);
                    concatTr.set(0.0, 1, 1);
                    concatTr.set(ori.get(2, 2), 2, 2);
                    AffineTransform3D shifty = new AffineTransform3D();
                    shifty.translate(new double[]{0.0, (double)source.getSpimSource().getSource(0, 0).max(0) * ori.get(1, 1), 0.0});
                    concatTr.preConcatenate(shifty);
                    concatTr.preConcatenate(addOffset);
                    concatTr.concatenate(ori.inverse());
                    SourceTransformHelper.append((AffineTransform3D)concatTr, (SourceAndConverterAndTimeRange)new SourceAndConverterAndTimeRange(source, 0, nTimepoints));
                }
            }
        }
    }
}

