/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.scijava.command.spimdata;

import bdv.tools.boundingbox.BoxSelectionOptions;
import bdv.tools.boundingbox.TransformedRealBoxSelectionDialog;
import bdv.util.Bdv;
import bdv.util.BdvFunctions;
import bdv.util.BdvHandle;
import bdv.viewer.SourceAndConverter;
import java.util.ArrayList;
import net.imglib2.FinalRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Intervals;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import sc.fiji.bdvpg.bdv.BdvHandleHelper;
import sc.fiji.bdvpg.bdv.navigate.ViewerTransformAdjuster;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterBdvDisplayService;
import sc.fiji.bdvpg.scijava.services.SourceAndConverterService;
import sc.fiji.bdvpg.sourceandconverter.importer.EmptySourceAndConverterCreator;
import sc.fiji.bdvpg.sourceandconverter.transform.SourceResampler;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer-Playground>BDV>LLS7 - Crop 3D")
public class LLS7CropCommand
implements Command {
    @Parameter
    BdvHandle bdvh;
    @Parameter
    String image_name;
    @Parameter
    SourceAndConverter<?>[] sources;
    String message = "Select the bounds of the 3D image";
    double box_size_x = 37.5;
    double box_size_y = 37.5;
    double box_size_z = 37.5;
    @Parameter(type=ItemIO.OUTPUT)
    RealInterval interval;
    @Parameter(type=ItemIO.OUTPUT)
    Boolean result;
    @Parameter
    SourceAndConverterService sac_service;
    @Parameter
    SourceAndConverterBdvDisplayService sac_display_service;

    public void run() {
        double[] center = BdvHandleHelper.getWindowCentreInCalibratedUnits((BdvHandle)this.bdvh);
        FinalRealInterval initialInterval = Intervals.createMinMaxReal((double[])new double[]{center[0] - this.box_size_x, center[1] - this.box_size_y, center[2] - this.box_size_z, center[0] + this.box_size_x, center[1] + this.box_size_y, center[2] + this.box_size_z});
        FinalRealInterval rangeInterval = Intervals.createMinMaxReal((double[])new double[]{center[0] - 5.0 * this.box_size_x, center[1] - 5.0 * this.box_size_y, center[2] - 5.0 * this.box_size_z, center[0] + 5.0 * this.box_size_x, center[1] + 5.0 * this.box_size_y, center[2] + 5.0 * this.box_size_z});
        TransformedRealBoxSelectionDialog.Result result = BdvFunctions.selectRealBox((Bdv)this.bdvh, (AffineTransform3D)new AffineTransform3D(), (RealInterval)initialInterval, (RealInterval)rangeInterval, (BoxSelectionOptions)BoxSelectionOptions.options().title(this.message));
        this.result = result.isValid();
        if (this.result.booleanValue()) {
            this.interval = result.getInterval();
            SourceAndConverter model = new EmptySourceAndConverterCreator(this.image_name, this.interval, 0.144, 0.144, 0.144).get();
            ArrayList<SourceAndConverter> generatedSources = new ArrayList<SourceAndConverter>();
            for (int iCh = 0; iCh < this.sources.length; ++iCh) {
                generatedSources.add(new SourceResampler(this.sources[iCh], model, this.image_name + "_ch_" + iCh, false, true, false, 0).get());
            }
            BdvHandle bdvHandle = this.sac_display_service.getNewBdv();
            for (SourceAndConverter source : generatedSources) {
                this.sac_service.register(source);
            }
            this.sac_display_service.show(bdvHandle, true, generatedSources.toArray(new SourceAndConverter[0]));
            new ViewerTransformAdjuster(bdvHandle, (SourceAndConverter)generatedSources.get(0)).run();
        }
    }
}

